package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainByCertificate invokes the dcdn.DescribeDcdnDomainByCertificate API synchronously
func (client *Client) DescribeDcdnDomainByCertificate(request *DescribeDcdnDomainByCertificateRequest) (response *DescribeDcdnDomainByCertificateResponse, err error) {
	response = CreateDescribeDcdnDomainByCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainByCertificateWithChan invokes the dcdn.DescribeDcdnDomainByCertificate API asynchronously
func (client *Client) DescribeDcdnDomainByCertificateWithChan(request *DescribeDcdnDomainByCertificateRequest) (<-chan *DescribeDcdnDomainByCertificateResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainByCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainByCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainByCertificateWithCallback invokes the dcdn.DescribeDcdnDomainByCertificate API asynchronously
func (client *Client) DescribeDcdnDomainByCertificateWithCallback(request *DescribeDcdnDomainByCertificateRequest, callback func(response *DescribeDcdnDomainByCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainByCertificateResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainByCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainByCertificateRequest is the request struct for api DescribeDcdnDomainByCertificate
type DescribeDcdnDomainByCertificateRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	SSLPub  string           `position:"Query" name:"SSLPub"`
}

// DescribeDcdnDomainByCertificateResponse is the response struct for api DescribeDcdnDomainByCertificate
type DescribeDcdnDomainByCertificateResponse struct {
	*responses.BaseResponse
	RequestId string                                     `json:"RequestId" xml:"RequestId"`
	CertInfos CertInfosInDescribeDcdnDomainByCertificate `json:"CertInfos" xml:"CertInfos"`
}

// CreateDescribeDcdnDomainByCertificateRequest creates a request to invoke DescribeDcdnDomainByCertificate API
func CreateDescribeDcdnDomainByCertificateRequest() (request *DescribeDcdnDomainByCertificateRequest) {
	request = &DescribeDcdnDomainByCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainByCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainByCertificateResponse creates a response to parse from DescribeDcdnDomainByCertificate response
func CreateDescribeDcdnDomainByCertificateResponse() (response *DescribeDcdnDomainByCertificateResponse) {
	response = &DescribeDcdnDomainByCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
