package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMergeRequest invokes the codeup.UpdateMergeRequest API synchronously
func (client *Client) UpdateMergeRequest(request *UpdateMergeRequestRequest) (response *UpdateMergeRequestResponse, err error) {
	response = CreateUpdateMergeRequestResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMergeRequestWithChan invokes the codeup.UpdateMergeRequest API asynchronously
func (client *Client) UpdateMergeRequestWithChan(request *UpdateMergeRequestRequest) (<-chan *UpdateMergeRequestResponse, <-chan error) {
	responseChan := make(chan *UpdateMergeRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMergeRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMergeRequestWithCallback invokes the codeup.UpdateMergeRequest API asynchronously
func (client *Client) UpdateMergeRequestWithCallback(request *UpdateMergeRequestRequest, callback func(response *UpdateMergeRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMergeRequestResponse
		var err error
		defer close(result)
		response, err = client.UpdateMergeRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMergeRequestRequest is the request struct for api UpdateMergeRequest
type UpdateMergeRequestRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	MergeRequestId requests.Integer `position:"Path" name:"MergeRequestId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// UpdateMergeRequestResponse is the response struct for api UpdateMergeRequest
type UpdateMergeRequestResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateUpdateMergeRequestRequest creates a request to invoke UpdateMergeRequest API
func CreateUpdateMergeRequestRequest() (request *UpdateMergeRequestRequest) {
	request = &UpdateMergeRequestRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "UpdateMergeRequest", "/api/v3/projects/[ProjectId]/merge_request/[MergeRequestId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateMergeRequestResponse creates a response to parse from UpdateMergeRequest response
func CreateUpdateMergeRequestResponse() (response *UpdateMergeRequestResponse) {
	response = &UpdateMergeRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
