/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShStringUtil;
import com.intellij.sh.run.ShBeforeRunProviderDelegate;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseOutputReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShRunConfigurationProfileState
implements RunProfileState {
    private final Project myProject;
    private final ShRunConfiguration myRunConfiguration;

    ShRunConfigurationProfileState(@NotNull Project project, @NotNull ShRunConfiguration runConfiguration) {
        if (project == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        ShRunner shRunner;
        if (runner == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(2);
        }
        EelDescriptor eelDescriptor = this.computeEelDescriptor();
        if (this.myRunConfiguration.isExecuteInTerminal() && !this.isRunBeforeConfig() && (shRunner = (ShRunner)ApplicationManager.getApplication().getService(ShRunner.class)) != null && shRunner.isAvailable(this.myProject)) {
            shRunner.run(this.myProject, this.buildCommand(eelDescriptor), this.myRunConfiguration.getScriptWorkingDirectory(), this.myRunConfiguration.getName(), this.isActivateToolWindow());
            return null;
        }
        return this.buildExecutionResult(eelDescriptor);
    }

    private boolean isActivateToolWindow() {
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)this.myProject).findSettings((RunConfiguration)this.myRunConfiguration);
        return settings == null || settings.isActivateToolWindowBeforeRun() || settings.isFocusToolWindowBeforeRun();
    }

    private ExecutionResult buildExecutionResult(@NotNull EelDescriptor eelDescriptor) throws ExecutionException {
        if (eelDescriptor == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(3);
        }
        GeneralCommandLine commandLine = this.myRunConfiguration.isExecuteScriptFile() ? this.createCommandLineForFile(eelDescriptor) : this.createCommandLineForScript(eelDescriptor);
        ProcessHandler processHandler = ShRunConfigurationProfileState.createProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        TerminalExecutionConsole console = new TerminalExecutionConsole(this.myProject, processHandler);
        console.attachToProcess(processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    private static ProcessHandler createProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        return new KillableProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forTerminalPtyProcess();
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sh/run/ShRunConfigurationProfileState$1", "readerOptions"));
            }
        };
    }

    @NotNull
    private GeneralCommandLine createCommandLineForScript(@NotNull EelDescriptor eelDescriptor) {
        if (eelDescriptor == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(4);
        }
        PtyCommandLine commandLine = new PtyCommandLine();
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withWorkingDirectory(Path.of(this.myRunConfiguration.getScriptWorkingDirectory(), new String[0]));
        commandLine.withExePath(ShRunConfigurationProfileState.convertPathUsingEel(ShConfigurationType.getDefaultShell(this.myProject), eelDescriptor));
        commandLine.withParameters(new String[]{"-c"});
        commandLine.withParameters(new String[]{this.myRunConfiguration.getScriptText()});
        PtyCommandLine ptyCommandLine = commandLine;
        if (ptyCommandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(5);
        }
        return ptyCommandLine;
    }

    @NotNull
    private GeneralCommandLine createCommandLineForFile(@NotNull EelDescriptor eelDescriptor) throws ExecutionException {
        VirtualFile virtualFile;
        if (eelDescriptor == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(6);
        }
        if ((virtualFile = LocalFileSystem.getInstance().findFileByPath(this.myRunConfiguration.getScriptPath())) == null || virtualFile.getParent() == null) {
            throw new ExecutionException(ShBundle.message("error.message.cannot.determine.shell.script.parent.directory", new Object[0]));
        }
        PtyCommandLine commandLine = new PtyCommandLine();
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withEnvironment(this.myRunConfiguration.getEnvData().getEnvs());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withWorkingDirectory(Path.of(this.myRunConfiguration.getScriptWorkingDirectory(), new String[0]));
        commandLine.setExePath(ShRunConfigurationProfileState.convertPathUsingEel(this.myRunConfiguration.getInterpreterPath(), eelDescriptor));
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getInterpreterOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getInterpreterOptions()));
        }
        commandLine.addParameter(ShRunConfigurationProfileState.convertPathUsingEel(this.myRunConfiguration.getScriptPath(), eelDescriptor));
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getScriptOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getScriptOptions()));
        }
        PtyCommandLine ptyCommandLine = commandLine;
        if (ptyCommandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(7);
        }
        return ptyCommandLine;
    }

    private boolean isRunBeforeConfig() {
        Key<Boolean> userDataKey = ShBeforeRunProviderDelegate.getRunBeforeUserDataKey((RunConfiguration)this.myRunConfiguration);
        Boolean userDataValue = (Boolean)this.myProject.getUserData(userDataKey);
        boolean isRunBeforeConfig = userDataValue != null && userDataValue != false;
        this.myRunConfiguration.getProject().putUserData(userDataKey, (Object)false);
        return isRunBeforeConfig;
    }

    @NotNull
    private String buildCommand(@NotNull EelDescriptor eelDescriptor) {
        if (eelDescriptor == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(8);
        }
        if (this.myRunConfiguration.isExecuteScriptFile()) {
            ArrayList<String> commandLine = new ArrayList<String>();
            ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getEnvData().getEnvs());
            ShRunConfigurationProfileState.addIfPresent(commandLine, ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getInterpreterPath(), eelDescriptor));
            ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getInterpreterOptions());
            commandLine.add(ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getScriptPath(), eelDescriptor));
            ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getScriptOptions());
            String string = String.join((CharSequence)" ", commandLine);
            if (string == null) {
                ShRunConfigurationProfileState.$$$reportNull$$$0(9);
            }
            return string;
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getEnvData().getEnvs(), true);
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getScriptText());
        String string = String.join((CharSequence)" ", commandLine);
        if (string == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(10);
        }
        return string;
    }

    private EelDescriptor computeEelDescriptor() {
        EelDescriptor eelDescriptor = null;
        if (!this.myRunConfiguration.getScriptWorkingDirectory().isEmpty()) {
            eelDescriptor = ShRunConfigurationProfileState.nullizeIfLocal(EelProviderUtil.getEelDescriptor((Path)Path.of(this.myRunConfiguration.getScriptWorkingDirectory(), new String[0])));
        }
        if (eelDescriptor == null && !this.myRunConfiguration.getInterpreterPath().isEmpty()) {
            eelDescriptor = ShRunConfigurationProfileState.nullizeIfLocal(EelProviderUtil.getEelDescriptor((Path)Path.of(this.myRunConfiguration.getInterpreterPath(), new String[0])));
        }
        if (eelDescriptor == null) {
            return EelProviderUtil.getEelDescriptor((Project)this.myProject);
        }
        return eelDescriptor;
    }

    @Nullable
    private static EelDescriptor nullizeIfLocal(@NotNull EelDescriptor eelDescriptor) {
        if (eelDescriptor == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(11);
        }
        if (eelDescriptor == LocalEelDescriptor.INSTANCE) {
            return null;
        }
        return eelDescriptor;
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @Nullable String options) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(12);
        }
        ContainerUtil.addIfNotNull(commandLine, (Object)StringUtil.nullize((String)options));
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @NotNull Map<String, String> envs) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(13);
        }
        if (envs == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(14);
        }
        ShRunConfigurationProfileState.addIfPresent(commandLine, envs, false);
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @NotNull Map<String, String> envs, boolean endWithSemicolon) {
        if (commandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(15);
        }
        if (envs == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(16);
        }
        int index = 0;
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String quotedString;
            String key = entry.getKey();
            String value = entry.getValue();
            if (Platform.current() != Platform.WINDOWS) {
                quotedString = ShStringUtil.quote(value);
            } else {
                String escapedValue = StringUtil.escapeQuotes((String)value);
                String string = quotedString = StringUtil.containsWhitespaces((CharSequence)value) ? (String)StringUtil.QUOTER.apply(escapedValue) : escapedValue;
            }
            if (endWithSemicolon) {
                String semicolon = "";
                if (index == envs.size() - 1) {
                    semicolon = ";";
                }
                commandLine.add("export " + key + "=" + quotedString + semicolon);
            } else {
                commandLine.add(key + "=" + quotedString);
            }
            ++index;
        }
    }

    private static String adaptPathForExecution(@NotNull String systemDependentPath, @NotNull EelDescriptor eelDescriptor) {
        if (systemDependentPath == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(17);
        }
        if (eelDescriptor == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(18);
        }
        systemDependentPath = ShRunConfigurationProfileState.convertPathUsingEel(systemDependentPath, eelDescriptor);
        return switch (eelDescriptor.getOsFamily()) {
            default -> throw new IncompatibleClassChangeError();
            case EelOsFamily.Windows -> ShStringUtil.quote(systemDependentPath);
            case EelOsFamily.Posix -> {
                String escapedPath = StringUtil.escapeQuotes((String)systemDependentPath);
                if (StringUtil.containsWhitespaces((CharSequence)systemDependentPath)) {
                    yield (String)StringUtil.QUOTER.apply(escapedPath);
                }
                yield escapedPath;
            }
        };
    }

    private static String convertPathUsingEel(@NotNull String path, @NotNull EelDescriptor eelDescriptor) {
        if (path == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(19);
        }
        if (eelDescriptor == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(20);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (eelDescriptor == LocalEelDescriptor.INSTANCE) {
            return path;
        }
        return EelNioBridgeServiceKt.asEelPath((Path)Path.of(path, new String[0])).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelDescriptor";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemDependentPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineForScript";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineForFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildExecutionResult";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineForScript";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildCommand";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nullizeIfLocal";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addIfPresent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "adaptPathForExecution";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertPathUsingEel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

