/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.intentions.DeclarationConflictChecker;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportToggleAliasIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.toggle.import.alias", new Object[0]);
        if (string == null) {
            ImportToggleAliasIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile psiFile) {
        if (project == null) {
            ImportToggleAliasIntention.$$$reportNull$$$0(1);
        }
        if (!(psiFile instanceof PyFile)) {
            return false;
        }
        IntentionState state = IntentionState.fromContext(editor2, psiFile);
        this.setText(state.getText());
        return state.isAvailable();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ImportToggleAliasIntention.$$$reportNull$$$0(2);
        }
        return currentFile;
    }

    @Override
    public void doInvoke(final @NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ImportToggleAliasIntention.$$$reportNull$$$0(3);
        }
        IntentionState state = IntentionState.fromContext(editor2, file);
        PyReferenceExpression reference = PyUtil.sure(state.myImportElement.getImportReferenceExpression());
        try {
            String remove_name;
            String target_name;
            String imported_name = PyPsiUtils.toPath(reference);
            if (state.myAlias != null) {
                target_name = imported_name;
                remove_name = state.myAlias;
            } else {
                String alias = PythonUiService.getInstance().showInputDialog(project, PyPsiBundle.message("INTN.add.import.alias.dialog.message", imported_name), PyPsiBundle.message("INTN.add.import.alias.title", new Object[0]), "", new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return PyNames.isIdentifier((String)inputString);
                    }

                    public boolean canClose(String inputString) {
                        return PyNames.isIdentifier((String)inputString);
                    }
                });
                if (alias == null) {
                    return;
                }
                target_name = alias;
                remove_name = imported_name;
            }
            final PsiElement referee = reference.getReference().resolve();
            if (referee != null) {
                final ArrayList references2 = new ArrayList();
                ScopeOwner scope = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)state.myImportElement, ScopeOwner.class);
                PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

                    public boolean execute(@NotNull PsiElement element) {
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        this.getReferences(element);
                        if (element instanceof PyStringLiteralExpression) {
                            PyStringLiteralExpression host = (PyStringLiteralExpression)element;
                            List files = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
                            if (files != null) {
                                for (Pair pair : files) {
                                    PsiElement first = (PsiElement)pair.getFirst();
                                    if (!(first instanceof ScopeOwner)) continue;
                                    ScopeOwner scopeOwner = (ScopeOwner)first;
                                    PsiTreeUtil.processElements((PsiElement)scopeOwner, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

                                        public boolean execute(@NotNull PsiElement element) {
                                            if (element == null) {
                                                1.$$$reportNull$$$0(0);
                                            }
                                            this.getReferences(element);
                                            return true;
                                        }

                                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention$2$1", "execute"));
                                        }
                                    });
                                }
                            }
                        }
                        return true;
                    }

                    private void getReferences(PsiElement element) {
                        if (element instanceof PyReferenceExpression) {
                            PsiElement resolved;
                            PyReferenceExpression ref = (PyReferenceExpression)element;
                            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class) == null && remove_name.equals(PyPsiUtils.toPath(ref)) && ((resolved = ref.getReference().resolve()) == referee || resolved instanceof PyFunction && PyUtil.turnConstructorIntoClass((PyFunction)resolved) == referee)) {
                                references2.add(ref.getReference());
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention$2", "execute"));
                    }
                });
                if (PythonUiService.getInstance().showConflicts(project, DeclarationConflictChecker.findDefinitions(target_name, references2, Collections.emptySet()), target_name, null)) {
                    return;
                }
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)state.myImportElement);
                if (state.myAlias != null) {
                    WriteAction.run(() -> {
                        ASTNode node = PyUtil.sure(state.myImportElement.getNode());
                        ASTNode parent = PyUtil.sure(node.getTreeParent());
                        node = PyUtil.sure(node.getFirstChildNode());
                        node = PyUtil.sure(node.getTreeNext());
                        parent.removeRange(node, null);
                    });
                } else {
                    WriteAction.run(() -> {
                        ASTNode my_ielt_node = PyUtil.sure(state.myImportElement.getNode());
                        PyImportElement fountain = (PyImportElement)generator.createFromText(languageLevel, PyImportElement.class, "import foo as " + target_name, new int[]{0, 2});
                        ASTNode graft_node = PyUtil.sure(fountain.getNode());
                        graft_node = PyUtil.sure(graft_node.getFirstChildNode());
                        graft_node = PyUtil.sure(graft_node.getTreeNext());
                        my_ielt_node.addChild((ASTNode)graft_node.clone());
                        graft_node = PyUtil.sure(graft_node.getTreeNext());
                        my_ielt_node.addChild((ASTNode)graft_node.clone());
                        graft_node = PyUtil.sure(graft_node.getTreeNext());
                        my_ielt_node.addChild((ASTNode)graft_node.clone());
                        graft_node = PyUtil.sure(graft_node.getTreeNext());
                        my_ielt_node.addChild((ASTNode)graft_node.clone());
                    });
                }
                for (PsiReference ref : references2) {
                    ASTNode ref_name_node = PyUtil.sure(PyUtil.sure(ref.getElement()).getNode());
                    ASTNode parent = PyUtil.sure(ref_name_node.getTreeParent());
                    ASTNode new_name_node = generator.createExpressionFromText(languageLevel, target_name).getNode();
                    assert (new_name_node != null);
                    WriteAction.run(() -> parent.replaceChild(ref_name_node, new_name_node));
                }
            }
        }
        catch (IncorrectOperationException ignored) {
            PythonUiService.getInstance().showBalloonWarning(project, PyPsiBundle.message("QFIX.action.failed", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class IntentionState {
        private PyImportElement myImportElement;
        private PyFromImportStatement myFromImportStatement;
        private PyImportStatement myImportStatement;
        private String myAlias;

        private IntentionState() {
        }

        private static IntentionState fromContext(Editor editor2, PsiFile file) {
            IntentionState state = new IntentionState();
            state.myImportElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyImportElement.class);
            PyPsiUtils.assertValid((PsiElement)state.myImportElement);
            if (state.myImportElement != null) {
                PyTargetExpression target = state.myImportElement.getAsNameElement();
                PyPsiUtils.assertValid(target);
                state.myAlias = target != null ? target.getName() : null;
                state.myFromImportStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)state.myImportElement, PyFromImportStatement.class);
                state.myImportStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)state.myImportElement, PyImportStatement.class);
            }
            return state;
        }

        public boolean isAvailable() {
            PyReferenceExpression referenceExpression;
            if (this.myFromImportStatement != null) {
                PyPsiUtils.assertValid((PsiElement)this.myFromImportStatement);
                if (!this.myFromImportStatement.isValid() || this.myFromImportStatement.isFromFuture()) {
                    return false;
                }
            } else {
                PyPsiUtils.assertValid((PsiElement)this.myImportStatement);
                if (this.myImportStatement == null || !this.myImportStatement.isValid()) {
                    return false;
                }
            }
            return (referenceExpression = this.myImportElement.getImportReferenceExpression()) != null && referenceExpression.getReference().resolve() != null;
        }

        @NotNull
        @IntentionName
        public String getText() {
            PyReferenceExpression refex;
            String add_name = PyPsiBundle.message("INTN.add.import.alias", new Object[0]);
            if (this.myImportElement != null && (refex = this.myImportElement.getImportReferenceExpression()) != null) {
                add_name = PyPsiBundle.message("INTN.add.import.alias.to.name", refex.getText());
            }
            String string = this.myAlias == null ? add_name : PyPsiBundle.message("INTN.remove.import.alias", this.myAlias);
            if (string == null) {
                IntentionState.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention$IntentionState", "getText"));
        }
    }
}

