package vulnerability

import (
	"time"
)

type Metadata struct {
	ID             string
	DataSource     string // the primary reference URL, i.e. where the data originated
	Namespace      string
	Severity       string
	URLs           []string // secondary reference URLs a vulnerability may provide
	Description    string
	Cvss           []Cvss
	KnownExploited []KnownExploited
	EPSS           []EPSS
}

type Cvss struct {
	Source         string
	Type           string
	Version        string
	Vector         string
	Metrics        CvssMetrics
	VendorMetadata interface{}
}

type CvssMetrics struct {
	BaseScore           float64
	ExploitabilityScore *float64
	ImpactScore         *float64
}

type KnownExploited struct {
	CVE                        string
	VendorProject              string
	Product                    string
	DateAdded                  *time.Time
	RequiredAction             string
	DueDate                    *time.Time
	KnownRansomwareCampaignUse string
	Notes                      string
	URLs                       []string
	CWEs                       []string
}

type EPSS struct {
	CVE        string
	EPSS       float64
	Percentile float64
	Date       time.Time
}
