// Deprecated: Please note, this package has been deprecated. A replacement package is available [github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights](https://pkg.go.dev/github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights). We strongly encourage you to upgrade to continue receiving updates. See [Migration Guide](https://aka.ms/azsdk/golang/t2/migration) for guidance on upgrading. Refer to our [deprecation policy](https://azure.github.io/azure-sdk/policies_support.html) for more details.
//
// Package operationalinsights implements the Azure ARM Operationalinsights service API version 2015-11-01-preview.
//
// Operational Insights Client
package operationalinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service Operationalinsights
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Operationalinsights.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	SubscriptionID string
}

// New creates an instance of the BaseClient client.
func New(subscriptionID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		SubscriptionID: subscriptionID,
	}
}

// GetAsyncOperationsStatus get the status of an azure asynchronous operation.
// Parameters:
// location - the region name of operation.
// asyncOperationID - the operation Id.
func (client BaseClient) GetAsyncOperationsStatus(ctx context.Context, location string, asyncOperationID string) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAsyncOperationsStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAsyncOperationsStatusPreparer(ctx, location, asyncOperationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.BaseClient", "GetAsyncOperationsStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAsyncOperationsStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "operationalinsights.BaseClient", "GetAsyncOperationsStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetAsyncOperationsStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.BaseClient", "GetAsyncOperationsStatus", resp, "Failure responding to request")
		return
	}

	return
}

// GetAsyncOperationsStatusPreparer prepares the GetAsyncOperationsStatus request.
func (client BaseClient) GetAsyncOperationsStatusPreparer(ctx context.Context, location string, asyncOperationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"asyncOperationId": autorest.Encode("path", asyncOperationID),
		"location":         autorest.Encode("path", location),
		"subscriptionId":   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.OperationalInsights/locations/{location}/operationStatuses/{asyncOperationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAsyncOperationsStatusSender sends the GetAsyncOperationsStatus request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAsyncOperationsStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAsyncOperationsStatusResponder handles the response to the GetAsyncOperationsStatus request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAsyncOperationsStatusResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
