# Copyright 2023-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.6.2

EAPI=8

CRATES="
"

inherit cargo

DESCRIPTION="The fastest and safest AV1 encoder"
HOMEPAGE="https://github.com/xiph/rav1e/"
if [[ ${PV} == *9999 ]] ; then
	EGIT_REPO_URI="https://github.com/xiph/rav1e.git"
	inherit git-r3
else
	SRC_URI="
		https://github.com/xiph/rav1e/archive/v${PV}.tar.gz -> ${P}.tar.gz
		${CARGO_CRATE_URIS}
	"
	KEYWORDS="~amd64 ~arm ~arm64 ~loong ~ppc64 ~riscv ~x86"
fi

SRC_URI+="
	https://github.com/gentoo-crate-dist/${PN}/releases/download/v${PV}/${P}-crates.tar.xz
"

LICENSE="BSD-2"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD-2 BSD ISC MIT
	UoI-NCSA Unicode-3.0
"
SLOT="0/$(ver_cut 1-2)"
IUSE="+capi"

ASM_DEP=">=dev-lang/nasm-2.15"
BDEPEND="
	amd64? ( ${ASM_DEP} )
	capi? ( >=dev-util/cargo-c-0.6.3 )
"
# only used as a build script to check the version of rav1e...
DEPEND="dev-libs/libgit2"

# Rust
QA_FLAGS_IGNORED="usr/lib.*/librav1e.* usr/bin/rav1e"

src_unpack() {
	if [[ ${PV} == *9999* ]]; then
		git-r3_src_unpack
		cargo_live_src_unpack
	else
		default
		cargo_src_unpack
	fi
}

src_compile() {
	# used by build script to get rav1e repository info
	export LIBGIT2_NO_VENDOR=1

	cargo_src_compile

	if use capi; then
		local args=$(usev !debug --release)
		cargo cbuild ${args} --target-dir="capi" \
			--prefix="${EPREFIX}/usr" --libdir="${EPREFIX}/usr/$(get_libdir)" \
			--library-type=cdylib \
			|| die "cargo cbuild failed"
	fi
}

src_install() {
	export CARGO_HOME="${ECARGO_HOME}"
	local args=$(usev debug --debug)

	if use capi; then
		cargo cinstall ${args} --target-dir="capi" \
			--prefix="${EPREFIX}/usr" --libdir="${EPREFIX}/usr/$(get_libdir)" --destdir="${D}" \
			--library-type=cdylib \
			|| die "cargo cinstall failed"
	fi

	cargo_src_install
}
