# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Parsing and evaluating typst syntax"
HOMEPAGE="https://hackage.haskell.org/package/typst"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="executable"

RESTRICT=test # one test case fails

RDEPEND="dev-haskell/aeson:=[profile?]
	dev-haskell/cassava:=[profile?]
	dev-haskell/digits:=[profile?]
	dev-haskell/ordered-containers:=[profile?]
	dev-haskell/parsec:=[profile?]
	dev-haskell/regex-tdfa:=[profile?]
	dev-haskell/scientific:=[profile?]
	dev-haskell/text:=[profile?]
	>=dev-haskell/toml-parser-1.3.0.0:=[profile?] <dev-haskell/toml-parser-1.4:=[profile?]
	>=dev-haskell/typst-symbols-0.1.4:=[profile?] <dev-haskell/typst-symbols-0.1.5:=[profile?]
	dev-haskell/vector:=[profile?]
	dev-haskell/xml-conduit:=[profile?]
	dev-haskell/yaml:=[profile?]
	>=dev-lang/ghc-8.10.1:=
	executable? ( dev-haskell/pretty-show:=[profile?] )
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.2.0.0
	test? ( dev-haskell/tasty
		dev-haskell/tasty-golden
		!executable? ( dev-haskell/pretty-show ) )
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag executable executable)
}
