# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Haskell implementation of a javascript minifier"
HOMEPAGE="https://github.com/erikd/hjsmin"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"

PATCHES=(
	"${FILESDIR}/${PN}-0.2.0.4-fix-tests.patch"
)

CABAL_CHDEPS=(
	'text                    >= 2' 'text                    >= 1.2.5.0'
)

RDEPEND=">=dev-haskell/language-javascript-0.6:=[profile?] <dev-haskell/language-javascript-0.8:=[profile?]
	>=dev-haskell/optparse-applicative-0.7:=[profile?]
	>=dev-haskell/text-1.2.5.0:=[profile?]
	>=dev-lang/ghc-9.2.4:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.6.3.0
	test? ( dev-haskell/extra )
"

src_prepare() {
	# Tests need exec permissions on these files
	local files=(
		"test/cli/minimal-input/run"
		"test/cli/empty-input/run"
	)
	chmod -v +x "${files[@]}"

	haskell-cabal_src_prepare
}
