/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public final class ShingleFilter
extends TokenFilter {
    private LinkedList<AttributeSource.State> shingleBuf = new LinkedList();
    private StringBuilder[] shingles;
    private String tokenType = "shingle";
    public static final char[] FILLER_TOKEN = new char[]{'_'};
    public static final int DEFAULT_MAX_SHINGLE_SIZE = 2;
    public static final String TOKEN_SEPARATOR = " ";
    private boolean outputUnigrams = true;
    private int maxShingleSize;
    private AttributeSource.State nextToken;
    private int shingleBufferPosition;
    private int[] endOffsets;
    private int numFillerTokensToInsert;
    private AttributeSource.State currentToken;
    private boolean hasCurrentToken;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private PositionIncrementAttribute posIncrAtt;
    private TypeAttribute typeAtt;

    public ShingleFilter(TokenStream input, int maxShingleSize) {
        super(input);
        this.setMaxShingleSize(maxShingleSize);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public ShingleFilter(TokenStream input) {
        this(input, 2);
    }

    public ShingleFilter(TokenStream input, String tokenType) {
        this(input, 2);
        this.setTokenType(tokenType);
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setOutputUnigrams(boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
    }

    public void setMaxShingleSize(int maxShingleSize) {
        if (maxShingleSize < 2) {
            throw new IllegalArgumentException("Max shingle size must be >= 2");
        }
        this.shingles = new StringBuilder[maxShingleSize];
        for (int i = 0; i < this.shingles.length; ++i) {
            this.shingles[i] = new StringBuilder();
        }
        this.maxShingleSize = maxShingleSize;
    }

    private void clearShingles() {
        for (int i = 0; i < this.shingles.length; ++i) {
            this.shingles[i].setLength(0);
        }
    }

    public final boolean incrementToken() throws IOException {
        while (this.nextToken != null || this.fillShingleBuffer()) {
            this.nextToken = this.shingleBuf.getFirst();
            if (this.outputUnigrams) {
                if (this.shingleBufferPosition == 0) {
                    this.restoreState(this.nextToken);
                    this.posIncrAtt.setPositionIncrement(1);
                    ++this.shingleBufferPosition;
                    return true;
                }
            } else {
                ++this.shingleBufferPosition;
            }
            if (this.shingleBufferPosition < this.shingleBuf.size()) {
                this.restoreState(this.nextToken);
                this.typeAtt.setType(this.tokenType);
                this.offsetAtt.setOffset(this.offsetAtt.startOffset(), this.endOffsets[this.shingleBufferPosition]);
                StringBuilder buf = this.shingles[this.shingleBufferPosition];
                int termLength = buf.length();
                char[] termBuffer = this.termAtt.termBuffer();
                if (termBuffer.length < termLength) {
                    termBuffer = this.termAtt.resizeTermBuffer(termLength);
                }
                buf.getChars(0, termLength, termBuffer, 0);
                this.termAtt.setTermLength(termLength);
                if (!this.outputUnigrams && this.shingleBufferPosition == 1) {
                    this.posIncrAtt.setPositionIncrement(1);
                } else {
                    this.posIncrAtt.setPositionIncrement(0);
                }
                ++this.shingleBufferPosition;
                if (this.shingleBufferPosition == this.shingleBuf.size()) {
                    this.nextToken = null;
                    this.shingleBufferPosition = 0;
                }
                return true;
            }
            this.nextToken = null;
            this.shingleBufferPosition = 0;
        }
        return false;
    }

    private boolean getNextToken() throws IOException {
        while (true) {
            if (this.numFillerTokensToInsert > 0) {
                if (this.currentToken == null) {
                    this.currentToken = this.captureState();
                } else {
                    this.restoreState(this.currentToken);
                }
                --this.numFillerTokensToInsert;
                this.offsetAtt.setOffset(this.offsetAtt.startOffset(), this.offsetAtt.startOffset());
                this.termAtt.setTermBuffer(FILLER_TOKEN, 0, FILLER_TOKEN.length);
                return true;
            }
            if (this.hasCurrentToken) {
                if (this.currentToken != null) {
                    this.restoreState(this.currentToken);
                    this.currentToken = null;
                }
                this.hasCurrentToken = false;
                return true;
            }
            if (!this.input.incrementToken()) {
                return false;
            }
            this.hasCurrentToken = true;
            if (this.posIncrAtt.getPositionIncrement() <= 1) continue;
            this.numFillerTokensToInsert = this.posIncrAtt.getPositionIncrement() - 1;
        }
    }

    private boolean fillShingleBuffer() throws IOException {
        int i;
        boolean addedToken = false;
        while (this.getNextToken()) {
            this.shingleBuf.add(this.captureState());
            if (this.shingleBuf.size() > this.maxShingleSize) {
                this.shingleBuf.removeFirst();
            }
            addedToken = true;
            if (this.shingleBuf.size() < this.maxShingleSize) continue;
        }
        if (this.shingleBuf.isEmpty()) {
            return false;
        }
        if (!addedToken) {
            this.shingleBuf.removeFirst();
        }
        if (this.shingleBuf.isEmpty()) {
            return false;
        }
        this.clearShingles();
        this.endOffsets = new int[this.shingleBuf.size()];
        for (i = 0; i < this.endOffsets.length; ++i) {
            this.endOffsets[i] = 0;
        }
        i = 0;
        Iterator it = this.shingleBuf.iterator();
        while (it.hasNext()) {
            this.restoreState((AttributeSource.State)it.next());
            for (int j = i; j < this.shingles.length; ++j) {
                if (this.shingles[j].length() != 0) {
                    this.shingles[j].append(TOKEN_SEPARATOR);
                }
                this.shingles[j].append(this.termAtt.termBuffer(), 0, this.termAtt.termLength());
            }
            this.endOffsets[i] = this.offsetAtt.endOffset();
            ++i;
        }
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.nextToken = null;
        this.shingleBufferPosition = 0;
        this.shingleBuf.clear();
        this.numFillerTokensToInsert = 0;
        this.currentToken = null;
        this.hasCurrentToken = false;
    }
}

