/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class MetadataExtractor
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName c_metadata = new QName("c", "http://www.w3.org/ns/xproc-step", "metadata");
    private static final QName c_tag = new QName("c", "http://www.w3.org/ns/xproc-step", "tag");
    private static final QName _dir = new QName("", "dir");
    private static final QName _type = new QName("", "type");
    private static final QName _name = new QName("", "name");
    private static final QName _error = new QName("", "error");
    private WritablePipe result = null;

    public MetadataExtractor(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        URI href = this.getOption(_href).getBaseURI().resolve(this.getOption(_href).getString());
        try {
            URL url = href.toURL();
            URLConnection connection = url.openConnection();
            InputStream stream = connection.getInputStream();
            Metadata metadata = JpegMetadataReader.readMetadata((InputStream)stream);
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(c_metadata);
            tree.addAttribute(_href, href.toASCIIString());
            tree.startContent();
            Iterator directories = metadata.getDirectoryIterator();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                String dir = directory.getName();
                Iterator tags = directory.getTagIterator();
                while (tags.hasNext()) {
                    Tag tag = (Tag)tags.next();
                    tree.addStartElement(c_tag);
                    tree.addAttribute(_dir, dir);
                    tree.addAttribute(_type, tag.getTagTypeHex());
                    tree.addAttribute(_name, tag.getTagName());
                    String value = "";
                    try {
                        value = tag.getDescription();
                    }
                    catch (MetadataException me) {
                        tree.addAttribute(_error, me.toString());
                    }
                    if (value.matches("^\\d\\d\\d\\d:\\d\\d:\\d\\d \\d\\d:\\d\\d:\\d\\d$")) {
                        String iso;
                        value = iso = value.substring(0, 4) + "-" + value.substring(5, 7) + "-" + value.substring(8, 10) + "T" + value.substring(11, 19);
                    }
                    tree.startContent();
                    tree.addText(value);
                    tree.addEndElement();
                }
            }
            tree.addEndElement();
            tree.endDocument();
            this.result.write(tree.getResult());
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        catch (JpegProcessingException e) {
            this.runIntrinsics(href);
        }
    }

    private void runIntrinsics(URI href) throws SaxonApiException {
        ImageIntrinsics intrinsics = new ImageIntrinsics();
        intrinsics.run(href.toASCIIString());
    }

    private class ImageIntrinsics
    implements ImageObserver {
        boolean imageLoaded = false;
        boolean imageFailed = false;
        Image image = null;
        int width = -1;
        int depth = -1;

        private ImageIntrinsics() {
        }

        public void run(String imageFn) {
            this.imageLoaded = false;
            this.imageFailed = false;
            this.image = null;
            this.width = -1;
            this.depth = -1;
            System.setProperty("java.awt.headless", "true");
            try {
                URL url = new URL(imageFn);
                this.image = Toolkit.getDefaultToolkit().getImage(url);
            }
            catch (MalformedURLException mue) {
                this.image = Toolkit.getDefaultToolkit().getImage(imageFn);
            }
            this.width = this.image.getWidth(this);
            this.depth = this.image.getHeight(this);
            while (!(this.imageFailed || this.width != -1 && this.depth != -1)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.width = this.image.getWidth(this);
                this.depth = this.image.getHeight(this);
            }
            this.image.flush();
            if ((this.width == -1 || this.depth == -1) && this.imageFailed) {
                BufferedReader ir = null;
                String line = null;
                int lineLimit = 100;
                try {
                    ir = new BufferedReader(new FileReader(new File(imageFn)));
                    line = ir.readLine();
                    if (line != null && line.startsWith("%PDF-")) {
                        while (lineLimit > 0 && line != null) {
                            --lineLimit;
                            if (line.startsWith("/CropBox [")) {
                                if ((line = line.substring(10)).indexOf("]") >= 0) {
                                    line = line.substring(0, line.indexOf("]"));
                                }
                                this.parseBox(line);
                                lineLimit = 0;
                            }
                            line = ir.readLine();
                        }
                    } else if (line != null && line.startsWith("%!") && line.indexOf(" EPSF-") > 0) {
                        while (lineLimit > 0 && line != null) {
                            --lineLimit;
                            if (line.startsWith("%%BoundingBox: ")) {
                                line = line.substring(15);
                                this.parseBox(line);
                                lineLimit = 0;
                            }
                            line = ir.readLine();
                        }
                    } else {
                        System.err.println("Failed to interpret image: " + imageFn);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to load image: " + imageFn);
                }
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (this.width < 0) {
                throw new XProcException("Failed to read image intrinsics");
            }
            TreeWriter tree = new TreeWriter(MetadataExtractor.this.runtime);
            tree.startDocument(MetadataExtractor.this.step.getNode().getBaseURI());
            tree.addStartElement(c_metadata);
            tree.addAttribute(_href, imageFn);
            tree.startContent();
            tree.addStartElement(c_tag);
            tree.addAttribute(_dir, "Exif");
            tree.addAttribute(_type, "0x9000");
            tree.addAttribute(_name, "Exif Version");
            tree.startContent();
            tree.addText("0");
            tree.addEndElement();
            tree.addStartElement(c_tag);
            tree.addAttribute(_dir, "Jpeg");
            tree.addAttribute(_type, "0x0001");
            tree.addAttribute(_name, "Image Height");
            tree.startContent();
            tree.addText("" + this.depth + " pixels");
            tree.addEndElement();
            tree.addStartElement(c_tag);
            tree.addAttribute(_dir, "Jpeg");
            tree.addAttribute(_type, "0x0003");
            tree.addAttribute(_name, "Image Width");
            tree.startContent();
            tree.addText("" + this.width + " pixels");
            tree.addEndElement();
            tree.endDocument();
            MetadataExtractor.this.result.write(tree.getResult());
        }

        private void parseBox(String line) {
            int[] corners = new int[4];
            int count = 0;
            StringTokenizer st = new StringTokenizer(line);
            while (count < 4 && st.hasMoreTokens()) {
                try {
                    corners[count++] = Integer.parseInt(st.nextToken());
                }
                catch (Exception e) {}
            }
            this.width = corners[2] - corners[0];
            this.depth = corners[3] - corners[1];
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x40) == 64 || (infoflags & 0x80) == 128) {
                this.imageFailed = true;
                return false;
            }
            return (infoflags & 0x20) != 32;
        }
    }
}

