// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package bedrockagentiface provides an interface to enable mocking the Agents for Amazon Bedrock service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package bedrockagentiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/bedrockagent"
)

// BedrockAgentAPI provides an interface to enable mocking the
// bedrockagent.BedrockAgent service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Agents for Amazon Bedrock.
//	func myFunc(svc bedrockagentiface.BedrockAgentAPI) bool {
//	    // Make svc.AssociateAgentKnowledgeBase request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := bedrockagent.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockBedrockAgentClient struct {
//	    bedrockagentiface.BedrockAgentAPI
//	}
//	func (m *mockBedrockAgentClient) AssociateAgentKnowledgeBase(input *bedrockagent.AssociateAgentKnowledgeBaseInput) (*bedrockagent.AssociateAgentKnowledgeBaseOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockBedrockAgentClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type BedrockAgentAPI interface {
	AssociateAgentKnowledgeBase(*bedrockagent.AssociateAgentKnowledgeBaseInput) (*bedrockagent.AssociateAgentKnowledgeBaseOutput, error)
	AssociateAgentKnowledgeBaseWithContext(aws.Context, *bedrockagent.AssociateAgentKnowledgeBaseInput, ...request.Option) (*bedrockagent.AssociateAgentKnowledgeBaseOutput, error)
	AssociateAgentKnowledgeBaseRequest(*bedrockagent.AssociateAgentKnowledgeBaseInput) (*request.Request, *bedrockagent.AssociateAgentKnowledgeBaseOutput)

	CreateAgent(*bedrockagent.CreateAgentInput) (*bedrockagent.CreateAgentOutput, error)
	CreateAgentWithContext(aws.Context, *bedrockagent.CreateAgentInput, ...request.Option) (*bedrockagent.CreateAgentOutput, error)
	CreateAgentRequest(*bedrockagent.CreateAgentInput) (*request.Request, *bedrockagent.CreateAgentOutput)

	CreateAgentActionGroup(*bedrockagent.CreateAgentActionGroupInput) (*bedrockagent.CreateAgentActionGroupOutput, error)
	CreateAgentActionGroupWithContext(aws.Context, *bedrockagent.CreateAgentActionGroupInput, ...request.Option) (*bedrockagent.CreateAgentActionGroupOutput, error)
	CreateAgentActionGroupRequest(*bedrockagent.CreateAgentActionGroupInput) (*request.Request, *bedrockagent.CreateAgentActionGroupOutput)

	CreateAgentAlias(*bedrockagent.CreateAgentAliasInput) (*bedrockagent.CreateAgentAliasOutput, error)
	CreateAgentAliasWithContext(aws.Context, *bedrockagent.CreateAgentAliasInput, ...request.Option) (*bedrockagent.CreateAgentAliasOutput, error)
	CreateAgentAliasRequest(*bedrockagent.CreateAgentAliasInput) (*request.Request, *bedrockagent.CreateAgentAliasOutput)

	CreateDataSource(*bedrockagent.CreateDataSourceInput) (*bedrockagent.CreateDataSourceOutput, error)
	CreateDataSourceWithContext(aws.Context, *bedrockagent.CreateDataSourceInput, ...request.Option) (*bedrockagent.CreateDataSourceOutput, error)
	CreateDataSourceRequest(*bedrockagent.CreateDataSourceInput) (*request.Request, *bedrockagent.CreateDataSourceOutput)

	CreateKnowledgeBase(*bedrockagent.CreateKnowledgeBaseInput) (*bedrockagent.CreateKnowledgeBaseOutput, error)
	CreateKnowledgeBaseWithContext(aws.Context, *bedrockagent.CreateKnowledgeBaseInput, ...request.Option) (*bedrockagent.CreateKnowledgeBaseOutput, error)
	CreateKnowledgeBaseRequest(*bedrockagent.CreateKnowledgeBaseInput) (*request.Request, *bedrockagent.CreateKnowledgeBaseOutput)

	DeleteAgent(*bedrockagent.DeleteAgentInput) (*bedrockagent.DeleteAgentOutput, error)
	DeleteAgentWithContext(aws.Context, *bedrockagent.DeleteAgentInput, ...request.Option) (*bedrockagent.DeleteAgentOutput, error)
	DeleteAgentRequest(*bedrockagent.DeleteAgentInput) (*request.Request, *bedrockagent.DeleteAgentOutput)

	DeleteAgentActionGroup(*bedrockagent.DeleteAgentActionGroupInput) (*bedrockagent.DeleteAgentActionGroupOutput, error)
	DeleteAgentActionGroupWithContext(aws.Context, *bedrockagent.DeleteAgentActionGroupInput, ...request.Option) (*bedrockagent.DeleteAgentActionGroupOutput, error)
	DeleteAgentActionGroupRequest(*bedrockagent.DeleteAgentActionGroupInput) (*request.Request, *bedrockagent.DeleteAgentActionGroupOutput)

	DeleteAgentAlias(*bedrockagent.DeleteAgentAliasInput) (*bedrockagent.DeleteAgentAliasOutput, error)
	DeleteAgentAliasWithContext(aws.Context, *bedrockagent.DeleteAgentAliasInput, ...request.Option) (*bedrockagent.DeleteAgentAliasOutput, error)
	DeleteAgentAliasRequest(*bedrockagent.DeleteAgentAliasInput) (*request.Request, *bedrockagent.DeleteAgentAliasOutput)

	DeleteAgentVersion(*bedrockagent.DeleteAgentVersionInput) (*bedrockagent.DeleteAgentVersionOutput, error)
	DeleteAgentVersionWithContext(aws.Context, *bedrockagent.DeleteAgentVersionInput, ...request.Option) (*bedrockagent.DeleteAgentVersionOutput, error)
	DeleteAgentVersionRequest(*bedrockagent.DeleteAgentVersionInput) (*request.Request, *bedrockagent.DeleteAgentVersionOutput)

	DeleteDataSource(*bedrockagent.DeleteDataSourceInput) (*bedrockagent.DeleteDataSourceOutput, error)
	DeleteDataSourceWithContext(aws.Context, *bedrockagent.DeleteDataSourceInput, ...request.Option) (*bedrockagent.DeleteDataSourceOutput, error)
	DeleteDataSourceRequest(*bedrockagent.DeleteDataSourceInput) (*request.Request, *bedrockagent.DeleteDataSourceOutput)

	DeleteKnowledgeBase(*bedrockagent.DeleteKnowledgeBaseInput) (*bedrockagent.DeleteKnowledgeBaseOutput, error)
	DeleteKnowledgeBaseWithContext(aws.Context, *bedrockagent.DeleteKnowledgeBaseInput, ...request.Option) (*bedrockagent.DeleteKnowledgeBaseOutput, error)
	DeleteKnowledgeBaseRequest(*bedrockagent.DeleteKnowledgeBaseInput) (*request.Request, *bedrockagent.DeleteKnowledgeBaseOutput)

	DisassociateAgentKnowledgeBase(*bedrockagent.DisassociateAgentKnowledgeBaseInput) (*bedrockagent.DisassociateAgentKnowledgeBaseOutput, error)
	DisassociateAgentKnowledgeBaseWithContext(aws.Context, *bedrockagent.DisassociateAgentKnowledgeBaseInput, ...request.Option) (*bedrockagent.DisassociateAgentKnowledgeBaseOutput, error)
	DisassociateAgentKnowledgeBaseRequest(*bedrockagent.DisassociateAgentKnowledgeBaseInput) (*request.Request, *bedrockagent.DisassociateAgentKnowledgeBaseOutput)

	GetAgent(*bedrockagent.GetAgentInput) (*bedrockagent.GetAgentOutput, error)
	GetAgentWithContext(aws.Context, *bedrockagent.GetAgentInput, ...request.Option) (*bedrockagent.GetAgentOutput, error)
	GetAgentRequest(*bedrockagent.GetAgentInput) (*request.Request, *bedrockagent.GetAgentOutput)

	GetAgentActionGroup(*bedrockagent.GetAgentActionGroupInput) (*bedrockagent.GetAgentActionGroupOutput, error)
	GetAgentActionGroupWithContext(aws.Context, *bedrockagent.GetAgentActionGroupInput, ...request.Option) (*bedrockagent.GetAgentActionGroupOutput, error)
	GetAgentActionGroupRequest(*bedrockagent.GetAgentActionGroupInput) (*request.Request, *bedrockagent.GetAgentActionGroupOutput)

	GetAgentAlias(*bedrockagent.GetAgentAliasInput) (*bedrockagent.GetAgentAliasOutput, error)
	GetAgentAliasWithContext(aws.Context, *bedrockagent.GetAgentAliasInput, ...request.Option) (*bedrockagent.GetAgentAliasOutput, error)
	GetAgentAliasRequest(*bedrockagent.GetAgentAliasInput) (*request.Request, *bedrockagent.GetAgentAliasOutput)

	GetAgentKnowledgeBase(*bedrockagent.GetAgentKnowledgeBaseInput) (*bedrockagent.GetAgentKnowledgeBaseOutput, error)
	GetAgentKnowledgeBaseWithContext(aws.Context, *bedrockagent.GetAgentKnowledgeBaseInput, ...request.Option) (*bedrockagent.GetAgentKnowledgeBaseOutput, error)
	GetAgentKnowledgeBaseRequest(*bedrockagent.GetAgentKnowledgeBaseInput) (*request.Request, *bedrockagent.GetAgentKnowledgeBaseOutput)

	GetAgentVersion(*bedrockagent.GetAgentVersionInput) (*bedrockagent.GetAgentVersionOutput, error)
	GetAgentVersionWithContext(aws.Context, *bedrockagent.GetAgentVersionInput, ...request.Option) (*bedrockagent.GetAgentVersionOutput, error)
	GetAgentVersionRequest(*bedrockagent.GetAgentVersionInput) (*request.Request, *bedrockagent.GetAgentVersionOutput)

	GetDataSource(*bedrockagent.GetDataSourceInput) (*bedrockagent.GetDataSourceOutput, error)
	GetDataSourceWithContext(aws.Context, *bedrockagent.GetDataSourceInput, ...request.Option) (*bedrockagent.GetDataSourceOutput, error)
	GetDataSourceRequest(*bedrockagent.GetDataSourceInput) (*request.Request, *bedrockagent.GetDataSourceOutput)

	GetIngestionJob(*bedrockagent.GetIngestionJobInput) (*bedrockagent.GetIngestionJobOutput, error)
	GetIngestionJobWithContext(aws.Context, *bedrockagent.GetIngestionJobInput, ...request.Option) (*bedrockagent.GetIngestionJobOutput, error)
	GetIngestionJobRequest(*bedrockagent.GetIngestionJobInput) (*request.Request, *bedrockagent.GetIngestionJobOutput)

	GetKnowledgeBase(*bedrockagent.GetKnowledgeBaseInput) (*bedrockagent.GetKnowledgeBaseOutput, error)
	GetKnowledgeBaseWithContext(aws.Context, *bedrockagent.GetKnowledgeBaseInput, ...request.Option) (*bedrockagent.GetKnowledgeBaseOutput, error)
	GetKnowledgeBaseRequest(*bedrockagent.GetKnowledgeBaseInput) (*request.Request, *bedrockagent.GetKnowledgeBaseOutput)

	ListAgentActionGroups(*bedrockagent.ListAgentActionGroupsInput) (*bedrockagent.ListAgentActionGroupsOutput, error)
	ListAgentActionGroupsWithContext(aws.Context, *bedrockagent.ListAgentActionGroupsInput, ...request.Option) (*bedrockagent.ListAgentActionGroupsOutput, error)
	ListAgentActionGroupsRequest(*bedrockagent.ListAgentActionGroupsInput) (*request.Request, *bedrockagent.ListAgentActionGroupsOutput)

	ListAgentActionGroupsPages(*bedrockagent.ListAgentActionGroupsInput, func(*bedrockagent.ListAgentActionGroupsOutput, bool) bool) error
	ListAgentActionGroupsPagesWithContext(aws.Context, *bedrockagent.ListAgentActionGroupsInput, func(*bedrockagent.ListAgentActionGroupsOutput, bool) bool, ...request.Option) error

	ListAgentAliases(*bedrockagent.ListAgentAliasesInput) (*bedrockagent.ListAgentAliasesOutput, error)
	ListAgentAliasesWithContext(aws.Context, *bedrockagent.ListAgentAliasesInput, ...request.Option) (*bedrockagent.ListAgentAliasesOutput, error)
	ListAgentAliasesRequest(*bedrockagent.ListAgentAliasesInput) (*request.Request, *bedrockagent.ListAgentAliasesOutput)

	ListAgentAliasesPages(*bedrockagent.ListAgentAliasesInput, func(*bedrockagent.ListAgentAliasesOutput, bool) bool) error
	ListAgentAliasesPagesWithContext(aws.Context, *bedrockagent.ListAgentAliasesInput, func(*bedrockagent.ListAgentAliasesOutput, bool) bool, ...request.Option) error

	ListAgentKnowledgeBases(*bedrockagent.ListAgentKnowledgeBasesInput) (*bedrockagent.ListAgentKnowledgeBasesOutput, error)
	ListAgentKnowledgeBasesWithContext(aws.Context, *bedrockagent.ListAgentKnowledgeBasesInput, ...request.Option) (*bedrockagent.ListAgentKnowledgeBasesOutput, error)
	ListAgentKnowledgeBasesRequest(*bedrockagent.ListAgentKnowledgeBasesInput) (*request.Request, *bedrockagent.ListAgentKnowledgeBasesOutput)

	ListAgentKnowledgeBasesPages(*bedrockagent.ListAgentKnowledgeBasesInput, func(*bedrockagent.ListAgentKnowledgeBasesOutput, bool) bool) error
	ListAgentKnowledgeBasesPagesWithContext(aws.Context, *bedrockagent.ListAgentKnowledgeBasesInput, func(*bedrockagent.ListAgentKnowledgeBasesOutput, bool) bool, ...request.Option) error

	ListAgentVersions(*bedrockagent.ListAgentVersionsInput) (*bedrockagent.ListAgentVersionsOutput, error)
	ListAgentVersionsWithContext(aws.Context, *bedrockagent.ListAgentVersionsInput, ...request.Option) (*bedrockagent.ListAgentVersionsOutput, error)
	ListAgentVersionsRequest(*bedrockagent.ListAgentVersionsInput) (*request.Request, *bedrockagent.ListAgentVersionsOutput)

	ListAgentVersionsPages(*bedrockagent.ListAgentVersionsInput, func(*bedrockagent.ListAgentVersionsOutput, bool) bool) error
	ListAgentVersionsPagesWithContext(aws.Context, *bedrockagent.ListAgentVersionsInput, func(*bedrockagent.ListAgentVersionsOutput, bool) bool, ...request.Option) error

	ListAgents(*bedrockagent.ListAgentsInput) (*bedrockagent.ListAgentsOutput, error)
	ListAgentsWithContext(aws.Context, *bedrockagent.ListAgentsInput, ...request.Option) (*bedrockagent.ListAgentsOutput, error)
	ListAgentsRequest(*bedrockagent.ListAgentsInput) (*request.Request, *bedrockagent.ListAgentsOutput)

	ListAgentsPages(*bedrockagent.ListAgentsInput, func(*bedrockagent.ListAgentsOutput, bool) bool) error
	ListAgentsPagesWithContext(aws.Context, *bedrockagent.ListAgentsInput, func(*bedrockagent.ListAgentsOutput, bool) bool, ...request.Option) error

	ListDataSources(*bedrockagent.ListDataSourcesInput) (*bedrockagent.ListDataSourcesOutput, error)
	ListDataSourcesWithContext(aws.Context, *bedrockagent.ListDataSourcesInput, ...request.Option) (*bedrockagent.ListDataSourcesOutput, error)
	ListDataSourcesRequest(*bedrockagent.ListDataSourcesInput) (*request.Request, *bedrockagent.ListDataSourcesOutput)

	ListDataSourcesPages(*bedrockagent.ListDataSourcesInput, func(*bedrockagent.ListDataSourcesOutput, bool) bool) error
	ListDataSourcesPagesWithContext(aws.Context, *bedrockagent.ListDataSourcesInput, func(*bedrockagent.ListDataSourcesOutput, bool) bool, ...request.Option) error

	ListIngestionJobs(*bedrockagent.ListIngestionJobsInput) (*bedrockagent.ListIngestionJobsOutput, error)
	ListIngestionJobsWithContext(aws.Context, *bedrockagent.ListIngestionJobsInput, ...request.Option) (*bedrockagent.ListIngestionJobsOutput, error)
	ListIngestionJobsRequest(*bedrockagent.ListIngestionJobsInput) (*request.Request, *bedrockagent.ListIngestionJobsOutput)

	ListIngestionJobsPages(*bedrockagent.ListIngestionJobsInput, func(*bedrockagent.ListIngestionJobsOutput, bool) bool) error
	ListIngestionJobsPagesWithContext(aws.Context, *bedrockagent.ListIngestionJobsInput, func(*bedrockagent.ListIngestionJobsOutput, bool) bool, ...request.Option) error

	ListKnowledgeBases(*bedrockagent.ListKnowledgeBasesInput) (*bedrockagent.ListKnowledgeBasesOutput, error)
	ListKnowledgeBasesWithContext(aws.Context, *bedrockagent.ListKnowledgeBasesInput, ...request.Option) (*bedrockagent.ListKnowledgeBasesOutput, error)
	ListKnowledgeBasesRequest(*bedrockagent.ListKnowledgeBasesInput) (*request.Request, *bedrockagent.ListKnowledgeBasesOutput)

	ListKnowledgeBasesPages(*bedrockagent.ListKnowledgeBasesInput, func(*bedrockagent.ListKnowledgeBasesOutput, bool) bool) error
	ListKnowledgeBasesPagesWithContext(aws.Context, *bedrockagent.ListKnowledgeBasesInput, func(*bedrockagent.ListKnowledgeBasesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*bedrockagent.ListTagsForResourceInput) (*bedrockagent.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *bedrockagent.ListTagsForResourceInput, ...request.Option) (*bedrockagent.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*bedrockagent.ListTagsForResourceInput) (*request.Request, *bedrockagent.ListTagsForResourceOutput)

	PrepareAgent(*bedrockagent.PrepareAgentInput) (*bedrockagent.PrepareAgentOutput, error)
	PrepareAgentWithContext(aws.Context, *bedrockagent.PrepareAgentInput, ...request.Option) (*bedrockagent.PrepareAgentOutput, error)
	PrepareAgentRequest(*bedrockagent.PrepareAgentInput) (*request.Request, *bedrockagent.PrepareAgentOutput)

	StartIngestionJob(*bedrockagent.StartIngestionJobInput) (*bedrockagent.StartIngestionJobOutput, error)
	StartIngestionJobWithContext(aws.Context, *bedrockagent.StartIngestionJobInput, ...request.Option) (*bedrockagent.StartIngestionJobOutput, error)
	StartIngestionJobRequest(*bedrockagent.StartIngestionJobInput) (*request.Request, *bedrockagent.StartIngestionJobOutput)

	TagResource(*bedrockagent.TagResourceInput) (*bedrockagent.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *bedrockagent.TagResourceInput, ...request.Option) (*bedrockagent.TagResourceOutput, error)
	TagResourceRequest(*bedrockagent.TagResourceInput) (*request.Request, *bedrockagent.TagResourceOutput)

	UntagResource(*bedrockagent.UntagResourceInput) (*bedrockagent.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *bedrockagent.UntagResourceInput, ...request.Option) (*bedrockagent.UntagResourceOutput, error)
	UntagResourceRequest(*bedrockagent.UntagResourceInput) (*request.Request, *bedrockagent.UntagResourceOutput)

	UpdateAgent(*bedrockagent.UpdateAgentInput) (*bedrockagent.UpdateAgentOutput, error)
	UpdateAgentWithContext(aws.Context, *bedrockagent.UpdateAgentInput, ...request.Option) (*bedrockagent.UpdateAgentOutput, error)
	UpdateAgentRequest(*bedrockagent.UpdateAgentInput) (*request.Request, *bedrockagent.UpdateAgentOutput)

	UpdateAgentActionGroup(*bedrockagent.UpdateAgentActionGroupInput) (*bedrockagent.UpdateAgentActionGroupOutput, error)
	UpdateAgentActionGroupWithContext(aws.Context, *bedrockagent.UpdateAgentActionGroupInput, ...request.Option) (*bedrockagent.UpdateAgentActionGroupOutput, error)
	UpdateAgentActionGroupRequest(*bedrockagent.UpdateAgentActionGroupInput) (*request.Request, *bedrockagent.UpdateAgentActionGroupOutput)

	UpdateAgentAlias(*bedrockagent.UpdateAgentAliasInput) (*bedrockagent.UpdateAgentAliasOutput, error)
	UpdateAgentAliasWithContext(aws.Context, *bedrockagent.UpdateAgentAliasInput, ...request.Option) (*bedrockagent.UpdateAgentAliasOutput, error)
	UpdateAgentAliasRequest(*bedrockagent.UpdateAgentAliasInput) (*request.Request, *bedrockagent.UpdateAgentAliasOutput)

	UpdateAgentKnowledgeBase(*bedrockagent.UpdateAgentKnowledgeBaseInput) (*bedrockagent.UpdateAgentKnowledgeBaseOutput, error)
	UpdateAgentKnowledgeBaseWithContext(aws.Context, *bedrockagent.UpdateAgentKnowledgeBaseInput, ...request.Option) (*bedrockagent.UpdateAgentKnowledgeBaseOutput, error)
	UpdateAgentKnowledgeBaseRequest(*bedrockagent.UpdateAgentKnowledgeBaseInput) (*request.Request, *bedrockagent.UpdateAgentKnowledgeBaseOutput)

	UpdateDataSource(*bedrockagent.UpdateDataSourceInput) (*bedrockagent.UpdateDataSourceOutput, error)
	UpdateDataSourceWithContext(aws.Context, *bedrockagent.UpdateDataSourceInput, ...request.Option) (*bedrockagent.UpdateDataSourceOutput, error)
	UpdateDataSourceRequest(*bedrockagent.UpdateDataSourceInput) (*request.Request, *bedrockagent.UpdateDataSourceOutput)

	UpdateKnowledgeBase(*bedrockagent.UpdateKnowledgeBaseInput) (*bedrockagent.UpdateKnowledgeBaseOutput, error)
	UpdateKnowledgeBaseWithContext(aws.Context, *bedrockagent.UpdateKnowledgeBaseInput, ...request.Option) (*bedrockagent.UpdateKnowledgeBaseOutput, error)
	UpdateKnowledgeBaseRequest(*bedrockagent.UpdateKnowledgeBaseInput) (*request.Request, *bedrockagent.UpdateKnowledgeBaseOutput)
}

var _ BedrockAgentAPI = (*bedrockagent.BedrockAgent)(nil)
