// RUN: %clang_cc1 -triple aarch64-linux-gnu -mbranch-target-enforce    -emit-llvm %s -o - | FileCheck --check-prefixes=BTI,ELF    %s
// RUN: %clang_cc1 -triple arm64-apple-ios   -mbranch-target-enforce    -emit-llvm %s -o - | FileCheck --check-prefixes=BTI        %s
// RUN: %clang_cc1 -triple aarch64-linux-gnu                            -emit-llvm %s -o - | FileCheck --check-prefixes=NOBTI,ELF  %s
// RUN: %clang_cc1 -triple arm64-apple-ios                              -emit-llvm %s -o - | FileCheck --check-prefixes=NOBTI      %s
// RUN: %clang_cc1 -triple aarch64-linux-gnu -fvisibility=hidden        -emit-llvm %s -o - | FileCheck --check-prefixes=HIDDEN,ELF %s
// RUN: %clang_cc1 -triple arm64-apple-ios   -fvisibility=hidden        -emit-llvm %s -o - | FileCheck --check-prefixes=HIDDEN     %s

// Check that the resolver functions generated by Clang have the correct attributes.
// In these test cases, branch-target-enforcement is used as an example of
// target-specific attribute that has to be set on every function by default.

// FIXME: `cpu_specific`/`cpu_dispatch` and `target` attributes cannot be
//        tested on AArch64.

__attribute__((target_clones("crc", "default")))
int global_target_clones(void) { return 0; }

__attribute__((target_version("crc")))     int global_target_version(void) { return 0; }
__attribute__((target_version("default"))) int global_target_version(void) { return 0; }

__attribute__((target_clones("crc", "default")))
static int static_target_clones(void) { return 0; }

__attribute__((target_version("crc")))     static int  static_target_version(void) { return 0; }
__attribute__((target_version("default"))) static int  static_target_version(void) { return 0; }

// Force emission of static_* functions.
void *get_ptr1(void) { return static_target_clones; }
void *get_ptr2(void) { return static_target_version; }

#ifdef __ELF__
// Make sure target-specific attributes can be overriden as needed for
// non-autogenerated resolver functions.
// Note that since there is only a single definition of ifunc_resolver, it
// is not itself a multi-versioned function, even though it has target(...)
// attribute.
int ifunc_func(void) { return 0; }
__attribute__((target("branch-protection=bti"))) void *ifunc_resolver(void) { return ifunc_func; }
__attribute__((ifunc("ifunc_resolver"))) int ifunc(void);
#endif

// ELF: define{{.*}} ptr @ifunc_resolver() #[[ATTR_IFUNC_RESOLVER:[0-9]+]]

// BTI: define weak_odr ptr @global_target_clones.resolver()  #[[ATTR_RESOLVER:[0-9]+]]
// BTI: define weak_odr ptr @global_target_version.resolver() #[[ATTR_RESOLVER]]
// BTI: define internal ptr @static_target_clones.resolver()  #[[ATTR_RESOLVER]]
// BTI: define internal ptr @static_target_version.resolver() #[[ATTR_RESOLVER]]

// In NOBTI case, only "no_sanitizer_instrumentation" attributes are added to the resolver

// NOBTI: define weak_odr ptr @global_target_clones.resolver() [[ATTR_RESOLVER:(#[0-9]+)?]]{{( comdat)?}}
// NOBTI: define weak_odr ptr @global_target_version.resolver() [[ATTR_RESOLVER]]{{( comdat)?}}
// NOBTI: define internal ptr @static_target_clones.resolver() [[ATTR_RESOLVER]]
// NOBTI: define internal ptr @static_target_version.resolver() [[ATTR_RESOLVER]]

// HIDDEN: define weak_odr hidden ptr @global_target_clones.resolver() [[ATTR_RESOLVER:(#[0-9]+)?]]{{( comdat)?}}
// HIDDEN: define weak_odr hidden ptr @global_target_version.resolver() [[ATTR_RESOLVER]]{{( comdat)?}}
// HIDDEN: define internal ptr @static_target_clones.resolver() [[ATTR_RESOLVER]] 
// HIDDEN: define internal ptr @static_target_version.resolver() [[ATTR_RESOLVER]] 

// ELF:       attributes #[[ATTR_IFUNC_RESOLVER]] = { {{.*}}"branch-target-enforcement"{{.*}} }

// BTI:       attributes #[[ATTR_RESOLVER]] = { {{.*}}"branch-target-enforcement"{{.*}} }
//
// NOBTI:        attributes [[ATTR_RESOLVER]] = { disable_sanitizer_instrumentation }
