// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct StartStreamEncryptionInput {
    /// <p>The name of the stream for which to start encrypting records.</p>
    pub stream_name: ::std::option::Option<::std::string::String>,
    /// <p>The encryption type to use. The only valid value is <code>KMS</code>.</p>
    pub encryption_type: ::std::option::Option<crate::types::EncryptionType>,
    /// <p>The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></p></li>
    /// </ul>
    pub key_id: ::std::option::Option<::std::string::String>,
    /// <p>The ARN of the stream.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
}
impl StartStreamEncryptionInput {
    /// <p>The name of the stream for which to start encrypting records.</p>
    pub fn stream_name(&self) -> ::std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The encryption type to use. The only valid value is <code>KMS</code>.</p>
    pub fn encryption_type(&self) -> ::std::option::Option<&crate::types::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></p></li>
    /// </ul>
    pub fn key_id(&self) -> ::std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl StartStreamEncryptionInput {
    /// Creates a new builder-style object to manufacture [`StartStreamEncryptionInput`](crate::operation::start_stream_encryption::StartStreamEncryptionInput).
    pub fn builder() -> crate::operation::start_stream_encryption::builders::StartStreamEncryptionInputBuilder {
        crate::operation::start_stream_encryption::builders::StartStreamEncryptionInputBuilder::default()
    }
}

/// A builder for [`StartStreamEncryptionInput`](crate::operation::start_stream_encryption::StartStreamEncryptionInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StartStreamEncryptionInputBuilder {
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) encryption_type: ::std::option::Option<crate::types::EncryptionType>,
    pub(crate) key_id: ::std::option::Option<::std::string::String>,
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
}
impl StartStreamEncryptionInputBuilder {
    /// <p>The name of the stream for which to start encrypting records.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the stream for which to start encrypting records.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>The name of the stream for which to start encrypting records.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The encryption type to use. The only valid value is <code>KMS</code>.</p>
    /// This field is required.
    pub fn encryption_type(mut self, input: crate::types::EncryptionType) -> Self {
        self.encryption_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encryption type to use. The only valid value is <code>KMS</code>.</p>
    pub fn set_encryption_type(mut self, input: ::std::option::Option<crate::types::EncryptionType>) -> Self {
        self.encryption_type = input;
        self
    }
    /// <p>The encryption type to use. The only valid value is <code>KMS</code>.</p>
    pub fn get_encryption_type(&self) -> &::std::option::Option<crate::types::EncryptionType> {
        &self.encryption_type
    }
    /// <p>The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></p></li>
    /// </ul>
    /// This field is required.
    pub fn key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></p></li>
    /// </ul>
    pub fn set_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_id = input;
        self
    }
    /// <p>The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></p></li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code></p></li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></p></li>
    /// </ul>
    pub fn get_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_id
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// Consumes the builder and constructs a [`StartStreamEncryptionInput`](crate::operation::start_stream_encryption::StartStreamEncryptionInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::start_stream_encryption::StartStreamEncryptionInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::start_stream_encryption::StartStreamEncryptionInput {
            stream_name: self.stream_name,
            encryption_type: self.encryption_type,
            key_id: self.key_id,
            stream_arn: self.stream_arn,
        })
    }
}
