﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudtrail/model/Type.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace CloudTrail {
namespace Model {
namespace TypeMapper {

static const int TagContext_HASH = HashingUtils::HashString("TagContext");
static const int RequestContext_HASH = HashingUtils::HashString("RequestContext");

Type GetTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == TagContext_HASH) {
    return Type::TagContext;
  } else if (hashCode == RequestContext_HASH) {
    return Type::RequestContext;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<Type>(hashCode);
  }

  return Type::NOT_SET;
}

Aws::String GetNameForType(Type enumValue) {
  switch (enumValue) {
    case Type::NOT_SET:
      return {};
    case Type::TagContext:
      return "TagContext";
    case Type::RequestContext:
      return "RequestContext";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace TypeMapper
}  // namespace Model
}  // namespace CloudTrail
}  // namespace Aws
