"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Operations = void 0;
var react_1 = __importDefault(require("react"));
var Operation_1 = require("./Operation");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var Operations = function () {
    var operations = (0, contexts_1.useSpec)().operations().all();
    var config = (0, contexts_1.useConfig)();
    if (!Object.keys(operations).length) {
        return null;
    }
    var operationsList = operations.map(function (operation) {
        var _a;
        var channel = operation.channels().all()[0];
        var channelAddress = (_a = channel === null || channel === void 0 ? void 0 : channel.address()) !== null && _a !== void 0 ? _a : '';
        var operationId = helpers_1.CommonHelpers.getOperationIdentifier({
            operation: operation,
            config: config,
        });
        var type = helpers_1.CommonHelpers.getOperationType(operation);
        return (react_1.default.createElement("li", { className: "mb-12", key: "".concat(type, "-").concat(operation.id()), id: operationId },
            react_1.default.createElement(Operation_1.Operation, { type: type, operation: operation, channelName: channelAddress, channel: channel })));
    });
    return (react_1.default.createElement("section", { id: "".concat(helpers_1.CommonHelpers.getIdentifier('operations', config)), className: "mt-16" },
        react_1.default.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, constants_1.OPERATIONS_TEXT),
        react_1.default.createElement("ul", null, operationsList)));
};
exports.Operations = Operations;
//# sourceMappingURL=Operations.js.map