/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.Messages;
import org.apache.batik.css.engine.value.RGBColorValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class AbstractColorManager
extends IdentifierManager {
    protected static final Object2ObjectOpenHashMap<String, Value> values = new Object2ObjectOpenHashMap();
    protected static final Object2ObjectOpenHashMap<String, Value> computedValues;

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == 27) {
            lu = lu.getParameters();
            Value red = this.createColorComponent(lu);
            lu = lu.getNextLexicalUnit().getNextLexicalUnit();
            Value green = this.createColorComponent(lu);
            lu = lu.getNextLexicalUnit().getNextLexicalUnit();
            Value blue = this.createColorComponent(lu);
            return this.createRGBColor(red, green, blue);
        }
        return super.createValue(lu, engine);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getPrimitiveType() == 21) {
            String ident = value.getStringValue();
            Value v = (Value)computedValues.get((Object)ident);
            if (v != null) {
                return v;
            }
            if (values.get((Object)ident) == null) {
                throw new IllegalStateException("Not a system-color:" + ident);
            }
            return engine.getCSSContext().getSystemColor(ident);
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    protected Value createRGBColor(Value r, Value g, Value b) {
        return new RGBColorValue(r, g, b);
    }

    protected Value createColorComponent(LexicalUnit lu) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 13: {
                return new FloatValue(1, lu.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lu.getFloatValue());
            }
            case 23: {
                return new FloatValue(2, lu.getFloatValue());
            }
        }
        throw this.createInvalidRGBComponentUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Object2ObjectOpenHashMap<String, Value> getIdentifiers() {
        return values;
    }

    private DOMException createInvalidRGBComponentUnitDOMException(short type) {
        Object[] p = new Object[]{this.getPropertyName(), (int)type};
        String s = Messages.formatMessage("invalid.rgb.component.unit", p);
        return new DOMException(9, s);
    }

    static {
        values.put((Object)"aqua", (Object)ValueConstants.AQUA_VALUE);
        values.put((Object)"black", (Object)ValueConstants.BLACK_VALUE);
        values.put((Object)"blue", (Object)ValueConstants.BLUE_VALUE);
        values.put((Object)"fuchsia", (Object)ValueConstants.FUCHSIA_VALUE);
        values.put((Object)"gray", (Object)ValueConstants.GRAY_VALUE);
        values.put((Object)"green", (Object)ValueConstants.GREEN_VALUE);
        values.put((Object)"lime", (Object)ValueConstants.LIME_VALUE);
        values.put((Object)"maroon", (Object)ValueConstants.MAROON_VALUE);
        values.put((Object)"navy", (Object)ValueConstants.NAVY_VALUE);
        values.put((Object)"olive", (Object)ValueConstants.OLIVE_VALUE);
        values.put((Object)"purple", (Object)ValueConstants.PURPLE_VALUE);
        values.put((Object)"red", (Object)ValueConstants.RED_VALUE);
        values.put((Object)"silver", (Object)ValueConstants.SILVER_VALUE);
        values.put((Object)"teal", (Object)ValueConstants.TEAL_VALUE);
        values.put((Object)"white", (Object)ValueConstants.WHITE_VALUE);
        values.put((Object)"yellow", (Object)ValueConstants.YELLOW_VALUE);
        values.put((Object)"activeborder", (Object)ValueConstants.ACTIVEBORDER_VALUE);
        values.put((Object)"activecaption", (Object)ValueConstants.ACTIVECAPTION_VALUE);
        values.put((Object)"appworkspace", (Object)ValueConstants.APPWORKSPACE_VALUE);
        values.put((Object)"background", (Object)ValueConstants.BACKGROUND_VALUE);
        values.put((Object)"buttonface", (Object)ValueConstants.BUTTONFACE_VALUE);
        values.put((Object)"buttonhighlight", (Object)ValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put((Object)"buttonshadow", (Object)ValueConstants.BUTTONSHADOW_VALUE);
        values.put((Object)"buttontext", (Object)ValueConstants.BUTTONTEXT_VALUE);
        values.put((Object)"captiontext", (Object)ValueConstants.CAPTIONTEXT_VALUE);
        values.put((Object)"graytext", (Object)ValueConstants.GRAYTEXT_VALUE);
        values.put((Object)"highlight", (Object)ValueConstants.HIGHLIGHT_VALUE);
        values.put((Object)"highlighttext", (Object)ValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put((Object)"inactiveborder", (Object)ValueConstants.INACTIVEBORDER_VALUE);
        values.put((Object)"inactivecaption", (Object)ValueConstants.INACTIVECAPTION_VALUE);
        values.put((Object)"inactivecaptiontext", (Object)ValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put((Object)"infobackground", (Object)ValueConstants.INFOBACKGROUND_VALUE);
        values.put((Object)"infotext", (Object)ValueConstants.INFOTEXT_VALUE);
        values.put((Object)"menu", (Object)ValueConstants.MENU_VALUE);
        values.put((Object)"menutext", (Object)ValueConstants.MENUTEXT_VALUE);
        values.put((Object)"scrollbar", (Object)ValueConstants.SCROLLBAR_VALUE);
        values.put((Object)"threeddarkshadow", (Object)ValueConstants.THREEDDARKSHADOW_VALUE);
        values.put((Object)"threedface", (Object)ValueConstants.THREEDFACE_VALUE);
        values.put((Object)"threedhighlight", (Object)ValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put((Object)"threedlightshadow", (Object)ValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put((Object)"threedshadow", (Object)ValueConstants.THREEDSHADOW_VALUE);
        values.put((Object)"window", (Object)ValueConstants.WINDOW_VALUE);
        values.put((Object)"windowframe", (Object)ValueConstants.WINDOWFRAME_VALUE);
        values.put((Object)"windowtext", (Object)ValueConstants.WINDOWTEXT_VALUE);
        computedValues = new Object2ObjectOpenHashMap();
        computedValues.put((Object)"black", (Object)ValueConstants.BLACK_RGB_VALUE);
        computedValues.put((Object)"silver", (Object)ValueConstants.SILVER_RGB_VALUE);
        computedValues.put((Object)"gray", (Object)ValueConstants.GRAY_RGB_VALUE);
        computedValues.put((Object)"white", (Object)ValueConstants.WHITE_RGB_VALUE);
        computedValues.put((Object)"maroon", (Object)ValueConstants.MAROON_RGB_VALUE);
        computedValues.put((Object)"red", (Object)ValueConstants.RED_RGB_VALUE);
        computedValues.put((Object)"purple", (Object)ValueConstants.PURPLE_RGB_VALUE);
        computedValues.put((Object)"fuchsia", (Object)ValueConstants.FUCHSIA_RGB_VALUE);
        computedValues.put((Object)"green", (Object)ValueConstants.GREEN_RGB_VALUE);
        computedValues.put((Object)"lime", (Object)ValueConstants.LIME_RGB_VALUE);
        computedValues.put((Object)"olive", (Object)ValueConstants.OLIVE_RGB_VALUE);
        computedValues.put((Object)"yellow", (Object)ValueConstants.YELLOW_RGB_VALUE);
        computedValues.put((Object)"navy", (Object)ValueConstants.NAVY_RGB_VALUE);
        computedValues.put((Object)"blue", (Object)ValueConstants.BLUE_RGB_VALUE);
        computedValues.put((Object)"teal", (Object)ValueConstants.TEAL_RGB_VALUE);
        computedValues.put((Object)"aqua", (Object)ValueConstants.AQUA_RGB_VALUE);
    }
}

