/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.google.gson.JsonElement;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptCompilerConfigUtil {
    public static final String SOURCE_MAP = "--sourceMap";

    @NotNull
    public static String getConfigIdByConfig(@NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(0);
        }
        String string = TypeScriptCompilerConfigUtil.getConfigIdByConfig(config.getConfigFile());
        if (string == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getConfigIdByConfig(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(2);
        }
        return JSHighlightingInfoBuilder.toPath(file);
    }

    @Nullable
    public static String getConfigIdForFile(@Nullable Project project, @NotNull VirtualFile file) {
        TypeScriptConfig config;
        if (file == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(3);
        }
        return (config = TypeScriptConfigUtil.getConfigForFile(project, file)) == null ? null : TypeScriptCompilerConfigUtil.getConfigIdByConfig(config);
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(4);
        }
        return TypeScriptConfigUtil.getConfigForFile(project, file);
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(5);
        }
        return JSLanguageServiceUtil.normalizeNameAndPath(file);
    }

    public static void refreshFiles(@NotNull Project project, @NotNull Collection<String> files) {
        if (project == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(6);
        }
        if (files == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(7);
        }
        Runnable refresh = () -> {
            Collection result2 = (Collection)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return ContainerUtil.emptyList();
                }
                HashSet<VirtualFile> dirtyFiles = new HashSet<VirtualFile>();
                for (String string : files) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)string);
                    VirtualFile path2 = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                    if (path2 != null) {
                        dirtyFiles.add(path2);
                        continue;
                    }
                    String parentDir = VfsUtil.getParentDir((String)systemIndependentName);
                    if (StringUtil.isEmpty((String)parentDir) || (path2 = LocalFileSystem.getInstance().findFileByPath(parentDir)) == null) continue;
                    dirtyFiles.add(path2);
                }
                for (VirtualFile virtualFile : dirtyFiles) {
                    Boolean data2;
                    if (virtualFile.isDirectory() || Boolean.TRUE.equals(data2 = (Boolean)virtualFile.getUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER))) continue;
                    virtualFile.putUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER, (Object)Boolean.TRUE);
                }
                return dirtyFiles;
            });
            if (result2.isEmpty()) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)result2));
        };
        ApplicationManager.getApplication().executeOnPooledThread(refresh);
    }

    @NotNull
    public static List<String> jsonArrayToStringArray(JsonElement emitFiles) {
        List list = ContainerUtil.map((Collection)ContainerUtil.newArrayList((Iterable)emitFiles.getAsJsonArray()), JsonElement::getAsString);
        if (list == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static GlobalSearchScope getCompileScope(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(9);
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            String scopeName = TypeScriptCompilerSettings.getSettings(project).getScopeName();
            GlobalSearchScope scope2 = ScopeChooserUtils.findScopeByName((Project)project, (String)scopeName);
            if (scope2 == GlobalSearchScope.EMPTY_SCOPE && Objects.equals(ProjectScope.getProjectFilesScopeName(), scopeName)) {
                return GlobalSearchScope.projectScope((Project)project);
            }
            return scope2;
        });
        if (globalSearchScope == null) {
            TypeScriptCompilerConfigUtil.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    public static boolean isEffectiveUseTypesFromServer(boolean useService, boolean useTypesFromServer) {
        return useService && useTypesFromServer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigIdByConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "jsonArrayToStringArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigIdByConfig";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigIdForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNameAndPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompileScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 10 -> new IllegalStateException(string);
        };
    }
}

