/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.RecursionCounter;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeSubstitutionContextImpl
extends UserDataHolderBase
implements JSTypeSubstitutionContext {
    @NotNull
    private final RecursionCounter myCounter;
    @NotNull
    private final List<JSType> myGenerics;
    private Map<Object, Object> myMap;

    @Override
    @NotNull
    public List<JSType> getGenerics() {
        List<JSType> list = this.myGenerics;
        if (list == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    public JSTypeSubstitutionContextImpl() {
        this.myCounter = new RecursionCounter();
        this.myGenerics = ContainerUtil.emptyList();
    }

    public JSTypeSubstitutionContextImpl(@Nullable ProcessingContext processingContext) {
        this();
        if (processingContext != null) {
            this.putUserData(JSTypeComparingContextService.NULL_CHECKS, (Boolean)processingContext.get(JSTypeComparingContextService.NULL_CHECKS));
            this.putUserData(JSTypeComparingContextService.LOCATION, (PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION));
        }
    }

    public JSTypeSubstitutionContextImpl(@Nullable PsiElement location) {
        this();
        if (location != null) {
            this.putUserData(JSTypeComparingContextService.NULL_CHECKS, TypeScriptConfigUtil.strictNullChecks(location));
            this.putUserData(JSTypeComparingContextService.LOCATION, location);
        }
    }

    private JSTypeSubstitutionContextImpl(@NotNull RecursionCounter newContext, @NotNull List<JSType> generics, @Nullable Map<Object, Object> map2) {
        if (newContext == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(1);
        }
        if (generics == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(2);
        }
        this.myCounter = newContext;
        this.myGenerics = generics;
        this.myMap = map2;
    }

    @Override
    public boolean add(@NotNull JSType type2) {
        if (type2 == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(3);
        }
        return this.myCounter.add(type2, this.myGenerics);
    }

    @Override
    public boolean isVisited(@NotNull JSType type2) {
        if (type2 == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(4);
        }
        return this.myCounter.isVisited(type2.getResolvedTypeId());
    }

    @Override
    public boolean canCache() {
        return this.myGenerics.isEmpty();
    }

    @Override
    public boolean canCacheNull() {
        return this.myCounter.isEmpty();
    }

    @NotNull
    public RecursionCounter getCounter() {
        RecursionCounter recursionCounter = this.myCounter;
        if (recursionCounter == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(5);
        }
        return recursionCounter;
    }

    @Override
    @Nullable
    public PsiElement getLocation() {
        return (PsiElement)this.getUserData(JSTypeComparingContextService.LOCATION);
    }

    @Override
    @NotNull
    public JSTypeSubstitutionContext withGenerics(@NotNull List<JSType> generics) {
        if (generics == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(6);
        }
        JSTypeSubstitutionContextImpl result2 = new JSTypeSubstitutionContextImpl(this.getCounter(), generics, this.myMap);
        result2.putUserData(JSTypeComparingContextService.NULL_CHECKS, (Boolean)this.getUserData(JSTypeComparingContextService.NULL_CHECKS));
        result2.putUserData(JSTypeComparingContextService.LOCATION, (PsiElement)this.getUserData(JSTypeComparingContextService.LOCATION));
        JSTypeSubstitutionContextImpl jSTypeSubstitutionContextImpl = result2;
        if (jSTypeSubstitutionContextImpl == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(7);
        }
        return jSTypeSubstitutionContextImpl;
    }

    @Override
    @NotNull
    public JSTypeSubstitutionContext createNestedContext() {
        JSTypeSubstitutionContextImpl nested = new JSTypeSubstitutionContextImpl(new RecursionCounter(this.getCounter()), ContainerUtil.emptyList(), this.myMap);
        nested.putUserData(JSTypeComparingContextService.NULL_CHECKS, (Boolean)this.getUserData(JSTypeComparingContextService.NULL_CHECKS));
        nested.putUserData(JSTypeComparingContextService.LOCATION, (PsiElement)this.getUserData(JSTypeComparingContextService.LOCATION));
        JSTypeSubstitutionContextImpl jSTypeSubstitutionContextImpl = nested;
        if (jSTypeSubstitutionContextImpl == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(8);
        }
        return jSTypeSubstitutionContextImpl;
    }

    @Override
    @Nullable
    public JSType substituteNested(@NotNull JSType originalType) {
        if (originalType == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(9);
        }
        if (originalType instanceof JSTypeBaseImpl && !((JSTypeBaseImpl)originalType).canBeSubstituted()) {
            return originalType;
        }
        return originalType.substitute(this.createNestedContext());
    }

    @Nullable
    public JSType getGenericParameterTypeFromHierarchyForMappedType(@NotNull JSGenericParameterType parameterType) {
        if (parameterType == null) {
            JSTypeSubstitutionContextImpl.$$$reportNull$$$0(10);
        }
        return this.myCounter.getGenericParameterTypeFromHierarchyForMappedType(parameterType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSubstitutionContextImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSubstitutionContextImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCounter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withGenerics";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisited";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withGenerics";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteNested";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGenericParameterTypeFromHierarchyForMappedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

