/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class JSBlockStatementImpl
extends LazyParseablePsiElement
implements JSBlockStatement {
    private Language myLanguage;

    public JSBlockStatementImpl(@NotNull IElementType elementType, CharSequence buffer) {
        if (elementType == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(0);
        }
        super(elementType, buffer);
    }

    @Override
    public JSStatement @NotNull [] getStatements() {
        JSStatement[] jSStatementArray = JSBlockStatementImpl.getStatements(this);
        if (jSStatementArray == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(1);
        }
        return jSStatementArray;
    }

    @Override
    public JSSourceElement @NotNull [] getStatementListItems() {
        return JSBlockStatementImpl.getInnerStatements(this);
    }

    public static JSSourceElement @NotNull [] getInnerStatements(JSBlockStatement blockStatement) {
        return JSBlockStatementImpl.getInnerStatements((PsiElement)blockStatement);
    }

    public static JSSourceElement @NotNull [] getInnerStatements(PsiElement blockStatement) {
        JSSourceElement[] children = (JSSourceElement[])PsiTreeUtil.getChildrenOfType((PsiElement)blockStatement, JSSourceElement.class);
        JSSourceElement[] jSSourceElementArray = children == null ? JSSourceElement.EMPTY_ARRAY : children;
        if (jSSourceElementArray == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(2);
        }
        return jSSourceElementArray;
    }

    public static JSStatement[] getStatements(JSBlockStatement blockStatement) {
        ASTNode[] nodes = blockStatement.getNode().getChildren(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        JSStatement[] statements = new JSStatement[nodes.length];
        for (int i = 0; i < statements.length; ++i) {
            statements[i] = (JSStatement)nodes[i].getPsi();
        }
        return statements;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSBlock(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        ASTNode node;
        if (element2 == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(4);
        }
        if (element2 instanceof JSStatement && (node = this.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
            PsiElement psiElement = super.addAfter(element2, node.getTreePrev().getPsi());
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), psiElement.getNode());
            return psiElement;
        }
        return super.add(element2);
    }

    @Override
    public JSStatement addStatementBefore(JSStatement toAdd) throws IncorrectOperationException {
        return (JSStatement)JSChangeUtil.doAddBefore(this.getParent(), (PsiElement)toAdd, this);
    }

    @Override
    public JSStatement addStatementAfter(JSStatement toAdd) throws IncorrectOperationException {
        return (JSStatement)JSChangeUtil.doAddAfter(this.getParent(), (PsiElement)toAdd, this);
    }

    @Override
    public JSStatement replace(JSStatement with) {
        return JSChangeUtil.replaceStatement(this, with);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = DialectDetector.calculateJSLanguage(this);
        }
        Language language = this.myLanguage;
        if (language == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(5);
        }
        return language;
    }

    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        if (element2 == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(6);
        }
        return JSChangeUtil.doAddBefore(this, element2, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        if (element2 == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(7);
        }
        return JSChangeUtil.doAddAfter(this, element2, anchor);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(8);
        }
        return JSElementImpl.replaceInParent(this, newElement);
    }

    public String toString() {
        return "JSBlockStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerStatements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

