/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public final class ClassInheritorsScanner
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ClassInheritorsScanner.class);
    private final Class<?> myTargetClass;
    private final Project myProject;
    private final ConcurrentLinkedQueue<ProgressIndicator> myIndicators;

    public ClassInheritorsScanner(@Nullable Project project, @NotNull Class<?> targetClass) {
        if (targetClass == null) {
            ClassInheritorsScanner.$$$reportNull$$$0(0);
        }
        this.myIndicators = new ConcurrentLinkedQueue();
        this.myTargetClass = targetClass;
        this.myProject = project;
    }

    public ActionCallback scanClasses(Supplier<List<VirtualFile>> files2, Consumer<String> consumer) {
        return this.scanClassesInner(false, files2, consumer);
    }

    public ActionCallback scanClassesInner(boolean sync, Supplier<List<VirtualFile>> files2, Consumer<String> consumer) {
        this.clearQueue();
        ProgressManager progressManager = ProgressManager.getInstance();
        final MyProcessor runnable = new MyProcessor(files2, consumer, progressManager);
        String progressTitle = DatabaseBundle.message((String)"progress.scan.for.drivers.title", (Object[])new Object[0]);
        if (sync) {
            progressManager.runProcessWithProgressSynchronously((Runnable)runnable, progressTitle, true, this.myProject);
        } else {
            progressManager.run((Task)new Task.Backgroundable(this.myProject, progressTitle, false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    runnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/util/ClassInheritorsScanner$1", "run"));
                }
            });
        }
        return runnable.myCallback;
    }

    @Nullable
    private static InputStream getResourceAsStream(String url, Collection<VirtualFile> files2) {
        for (VirtualFile file : files2) {
            VirtualFile child;
            Object root = file.isDirectory() ? file : (file.getFileType() instanceof ArchiveFileType ? JarFileSystem.getInstance().getJarRootForLocalFile(file) : null);
            if (root == null || (child = root.findFileByRelativePath(url)) == null) continue;
            try {
                return child.getInputStream();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public void dispose() {
        this.clearQueue();
    }

    private void clearQueue() {
        ProgressIndicator indicator;
        while ((indicator = this.myIndicators.poll()) != null) {
            indicator.cancel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/database/util/ClassInheritorsScanner", "<init>"));
    }

    private final class MyProcessor
    extends VirtualFileVisitor<Void>
    implements Runnable {
        final ProgressManager myProgressManager;
        final NotNullLazyValue<List<VirtualFile>> myFiles;
        final Object2IntMap<String> myCache;
        final Consumer<String> myConsumer;
        final StringBuilder myPackage;
        final ActionCallback myCallback;
        ProgressIndicator myIndicator;

        MyProcessor(Supplier<List<VirtualFile>> files2, Consumer<String> consumer, ProgressManager progressManager) {
            super(new VirtualFileVisitor.Option[0]);
            this.myCache = new Object2IntOpenHashMap();
            this.myPackage = new StringBuilder();
            this.myCallback = new ActionCallback();
            this.myProgressManager = progressManager;
            this.myFiles = NotNullLazyValue.lazy(files2);
            this.myConsumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myIndicator = this.myProgressManager.getProgressIndicator();
                ClassInheritorsScanner.this.myIndicators.add(this.myIndicator);
                this.myIndicator.setIndeterminate(true);
                JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                for (VirtualFile root : (List)this.myFiles.get()) {
                    this.myIndicator.checkCanceled();
                    VirtualFile jarRoot = root.isInLocalFileSystem() ? jarFileSystem.getJarRootForLocalFile(root) : root;
                    this.myPackage.setLength(0);
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)Objects.requireNonNullElse(jarRoot, root), (VirtualFileVisitor)this, RuntimeException.class);
                }
                this.myCallback.setDone();
            }
            finally {
                if (!this.myCallback.isDone()) {
                    this.myCallback.setRejected();
                }
            }
        }

        private InputStream getInputStream(String resource) {
            return ClassInheritorsScanner.getResourceAsStream(resource, (Collection)this.myFiles.get());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isInheritor(final String className, final String baseClassName, final boolean isInterface) {
            boolean inheritor = false;
            int flag = this.myCache.getInt((Object)className);
            if (flag != 0) {
                if (flag != 1) return false;
                return true;
            }
            String classResource = className + ".class";
            try (InputStream inputStream = this.getInputStream(classResource);){
                if (inputStream == null) {
                    boolean bl = false;
                    return bl;
                }
                final Ref result = new Ref((Object)Boolean.FALSE);
                ClassReader reader = new ClassReader(inputStream);
                reader.accept(new ClassVisitor(589824){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return null;
                    }

                    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value) {
                        return null;
                    }

                    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                        return null;
                    }

                    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
                        boolean isIntf;
                        if (!name2.equals(className)) {
                            return;
                        }
                        boolean bl = isIntf = (access & 0x200) != 0;
                        if (isIntf && !isInterface) {
                            return;
                        }
                        if (superName != null && (isIntf == isInterface && superName.equals(baseClassName) || MyProcessor.this.isInheritor(superName, baseClassName, isInterface))) {
                            result.set((Object)Boolean.TRUE);
                            return;
                        }
                        if (isInterface) {
                            for (String anInterface : interfaces) {
                                if (!anInterface.equals(baseClassName) && !MyProcessor.this.isInheritor(anInterface, baseClassName, true)) continue;
                                result.set((Object)Boolean.TRUE);
                                return;
                            }
                        }
                    }
                }, 2);
                inheritor = (Boolean)result.get();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            this.myCache.put((Object)className, inheritor ? 1 : -1);
            return inheritor;
        }

        public void afterChildrenVisited(@NotNull VirtualFile file) {
            if (file == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (!this.myPackage.isEmpty()) {
                this.myPackage.setLength(Math.max(0, this.myPackage.lastIndexOf(".", this.myPackage.length() - 2) + 1));
            }
        }

        public boolean visitFile(@NotNull VirtualFile child) {
            if (child == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            this.myIndicator.checkCanceled();
            if (child.getParent() == null) {
                return true;
            }
            if (child.isDirectory()) {
                this.myIndicator.setText(DatabaseBundle.message((String)"progress.scan.for.drivers.text", (Object[])new Object[]{child.getPath()}));
                this.myIndicator.setText2("");
                String name2 = child.getName();
                if (!StringUtil.isJavaIdentifier((String)name2)) {
                    return false;
                }
                this.myPackage.append(name2).append(".");
                return true;
            }
            if ("class".equals(child.getExtension())) {
                this.myIndicator.setText2(DatabaseBundle.message((String)"progress.scan.for.drivers.text2", (Object[])new Object[]{child.getPresentableName()}));
                String className = String.valueOf(this.myPackage) + child.getNameWithoutExtension();
                if (this.isInheritor(className.replace('.', '/'), ClassInheritorsScanner.this.myTargetClass.getName().replace('.', '/'), ClassInheritorsScanner.this.myTargetClass.isInterface())) {
                    this.myIndicator.checkCanceled();
                    this.myConsumer.accept(className);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/ClassInheritorsScanner$MyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterChildrenVisited";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

