/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelConvertersKt;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.converters.Converter_2_7;
import com.intellij.database.model.serialization.converters.Converter_4_0;
import com.intellij.database.model.serialization.converters.Converter_4_1;
import com.intellij.database.model.serialization.converters.Converter_4_10;
import com.intellij.database.model.serialization.converters.Converter_4_12;
import com.intellij.database.model.serialization.converters.Converter_4_14;
import com.intellij.database.model.serialization.converters.Converter_4_16;
import com.intellij.database.model.serialization.converters.Converter_4_17;
import com.intellij.database.model.serialization.converters.Converter_4_2;
import com.intellij.database.model.serialization.converters.Converter_4_20;
import com.intellij.database.model.serialization.converters.Converter_4_21;
import com.intellij.database.model.serialization.converters.Converter_4_22;
import com.intellij.database.model.serialization.converters.Converter_4_24;
import com.intellij.database.model.serialization.converters.Converter_4_25;
import com.intellij.database.model.serialization.converters.Converter_4_26;
import com.intellij.database.model.serialization.converters.Converter_4_27;
import com.intellij.database.model.serialization.converters.Converter_4_28;
import com.intellij.database.model.serialization.converters.Converter_4_29;
import com.intellij.database.model.serialization.converters.Converter_4_31;
import com.intellij.database.model.serialization.converters.Converter_4_32;
import com.intellij.database.model.serialization.converters.Converter_4_33;
import com.intellij.database.model.serialization.converters.Converter_4_34;
import com.intellij.database.model.serialization.converters.Converter_4_35;
import com.intellij.database.model.serialization.converters.Converter_4_36;
import com.intellij.database.model.serialization.converters.Converter_4_37;
import com.intellij.database.model.serialization.converters.Converter_4_38;
import com.intellij.database.model.serialization.converters.Converter_4_39;
import com.intellij.database.model.serialization.converters.Converter_4_40;
import com.intellij.database.model.serialization.converters.Converter_4_41;
import com.intellij.database.model.serialization.converters.Converter_4_42;
import com.intellij.database.model.serialization.converters.Converter_4_43;
import com.intellij.database.model.serialization.converters.Converter_4_44;
import com.intellij.database.model.serialization.converters.Converter_4_45;
import com.intellij.database.model.serialization.converters.Converter_4_46;
import com.intellij.database.model.serialization.converters.Converter_4_47;
import com.intellij.database.model.serialization.converters.Converter_4_48;
import com.intellij.database.model.serialization.converters.Converter_4_49;
import com.intellij.database.model.serialization.converters.Converter_4_50;
import com.intellij.database.model.serialization.converters.Converter_4_51;
import com.intellij.database.model.serialization.converters.Converter_4_52;
import com.intellij.database.model.serialization.converters.Converter_4_53;
import com.intellij.database.util.Version;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/model/serialization/ModelConverters;", "", "<init>", "()V", "ourConverters", "", "Lcom/intellij/database/model/serialization/Converter;", "getConverters", "Lkotlin/sequences/Sequence;", "ver", "Lcom/intellij/database/util/Version;", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "applyMem", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "getter", "Lkotlin/Function1;", "Lcom/intellij/database/model/serialization/ModelElementMem;", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "alignDbmsWithRoot", "convertModel", "since", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nModelConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelConverters.kt\ncom/intellij/database/model/serialization/ModelConverters\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1321#2,2:142\n1321#2,2:144\n1321#2,2:147\n1#3:146\n*S KotlinDebug\n*F\n+ 1 ModelConverters.kt\ncom/intellij/database/model/serialization/ModelConverters\n*L\n72#1:142,2\n79#1:144,2\n94#1:147,2\n*E\n"})
public final class ModelConverters {
    @NotNull
    private final List<Converter> ourConverters;

    public ModelConverters() {
        Object[] objectArray = new Converter[]{Converter_2_7.INSTANCE, Converter_4_0.INSTANCE, Converter_4_1.INSTANCE, Converter_4_2.INSTANCE, Converter_4_10.INSTANCE, Converter_4_12.INSTANCE, Converter_4_14.INSTANCE, Converter_4_16.INSTANCE, Converter_4_17.INSTANCE, Converter_4_20.INSTANCE, Converter_4_21.INSTANCE, Converter_4_22.INSTANCE, Converter_4_24.INSTANCE, Converter_4_25.INSTANCE, Converter_4_26.INSTANCE, Converter_4_27.INSTANCE, Converter_4_28.INSTANCE, Converter_4_29.INSTANCE, Converter_4_31.INSTANCE, Converter_4_32.INSTANCE, Converter_4_33.INSTANCE, Converter_4_34.INSTANCE, Converter_4_35.INSTANCE, Converter_4_36.INSTANCE, Converter_4_37.INSTANCE, Converter_4_38.INSTANCE, Converter_4_39.INSTANCE, Converter_4_40.INSTANCE, Converter_4_41.INSTANCE, Converter_4_42.INSTANCE, Converter_4_43.INSTANCE, Converter_4_44.INSTANCE, Converter_4_45.INSTANCE, Converter_4_46.INSTANCE, Converter_4_47.INSTANCE, Converter_4_48.INSTANCE, Converter_4_49.INSTANCE, Converter_4_50.INSTANCE, Converter_4_51.INSTANCE, Converter_4_52.INSTANCE, Converter_4_53.INSTANCE};
        this.ourConverters = CollectionsKt.listOf((Object[])objectArray);
    }

    private final Sequence<Converter> getConverters(Version ver) {
        if (ver.isOrGreater(ModelSerializationVersions.CURRENT_VERSION)) {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.ourConverters), arg_0 -> ModelConverters.getConverters$lambda$0(ver, arg_0));
    }

    public final void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Version ver = modelMem.getVersion();
        if (ver.isOrGreater(ModelSerializationVersions.CURRENT_VERSION)) {
            return;
        }
        Sequence<Converter> $this$forEach$iv = this.getConverters(ver);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Converter it = (Converter)element$iv;
            boolean bl = false;
            it.convertMem(modelMem);
        }
        this.alignDbmsWithRoot(modelMem);
    }

    public final void applyMem(@NotNull ModelMem modelMem, @NotNull BasicModModel model, @NotNull Function1<? super ModelElementMem, ? extends BasicHierarchicalObject> getter) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
        Sequence<Converter> $this$forEach$iv = this.getConverters(modelMem.getVersion());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Converter it = (Converter)element$iv;
            boolean bl = false;
            it.applyMem(modelMem, model, getter);
        }
    }

    private final void alignDbmsWithRoot(ModelMem modelMem) {
        ModelElementMem modelElementMem = ModelConvertersKt.findFirst(modelMem, (Function1<? super ModelElementMem, Boolean>)((Function1)ModelConverters::alignDbmsWithRoot$lambda$3));
        if (modelElementMem == null) {
            return;
        }
        ModelElementMem root = modelElementMem;
        String dbmsName = ModelConvertersKt.getProperty(root, "Dbms");
        if (!Intrinsics.areEqual((Object)dbmsName, (Object)modelMem.getDbms().getName())) {
            Dbms dbms;
            String string = dbmsName;
            if (string != null) {
                String it = string;
                boolean bl = false;
                v2 = Dbms.byName(it);
            } else {
                v2 = dbms = null;
            }
            if (dbms != null) {
                modelMem.setDbms(dbms);
            }
        }
    }

    public final void convertModel(@NotNull BasicModModel model, @NotNull Version since) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Sequence<Converter> $this$forEach$iv = this.getConverters(since);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Converter it = (Converter)element$iv;
            boolean bl = false;
            it.convertModel(model);
        }
    }

    private static final boolean getConverters$lambda$0(Version $ver, Converter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $ver.less(it.getVersion());
    }

    private static final boolean alignDbmsWithRoot$lambda$3(ModelElementMem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getKind(), (Object)"root");
    }
}

