/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicPositionReference
implements BasicReference {
    private final short position;

    private BasicPositionReference(short position) {
        this.position = position;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public long getObjectId() {
        return Long.MIN_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicPositionReference)) {
            return false;
        }
        BasicPositionReference reference = (BasicPositionReference)o;
        return this.position == reference.position;
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }

    @Nullable
    public static BasicPositionReference create(short position) {
        return BasicPositionReference.isDefault(position) ? null : new BasicPositionReference(position);
    }

    public static boolean isDefault(short position) {
        return position == 0;
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicPositionReference.$$$reportNull$$$0(0);
        }
        if (meta == null) {
            BasicPositionReference.$$$reportNull$$$0(1);
        }
        if (assistant == null) {
            BasicPositionReference.$$$reportNull$$$0(2);
        }
        JBIterable jBIterable = JBIterable.of(this.resolve(source, meta, assistant));
        if (jBIterable == null) {
            BasicPositionReference.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public <S extends BasicElement, T extends BasicElement> T resolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        BasicElement base;
        BasicElement root;
        if (source == null) {
            BasicPositionReference.$$$reportNull$$$0(4);
        }
        if (meta == null) {
            BasicPositionReference.$$$reportNull$$$0(5);
        }
        if (assistant == null) {
            BasicPositionReference.$$$reportNull$$$0(6);
        }
        BasicElement basicElement = root = (base = BasicMetaUtils.getResolveBase(source, meta, assistant)) == null ? null : assistant.getRestrictedRoot(base, 1, meta.targets);
        if (root == null) {
            return null;
        }
        for (BasicMetaObject basicMetaObject : meta.targets) {
            Object res;
            Object family = BasicMetaUtils.getFamily(root, basicMetaObject);
            if (!(family instanceof PositioningFamily) || (res = ((PositioningFamily)family).getByNaturalPosition(this.position)) == null) continue;
            return (T)res;
        }
        return null;
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target2) {
        if (source == null) {
            BasicPositionReference.$$$reportNull$$$0(7);
        }
        if (meta == null) {
            BasicPositionReference.$$$reportNull$$$0(8);
        }
        if (target2 == null) {
            BasicPositionReference.$$$reportNull$$$0(9);
        }
        return target2 instanceof BasicArrangedElement && ((BasicArrangedElement)target2).getPosition() == this.position;
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicPositionReference.$$$reportNull$$$0(10);
        }
        if (!BasicPositionReference.isDefault(this.position)) {
            consumer.accept("Position", Short.toString(this.position));
        }
    }

    @Nullable
    public static BasicPositionReference importProperties(@NotNull NameValueGetter<String> properties2) {
        String pos;
        if (properties2 == null) {
            BasicPositionReference.$$$reportNull$$$0(11);
        }
        short position = (pos = properties2.get("Position")) == null ? (short)0 : (short)StringUtil.parseInt((String)pos, (int)0);
        return BasicPositionReference.create(position);
    }

    public String toString() {
        return "pos=" + this.position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicPositionReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicPositionReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

