/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsGeneratedModelUtil;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsTableOrView;
import com.intellij.database.dialects.mssql.model.MsTableOrViewColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014JP\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0014J\u0012\u0010\u0019\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0002J&\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J$\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J$\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/mssql/MsPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInOperator", "", "getSupportsInOperator", "()Z", "ftsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "columnRef", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "alias", "", "version", "Lcom/intellij/database/util/Version;", "likePredicate", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "op", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "typeName", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "getDomain", "getInnerDomain", "column", "Lcom/intellij/database/model/DasColumn;", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsPredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsPredicatesHelper.kt\ncom/intellij/database/dialects/mssql/MsPredicatesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1761#2,3:106\n1#3:109\n*S KotlinDebug\n*F\n+ 1 MsPredicatesHelper.kt\ncom/intellij/database/dialects/mssql/MsPredicatesHelper\n*L\n32#1:106,3\n*E\n"})
public final class MsPredicatesHelper
extends BasePredicatesHelper {
    public MsPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    public boolean getSupportsInOperator() {
        return true;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable String alias, @Nullable Version version) {
        boolean hasFulltextIndex;
        block6: {
            Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            BasicTableOrViewColumn column2 = PredicatesUtilKt.toBasicColumn(columnRef);
            if (column2 == null || !(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
                return null;
            }
            BasicTableOrView basicTableOrView = column2.getTable();
            MsTableOrView msTableOrView = basicTableOrView instanceof MsTableOrView ? (MsTableOrView)basicTableOrView : null;
            if (msTableOrView == null) {
                return null;
            }
            MsTableOrView table = msTableOrView;
            ModPositioningNamingFamily<? extends MsLikeIndex> modPositioningNamingFamily = table.getIndices();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getIndices(...)");
            Iterable $this$any$iv = modPositioningNamingFamily;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List<? extends BasicLikeColumn> indexCols;
                    MsLikeIndex index = (MsLikeIndex)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(index.getCols(), (String)"getCols(...)");
                    if (!(indexCols.size() == 1 && Intrinsics.areEqual((Object)indexCols.get(0), (Object)column2) && index instanceof MsIndex && ((MsIndex)index).isFulltext())) continue;
                    v2 = true;
                    break block6;
                }
                v2 = hasFulltextIndex = false;
            }
        }
        if (!hasFulltextIndex) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, ContainsInIndexedTextOperation.INSTANCE, (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> MsPredicatesHelper.ftsPredicate$lambda$1(alias, columnRef, value, this, arg_0)));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        v0 = domain;
        v1 = v0 != null ? v0.supports(OperationKt.LIKE_OPERATION) : (typeSupportsOperation = false);
        if (!canCastToText || !this.canCastToText(columnRef.getTypeName())) ** GOTO lbl-1000
        v2 = domain;
        if (!(v2 != null ? v2.supports(OperationKt.EQUALS_TO_NUMBER_OPERATION) : false)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = canCast = false;
        }
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        v4 = PredicatesUtilKt.getLikeKeyword(op.getMatchCase(), op.isNotLike(), this.getDbms(), version, inUpdate);
        if (v4 == null) {
            return null;
        }
        likeWord = v4;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, op, (Function1<? super DdlBuilder, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, likePredicate$lambda$2(boolean java.lang.String com.intellij.database.data.types.ColumnRef java.lang.String com.intellij.database.data.types.PredicateValue com.intellij.database.dialects.mssql.MsPredicatesHelper com.intellij.database.data.types.LikePredicateOperation com.intellij.database.util.DdlBuilder ), (Lcom/intellij/database/util/DdlBuilder;)Lkotlin/Unit;)((boolean)typeSupportsOperation, (String)alias, (ColumnRef)columnRef, (String)likeWord, (PredicateValue)value, (MsPredicatesHelper)this, (LikePredicateOperation)op));
    }

    private final boolean canCastToText(String typeName) {
        String string;
        String string2 = typeName;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = StringUtil.toLowerCase((String)it);
        } else {
            string = null;
        }
        return !Intrinsics.areEqual(string, (Object)"image");
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Object[] objectArray;
        LogicalType type;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        Object object = type = domain2 != null ? domain2.getLogicType() : null;
        if (type != null && ArraysKt.contains((Object[])(objectArray = new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE, LogicalType.UUID, LogicalType.TEXT_UUID}), (Object)type)) {
            return PredicatesUtilKt.getFormatTester(columnRef, this.getDbms(), type);
        }
        return null;
    }

    @Override
    @Nullable
    protected Domain getDomain(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Version version) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                object = PredicatesUtilKt.toBasicColumn(columnRef);
                if (object == null) break block2;
                BasicTableOrViewColumn col = object;
                boolean bl = false;
                Domain domain = this.getInnerDomain(col, this.getDbms(), version);
                object = domain;
                if (domain != null) break block3;
            }
            object = super.getDomain(columnRef, value, version);
        }
        return object;
    }

    private final Domain getInnerDomain(DasColumn column2, Dbms dbms, Version version) {
        Domain domain;
        if (!(column2 instanceof MsTableOrViewColumn)) {
            return null;
        }
        DomainRegistry domainRegistry = BaseDomainRegistry.get(dbms, version);
        Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"get(...)");
        DomainRegistry registry = domainRegistry;
        DasType dasType = ((MsTableOrViewColumn)column2).getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        MsAliasType type = MsGeneratedModelUtil.resolveType(dasType2, ((MsTableOrViewColumn)column2).getSchema());
        if (type != null) {
            DasType dasType3 = type.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
            domain = registry.getDomain(new TypeNameColumnDescriptor(DasTypeUtilsKt.getTypeName(dasType3)));
        } else {
            domain = registry.getDomain(new TypeNameColumnDescriptor(DasTypeUtilsKt.getTypeName(dasType2)));
        }
        return domain;
    }

    private static final Unit ftsPredicate$lambda$1(String $alias, ColumnRef $columnRef, PredicateValue $value, MsPredicatesHelper this$0, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.keyword("CONTAINS").symbol("(");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
        DdlBuilder ddlBuilder2 = PredicatesUtilKt.identifier(ddlBuilder, $alias, $columnRef).symbol(",").space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"space(...)");
        PredicatesUtilKt.value(ddlBuilder2, $value, $columnRef, this$0.getDbms(), DbImplUtilCore.StringLiteralDecorator.PLAIN);
        builder.symbol(")");
        return Unit.INSTANCE;
    }

    private static final Unit likePredicate$lambda$2(boolean $typeSupportsOperation, String $alias, ColumnRef $columnRef, String $likeWord, PredicateValue $value, MsPredicatesHelper this$0, LikePredicateOperation $op, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!$typeSupportsOperation) {
            DdlBuilder ddlBuilder = builder.keyword("CAST").symbol("(");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
            v1 = PredicatesUtilKt.identifier(ddlBuilder, $alias, $columnRef).space().keyword("AS").space().type("VARCHAR").symbol(")");
        } else {
            v1 = PredicatesUtilKt.identifier(builder, $alias, $columnRef);
        }
        DdlBuilder ddlBuilder = builder.space().keyword($likeWord).space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        PredicatesUtilKt.value(ddlBuilder, $value, $columnRef, this$0.getDbms(), $op.getLikeType().getDecorator());
        return Unit.INSTANCE;
    }
}

