/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.WeakSetPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.CanBeHeldWeaklyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.builtins.JSWeakSetObject;

public final class WeakSetPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WeakSetPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WeakSetPrototypeBuiltins();
    protected static final Object PRESENT = new Object();

    protected WeakSetPrototypeBuiltins() {
        super(JSWeakSet.PROTOTYPE_NAME, WeakSetPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WeakSetPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WeakSetPrototypeBuiltinsFactory.JSWeakSetDeleteNodeGen.create(context, builtin, WeakSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return WeakSetPrototypeBuiltinsFactory.JSWeakSetAddNodeGen.create(context, builtin, WeakSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return WeakSetPrototypeBuiltinsFactory.JSWeakSetHasNodeGen.create(context, builtin, WeakSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static RuntimeException typeErrorKeyIsNotObject() {
        throw Errors.createTypeError("Invalid value used in weak set");
    }

    protected static RuntimeException typeErrorWeakSetExpected() {
        throw Errors.createTypeError("WeakSet expected");
    }

    public static enum WeakSetPrototype implements BuiltinEnum<WeakSetPrototype>
    {
        delete(1),
        add(1),
        has(1);

        private final int length;

        private WeakSetPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSWeakSetDeleteNode
    extends JSBuiltinNode {
        public JSWeakSetDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static boolean delete(JSWeakSetObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return Boundaries.mapRemove(thisObj.getWeakHashMap(), key) != null;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static boolean deleteNonObjectKey(JSWeakSetObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakSet(thisObj)"})
        protected static boolean notWeakSet(Object thisObj, Object key) {
            throw WeakSetPrototypeBuiltins.typeErrorWeakSetExpected();
        }
    }

    public static abstract class JSWeakSetAddNode
    extends JSBuiltinNode {
        public JSWeakSetAddNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static JSWeakSetObject add(JSWeakSetObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            Boundaries.mapPut(thisObj.getWeakHashMap(), key, PRESENT);
            return thisObj;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static JSWeakSetObject addNonObjectKey(JSWeakSetObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            throw WeakSetPrototypeBuiltins.typeErrorKeyIsNotObject();
        }

        @Specialization(guards={"!isJSWeakSet(thisObj)"})
        protected static JSWeakSetObject notWeakSet(Object thisObj, Object key) {
            throw WeakSetPrototypeBuiltins.typeErrorWeakSetExpected();
        }
    }

    public static abstract class JSWeakSetHasNode
    extends JSBuiltinNode {
        public JSWeakSetHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static boolean has(JSWeakSetObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return Boundaries.mapContainsKey(thisObj.getWeakHashMap(), key);
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static boolean hasNonObjectKey(JSWeakSetObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakSet(thisObj)"})
        protected static boolean notWeakSet(Object thisObj, Object key) {
            throw WeakSetPrototypeBuiltins.typeErrorWeakSetExpected();
        }
    }
}

