/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.checksum;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.DirectoryUtils;

abstract class FileTrustedChecksumsSourceSupport
implements TrustedChecksumsSource {
    private static final String CONFIG_PROP_PREFIX = "aether.trustedChecksumsSource.";
    private static final String CONF_NAME_BASEDIR = "basedir";
    private static final String CONF_NAME_ORIGIN_AWARE = "originAware";
    static final String LOCAL_REPO_PREFIX_DIR = ".checksums";
    private final String name;

    FileTrustedChecksumsSourceSupport(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public Map<String, String> getTrustedArtifactChecksums(RepositorySystemSession session, Artifact artifact, ArtifactRepository artifactRepository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(artifact, "artifact is null");
        Objects.requireNonNull(artifactRepository, "artifactRepository is null");
        Objects.requireNonNull(checksumAlgorithmFactories, "checksumAlgorithmFactories is null");
        if (this.isEnabled(session)) {
            return Objects.requireNonNull(this.doGetTrustedArtifactChecksums(session, artifact, artifactRepository, checksumAlgorithmFactories));
        }
        return null;
    }

    @Override
    public TrustedChecksumsSource.Writer getTrustedArtifactChecksumsWriter(RepositorySystemSession session) {
        Objects.requireNonNull(session, "session is null");
        if (this.isEnabled(session)) {
            return this.doGetTrustedArtifactChecksumsWriter(session);
        }
        return null;
    }

    protected abstract Map<String, String> doGetTrustedArtifactChecksums(RepositorySystemSession var1, Artifact var2, ArtifactRepository var3, List<ChecksumAlgorithmFactory> var4);

    protected TrustedChecksumsSource.Writer doGetTrustedArtifactChecksumsWriter(RepositorySystemSession session) {
        return null;
    }

    protected String configPropKey(String name) {
        Objects.requireNonNull(name);
        return CONFIG_PROP_PREFIX + this.name + "." + name;
    }

    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_PREFIX + this.name);
    }

    protected boolean isOriginAware(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, true, this.configPropKey(CONF_NAME_ORIGIN_AWARE));
    }

    protected Path getBasedir(RepositorySystemSession session, boolean mayCreate) {
        try {
            return DirectoryUtils.resolveDirectory(session, LOCAL_REPO_PREFIX_DIR, this.configPropKey(CONF_NAME_BASEDIR), mayCreate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

