package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSmartAccessGateway invokes the smartag.DeleteSmartAccessGateway API synchronously
func (client *Client) DeleteSmartAccessGateway(request *DeleteSmartAccessGatewayRequest) (response *DeleteSmartAccessGatewayResponse, err error) {
	response = CreateDeleteSmartAccessGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSmartAccessGatewayWithChan invokes the smartag.DeleteSmartAccessGateway API asynchronously
func (client *Client) DeleteSmartAccessGatewayWithChan(request *DeleteSmartAccessGatewayRequest) (<-chan *DeleteSmartAccessGatewayResponse, <-chan error) {
	responseChan := make(chan *DeleteSmartAccessGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSmartAccessGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSmartAccessGatewayWithCallback invokes the smartag.DeleteSmartAccessGateway API asynchronously
func (client *Client) DeleteSmartAccessGatewayWithCallback(request *DeleteSmartAccessGatewayRequest, callback func(response *DeleteSmartAccessGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSmartAccessGatewayResponse
		var err error
		defer close(result)
		response, err = client.DeleteSmartAccessGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSmartAccessGatewayRequest is the request struct for api DeleteSmartAccessGateway
type DeleteSmartAccessGatewayRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
}

// DeleteSmartAccessGatewayResponse is the response struct for api DeleteSmartAccessGateway
type DeleteSmartAccessGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSmartAccessGatewayRequest creates a request to invoke DeleteSmartAccessGateway API
func CreateDeleteSmartAccessGatewayRequest() (request *DeleteSmartAccessGatewayRequest) {
	request = &DeleteSmartAccessGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DeleteSmartAccessGateway", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSmartAccessGatewayResponse creates a response to parse from DeleteSmartAccessGateway response
func CreateDeleteSmartAccessGatewayResponse() (response *DeleteSmartAccessGatewayResponse) {
	response = &DeleteSmartAccessGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
