package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcList invokes the sas.DescribeVpcList API synchronously
func (client *Client) DescribeVpcList(request *DescribeVpcListRequest) (response *DescribeVpcListResponse, err error) {
	response = CreateDescribeVpcListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcListWithChan invokes the sas.DescribeVpcList API asynchronously
func (client *Client) DescribeVpcListWithChan(request *DescribeVpcListRequest) (<-chan *DescribeVpcListResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcListWithCallback invokes the sas.DescribeVpcList API asynchronously
func (client *Client) DescribeVpcListWithCallback(request *DescribeVpcListRequest, callback func(response *DescribeVpcListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcListRequest is the request struct for api DescribeVpcList
type DescribeVpcListRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeVpcListResponse is the response struct for api DescribeVpcList
type DescribeVpcListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Count     int    `json:"Count" xml:"Count"`
	VpcList   []Vpc  `json:"VpcList" xml:"VpcList"`
}

// CreateDescribeVpcListRequest creates a request to invoke DescribeVpcList API
func CreateDescribeVpcListRequest() (request *DescribeVpcListRequest) {
	request = &DescribeVpcListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeVpcList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcListResponse creates a response to parse from DescribeVpcList response
func CreateDescribeVpcListResponse() (response *DescribeVpcListResponse) {
	response = &DescribeVpcListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
