package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSwimmingLanePriority invokes the edas.UpdateSwimmingLanePriority API synchronously
func (client *Client) UpdateSwimmingLanePriority(request *UpdateSwimmingLanePriorityRequest) (response *UpdateSwimmingLanePriorityResponse, err error) {
	response = CreateUpdateSwimmingLanePriorityResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSwimmingLanePriorityWithChan invokes the edas.UpdateSwimmingLanePriority API asynchronously
func (client *Client) UpdateSwimmingLanePriorityWithChan(request *UpdateSwimmingLanePriorityRequest) (<-chan *UpdateSwimmingLanePriorityResponse, <-chan error) {
	responseChan := make(chan *UpdateSwimmingLanePriorityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSwimmingLanePriority(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSwimmingLanePriorityWithCallback invokes the edas.UpdateSwimmingLanePriority API asynchronously
func (client *Client) UpdateSwimmingLanePriorityWithCallback(request *UpdateSwimmingLanePriorityRequest, callback func(response *UpdateSwimmingLanePriorityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSwimmingLanePriorityResponse
		var err error
		defer close(result)
		response, err = client.UpdateSwimmingLanePriority(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSwimmingLanePriorityRequest is the request struct for api UpdateSwimmingLanePriority
type UpdateSwimmingLanePriorityRequest struct {
	*requests.RoaRequest
	Priorities string `position:"Query" name:"Priorities"`
}

// UpdateSwimmingLanePriorityResponse is the response struct for api UpdateSwimmingLanePriority
type UpdateSwimmingLanePriorityResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateSwimmingLanePriorityRequest creates a request to invoke UpdateSwimmingLanePriority API
func CreateUpdateSwimmingLanePriorityRequest() (request *UpdateSwimmingLanePriorityRequest) {
	request = &UpdateSwimmingLanePriorityRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateSwimmingLanePriority", "/pop/v5/trafficmgnt/swimming_lane", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSwimmingLanePriorityResponse creates a response to parse from UpdateSwimmingLanePriority response
func CreateUpdateSwimmingLanePriorityResponse() (response *UpdateSwimmingLanePriorityResponse) {
	response = &UpdateSwimmingLanePriorityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
