package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteShortUrl invokes the dysmsapi.DeleteShortUrl API synchronously
func (client *Client) DeleteShortUrl(request *DeleteShortUrlRequest) (response *DeleteShortUrlResponse, err error) {
	response = CreateDeleteShortUrlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteShortUrlWithChan invokes the dysmsapi.DeleteShortUrl API asynchronously
func (client *Client) DeleteShortUrlWithChan(request *DeleteShortUrlRequest) (<-chan *DeleteShortUrlResponse, <-chan error) {
	responseChan := make(chan *DeleteShortUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteShortUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteShortUrlWithCallback invokes the dysmsapi.DeleteShortUrl API asynchronously
func (client *Client) DeleteShortUrlWithCallback(request *DeleteShortUrlRequest, callback func(response *DeleteShortUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteShortUrlResponse
		var err error
		defer close(result)
		response, err = client.DeleteShortUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteShortUrlRequest is the request struct for api DeleteShortUrl
type DeleteShortUrlRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Body" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SourceUrl            string           `position:"Body" name:"SourceUrl"`
}

// DeleteShortUrlResponse is the response struct for api DeleteShortUrl
type DeleteShortUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteShortUrlRequest creates a request to invoke DeleteShortUrl API
func CreateDeleteShortUrlRequest() (request *DeleteShortUrlRequest) {
	request = &DeleteShortUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "DeleteShortUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteShortUrlResponse creates a response to parse from DeleteShortUrl response
func CreateDeleteShortUrlResponse() (response *DeleteShortUrlResponse) {
	response = &DeleteShortUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
