package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClusterNodePool invokes the cs.CreateClusterNodePool API synchronously
func (client *Client) CreateClusterNodePool(request *CreateClusterNodePoolRequest) (response *CreateClusterNodePoolResponse, err error) {
	response = CreateCreateClusterNodePoolResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClusterNodePoolWithChan invokes the cs.CreateClusterNodePool API asynchronously
func (client *Client) CreateClusterNodePoolWithChan(request *CreateClusterNodePoolRequest) (<-chan *CreateClusterNodePoolResponse, <-chan error) {
	responseChan := make(chan *CreateClusterNodePoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClusterNodePool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterNodePoolWithCallback invokes the cs.CreateClusterNodePool API asynchronously
func (client *Client) CreateClusterNodePoolWithCallback(request *CreateClusterNodePoolRequest, callback func(response *CreateClusterNodePoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterNodePoolResponse
		var err error
		defer close(result)
		response, err = client.CreateClusterNodePool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterNodePoolRequest is the request struct for api CreateClusterNodePool
type CreateClusterNodePoolRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// CreateClusterNodePoolResponse is the response struct for api CreateClusterNodePool
type CreateClusterNodePoolResponse struct {
	*responses.BaseResponse
	NodepoolId string `json:"nodepool_id" xml:"nodepool_id"`
}

// CreateCreateClusterNodePoolRequest creates a request to invoke CreateClusterNodePool API
func CreateCreateClusterNodePoolRequest() (request *CreateClusterNodePoolRequest) {
	request = &CreateClusterNodePoolRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "CreateClusterNodePool", "/clusters/[ClusterId]/nodepools", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateClusterNodePoolResponse creates a response to parse from CreateClusterNodePool response
func CreateCreateClusterNodePoolResponse() (response *CreateClusterNodePoolResponse) {
	response = &CreateClusterNodePoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
