package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProfileHistoryList invokes the cloudwf.ProfileHistoryList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/profilehistorylist.html
func (client *Client) ProfileHistoryList(request *ProfileHistoryListRequest) (response *ProfileHistoryListResponse, err error) {
	response = CreateProfileHistoryListResponse()
	err = client.DoAction(request, response)
	return
}

// ProfileHistoryListWithChan invokes the cloudwf.ProfileHistoryList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/profilehistorylist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileHistoryListWithChan(request *ProfileHistoryListRequest) (<-chan *ProfileHistoryListResponse, <-chan error) {
	responseChan := make(chan *ProfileHistoryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProfileHistoryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProfileHistoryListWithCallback invokes the cloudwf.ProfileHistoryList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/profilehistorylist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileHistoryListWithCallback(request *ProfileHistoryListRequest, callback func(response *ProfileHistoryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProfileHistoryListResponse
		var err error
		defer close(result)
		response, err = client.ProfileHistoryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProfileHistoryListRequest is the request struct for api ProfileHistoryList
type ProfileHistoryListRequest struct {
	*requests.RpcRequest
	Idtype requests.Integer `position:"Query" name:"Idtype"`
	Page   requests.Integer `position:"Query" name:"Page"`
	Per    requests.Integer `position:"Query" name:"Per"`
	Agsid  requests.Integer `position:"Query" name:"Agsid"`
}

// ProfileHistoryListResponse is the response struct for api ProfileHistoryList
type ProfileHistoryListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateProfileHistoryListRequest creates a request to invoke ProfileHistoryList API
func CreateProfileHistoryListRequest() (request *ProfileHistoryListRequest) {
	request = &ProfileHistoryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ProfileHistoryList", "cloudwf", "openAPI")
	return
}

// CreateProfileHistoryListResponse creates a response to parse from ProfileHistoryList response
func CreateProfileHistoryListResponse() (response *ProfileHistoryListResponse) {
	response = &ProfileHistoryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
