package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetExecutionDetailsOfPredictiveJob invokes the cloudcallcenter.GetExecutionDetailsOfPredictiveJob API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getexecutiondetailsofpredictivejob.html
func (client *Client) GetExecutionDetailsOfPredictiveJob(request *GetExecutionDetailsOfPredictiveJobRequest) (response *GetExecutionDetailsOfPredictiveJobResponse, err error) {
	response = CreateGetExecutionDetailsOfPredictiveJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetExecutionDetailsOfPredictiveJobWithChan invokes the cloudcallcenter.GetExecutionDetailsOfPredictiveJob API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getexecutiondetailsofpredictivejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetExecutionDetailsOfPredictiveJobWithChan(request *GetExecutionDetailsOfPredictiveJobRequest) (<-chan *GetExecutionDetailsOfPredictiveJobResponse, <-chan error) {
	responseChan := make(chan *GetExecutionDetailsOfPredictiveJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetExecutionDetailsOfPredictiveJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetExecutionDetailsOfPredictiveJobWithCallback invokes the cloudcallcenter.GetExecutionDetailsOfPredictiveJob API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getexecutiondetailsofpredictivejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetExecutionDetailsOfPredictiveJobWithCallback(request *GetExecutionDetailsOfPredictiveJobRequest, callback func(response *GetExecutionDetailsOfPredictiveJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetExecutionDetailsOfPredictiveJobResponse
		var err error
		defer close(result)
		response, err = client.GetExecutionDetailsOfPredictiveJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetExecutionDetailsOfPredictiveJobRequest is the request struct for api GetExecutionDetailsOfPredictiveJob
type GetExecutionDetailsOfPredictiveJobRequest struct {
	*requests.RpcRequest
	JobId        string `position:"Query" name:"JobId"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
}

// GetExecutionDetailsOfPredictiveJobResponse is the response struct for api GetExecutionDetailsOfPredictiveJob
type GetExecutionDetailsOfPredictiveJobResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Job            Job    `json:"Job" xml:"Job"`
}

// CreateGetExecutionDetailsOfPredictiveJobRequest creates a request to invoke GetExecutionDetailsOfPredictiveJob API
func CreateGetExecutionDetailsOfPredictiveJobRequest() (request *GetExecutionDetailsOfPredictiveJobRequest) {
	request = &GetExecutionDetailsOfPredictiveJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetExecutionDetailsOfPredictiveJob", "", "")
	request.Method = requests.POST
	return
}

// CreateGetExecutionDetailsOfPredictiveJobResponse creates a response to parse from GetExecutionDetailsOfPredictiveJob response
func CreateGetExecutionDetailsOfPredictiveJobResponse() (response *GetExecutionDetailsOfPredictiveJobResponse) {
	response = &GetExecutionDetailsOfPredictiveJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
