/*
 * list fetched from https://github.com/spdx/license-list-data @ v3.27.0
 *
 * AUTO-GENERATED BY ./update
 * DO NOT MODIFY
 *
 * cargo run --manifest-path update/Cargo.toml -- v<version> > src/identifiers.rs
*/

use crate::flags::*;
use crate::{Exception, License};

pub const VERSION: &str = "3.27.0";

pub const LICENSES: &[License] = &[
    License {
        name: "0BSD",
        full_name: r#"BSD Zero Clause License"#,
        index: 0,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "3D-Slicer-1.0",
        full_name: r#"3D Slicer License v1.0"#,
        index: 1,
        flags: 0x0,
    },
    License {
        name: "AAL",
        full_name: r#"Attribution Assurance License"#,
        index: 2,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "ADSL",
        full_name: r#"Amazon Digital Services License"#,
        index: 3,
        flags: 0x0,
    },
    License {
        name: "AFL-1.1",
        full_name: r#"Academic Free License v1.1"#,
        index: 4,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "AFL-1.2",
        full_name: r#"Academic Free License v1.2"#,
        index: 5,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "AFL-2.0",
        full_name: r#"Academic Free License v2.0"#,
        index: 6,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "AFL-2.1",
        full_name: r#"Academic Free License v2.1"#,
        index: 7,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "AFL-3.0",
        full_name: r#"Academic Free License v3.0"#,
        index: 8,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "AGPL-1.0",
        full_name: r#"Affero General Public License v1.0"#,
        index: 9,
        flags: IS_DEPRECATED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "AGPL-1.0-only",
        full_name: r#"Affero General Public License v1.0 only"#,
        index: 10,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "AGPL-1.0-or-later",
        full_name: r#"Affero General Public License v1.0 or later"#,
        index: 11,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "AGPL-3.0",
        full_name: r#"GNU Affero General Public License v3.0"#,
        index: 12,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "AGPL-3.0-only",
        full_name: r#"GNU Affero General Public License v3.0 only"#,
        index: 13,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "AGPL-3.0-or-later",
        full_name: r#"GNU Affero General Public License v3.0 or later"#,
        index: 14,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "AMD-newlib",
        full_name: r#"AMD newlib License"#,
        index: 15,
        flags: 0x0,
    },
    License {
        name: "AMDPLPA",
        full_name: r#"AMD's plpa_map.c License"#,
        index: 16,
        flags: 0x0,
    },
    License {
        name: "AML",
        full_name: r#"Apple MIT License"#,
        index: 17,
        flags: 0x0,
    },
    License {
        name: "AML-glslang",
        full_name: r#"AML glslang variant License"#,
        index: 18,
        flags: 0x0,
    },
    License {
        name: "AMPAS",
        full_name: r#"Academy of Motion Picture Arts and Sciences BSD"#,
        index: 19,
        flags: 0x0,
    },
    License {
        name: "ANTLR-PD",
        full_name: r#"ANTLR Software Rights Notice"#,
        index: 20,
        flags: 0x0,
    },
    License {
        name: "ANTLR-PD-fallback",
        full_name: r#"ANTLR Software Rights Notice with license fallback"#,
        index: 21,
        flags: 0x0,
    },
    License {
        name: "APAFML",
        full_name: r#"Adobe Postscript AFM License"#,
        index: 22,
        flags: 0x0,
    },
    License {
        name: "APL-1.0",
        full_name: r#"Adaptive Public License 1.0"#,
        index: 23,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "APSL-1.0",
        full_name: r#"Apple Public Source License 1.0"#,
        index: 24,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "APSL-1.1",
        full_name: r#"Apple Public Source License 1.1"#,
        index: 25,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "APSL-1.2",
        full_name: r#"Apple Public Source License 1.2"#,
        index: 26,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "APSL-2.0",
        full_name: r#"Apple Public Source License 2.0"#,
        index: 27,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "ASWF-Digital-Assets-1.0",
        full_name: r#"ASWF Digital Assets License version 1.0"#,
        index: 28,
        flags: 0x0,
    },
    License {
        name: "ASWF-Digital-Assets-1.1",
        full_name: r#"ASWF Digital Assets License 1.1"#,
        index: 29,
        flags: 0x0,
    },
    License {
        name: "Abstyles",
        full_name: r#"Abstyles License"#,
        index: 30,
        flags: 0x0,
    },
    License {
        name: "AdaCore-doc",
        full_name: r#"AdaCore Doc License"#,
        index: 31,
        flags: 0x0,
    },
    License {
        name: "Adobe-2006",
        full_name: r#"Adobe Systems Incorporated Source Code License Agreement"#,
        index: 32,
        flags: 0x0,
    },
    License {
        name: "Adobe-Display-PostScript",
        full_name: r#"Adobe Display PostScript License"#,
        index: 33,
        flags: 0x0,
    },
    License {
        name: "Adobe-Glyph",
        full_name: r#"Adobe Glyph List License"#,
        index: 34,
        flags: 0x0,
    },
    License {
        name: "Adobe-Utopia",
        full_name: r#"Adobe Utopia Font License"#,
        index: 35,
        flags: 0x0,
    },
    License {
        name: "Afmparse",
        full_name: r#"Afmparse License"#,
        index: 36,
        flags: 0x0,
    },
    License {
        name: "Aladdin",
        full_name: r#"Aladdin Free Public License"#,
        index: 37,
        flags: 0x0,
    },
    License {
        name: "Apache-1.0",
        full_name: r#"Apache License 1.0"#,
        index: 38,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Apache-1.1",
        full_name: r#"Apache License 1.1"#,
        index: 39,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Apache-2.0",
        full_name: r#"Apache License 2.0"#,
        index: 40,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "App-s2p",
        full_name: r#"App::s2p License"#,
        index: 41,
        flags: 0x0,
    },
    License {
        name: "Arphic-1999",
        full_name: r#"Arphic Public License"#,
        index: 42,
        flags: 0x0,
    },
    License {
        name: "Artistic-1.0",
        full_name: r#"Artistic License 1.0"#,
        index: 43,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Artistic-1.0-Perl",
        full_name: r#"Artistic License 1.0 (Perl)"#,
        index: 44,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Artistic-1.0-cl8",
        full_name: r#"Artistic License 1.0 w/clause 8"#,
        index: 45,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Artistic-2.0",
        full_name: r#"Artistic License 2.0"#,
        index: 46,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Artistic-dist",
        full_name: r#"Artistic License 1.0 (dist)"#,
        index: 47,
        flags: 0x0,
    },
    License {
        name: "Aspell-RU",
        full_name: r#"Aspell Russian License"#,
        index: 48,
        flags: 0x0,
    },
    License {
        name: "BSD-1-Clause",
        full_name: r#"BSD 1-Clause License"#,
        index: 49,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "BSD-2-Clause",
        full_name: r#"BSD 2-Clause "Simplified" License"#,
        index: 50,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "BSD-2-Clause-Darwin",
        full_name: r#"BSD 2-Clause - Ian Darwin variant"#,
        index: 51,
        flags: 0x0,
    },
    License {
        name: "BSD-2-Clause-FreeBSD",
        full_name: r#"BSD 2-Clause FreeBSD License"#,
        index: 52,
        flags: IS_DEPRECATED | IS_FSF_LIBRE,
    },
    License {
        name: "BSD-2-Clause-NetBSD",
        full_name: r#"BSD 2-Clause NetBSD License"#,
        index: 53,
        flags: IS_DEPRECATED | IS_FSF_LIBRE,
    },
    License {
        name: "BSD-2-Clause-Patent",
        full_name: r#"BSD-2-Clause Plus Patent License"#,
        index: 54,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "BSD-2-Clause-Views",
        full_name: r#"BSD 2-Clause with views sentence"#,
        index: 55,
        flags: 0x0,
    },
    License {
        name: "BSD-2-Clause-first-lines",
        full_name: r#"BSD 2-Clause - first lines requirement"#,
        index: 56,
        flags: 0x0,
    },
    License {
        name: "BSD-2-Clause-pkgconf-disclaimer",
        full_name: r#"BSD 2-Clause pkgconf disclaimer variant"#,
        index: 57,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause",
        full_name: r#"BSD 3-Clause "New" or "Revised" License"#,
        index: 58,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "BSD-3-Clause-Attribution",
        full_name: r#"BSD with attribution"#,
        index: 59,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-Clear",
        full_name: r#"BSD 3-Clause Clear License"#,
        index: 60,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "BSD-3-Clause-HP",
        full_name: r#"Hewlett-Packard BSD variant license"#,
        index: 61,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-LBNL",
        full_name: r#"Lawrence Berkeley National Labs BSD variant license"#,
        index: 62,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "BSD-3-Clause-Modification",
        full_name: r#"BSD 3-Clause Modification"#,
        index: 63,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-No-Military-License",
        full_name: r#"BSD 3-Clause No Military License"#,
        index: 64,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-No-Nuclear-License",
        full_name: r#"BSD 3-Clause No Nuclear License"#,
        index: 65,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-No-Nuclear-License-2014",
        full_name: r#"BSD 3-Clause No Nuclear License 2014"#,
        index: 66,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-No-Nuclear-Warranty",
        full_name: r#"BSD 3-Clause No Nuclear Warranty"#,
        index: 67,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-Open-MPI",
        full_name: r#"BSD 3-Clause Open MPI variant"#,
        index: 68,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-Sun",
        full_name: r#"BSD 3-Clause Sun Microsystems"#,
        index: 69,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-acpica",
        full_name: r#"BSD 3-Clause acpica variant"#,
        index: 70,
        flags: 0x0,
    },
    License {
        name: "BSD-3-Clause-flex",
        full_name: r#"BSD 3-Clause Flex variant"#,
        index: 71,
        flags: 0x0,
    },
    License {
        name: "BSD-4-Clause",
        full_name: r#"BSD 4-Clause "Original" or "Old" License"#,
        index: 72,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "BSD-4-Clause-Shortened",
        full_name: r#"BSD 4 Clause Shortened"#,
        index: 73,
        flags: 0x0,
    },
    License {
        name: "BSD-4-Clause-UC",
        full_name: r#"BSD-4-Clause (University of California-Specific)"#,
        index: 74,
        flags: 0x0,
    },
    License {
        name: "BSD-4.3RENO",
        full_name: r#"BSD 4.3 RENO License"#,
        index: 75,
        flags: 0x0,
    },
    License {
        name: "BSD-4.3TAHOE",
        full_name: r#"BSD 4.3 TAHOE License"#,
        index: 76,
        flags: 0x0,
    },
    License {
        name: "BSD-Advertising-Acknowledgement",
        full_name: r#"BSD Advertising Acknowledgement License"#,
        index: 77,
        flags: 0x0,
    },
    License {
        name: "BSD-Attribution-HPND-disclaimer",
        full_name: r#"BSD with Attribution and HPND disclaimer"#,
        index: 78,
        flags: 0x0,
    },
    License {
        name: "BSD-Inferno-Nettverk",
        full_name: r#"BSD-Inferno-Nettverk"#,
        index: 79,
        flags: 0x0,
    },
    License {
        name: "BSD-Protection",
        full_name: r#"BSD Protection License"#,
        index: 80,
        flags: IS_COPYLEFT,
    },
    License {
        name: "BSD-Source-Code",
        full_name: r#"BSD Source Code Attribution"#,
        index: 81,
        flags: 0x0,
    },
    License {
        name: "BSD-Source-beginning-file",
        full_name: r#"BSD Source Code Attribution - beginning of file variant"#,
        index: 82,
        flags: 0x0,
    },
    License {
        name: "BSD-Systemics",
        full_name: r#"Systemics BSD variant license"#,
        index: 83,
        flags: 0x0,
    },
    License {
        name: "BSD-Systemics-W3Works",
        full_name: r#"Systemics W3Works BSD variant license"#,
        index: 84,
        flags: 0x0,
    },
    License {
        name: "BSL-1.0",
        full_name: r#"Boost Software License 1.0"#,
        index: 85,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "BUSL-1.1",
        full_name: r#"Business Source License 1.1"#,
        index: 86,
        flags: 0x0,
    },
    License {
        name: "Baekmuk",
        full_name: r#"Baekmuk License"#,
        index: 87,
        flags: 0x0,
    },
    License {
        name: "Bahyph",
        full_name: r#"Bahyph License"#,
        index: 88,
        flags: 0x0,
    },
    License {
        name: "Barr",
        full_name: r#"Barr License"#,
        index: 89,
        flags: 0x0,
    },
    License {
        name: "Beerware",
        full_name: r#"Beerware License"#,
        index: 90,
        flags: 0x0,
    },
    License {
        name: "BitTorrent-1.0",
        full_name: r#"BitTorrent Open Source License v1.0"#,
        index: 91,
        flags: 0x0,
    },
    License {
        name: "BitTorrent-1.1",
        full_name: r#"BitTorrent Open Source License v1.1"#,
        index: 92,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Bitstream-Charter",
        full_name: r#"Bitstream Charter Font License"#,
        index: 93,
        flags: 0x0,
    },
    License {
        name: "Bitstream-Vera",
        full_name: r#"Bitstream Vera Font License"#,
        index: 94,
        flags: 0x0,
    },
    License {
        name: "BlueOak-1.0.0",
        full_name: r#"Blue Oak Model License 1.0.0"#,
        index: 95,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Boehm-GC",
        full_name: r#"Boehm-Demers-Weiser GC License"#,
        index: 96,
        flags: 0x0,
    },
    License {
        name: "Boehm-GC-without-fee",
        full_name: r#"Boehm-Demers-Weiser GC License (without fee)"#,
        index: 97,
        flags: 0x0,
    },
    License {
        name: "Borceux",
        full_name: r#"Borceux license"#,
        index: 98,
        flags: 0x0,
    },
    License {
        name: "Brian-Gladman-2-Clause",
        full_name: r#"Brian Gladman 2-Clause License"#,
        index: 99,
        flags: 0x0,
    },
    License {
        name: "Brian-Gladman-3-Clause",
        full_name: r#"Brian Gladman 3-Clause License"#,
        index: 100,
        flags: 0x0,
    },
    License {
        name: "C-UDA-1.0",
        full_name: r#"Computational Use of Data Agreement v1.0"#,
        index: 101,
        flags: 0x0,
    },
    License {
        name: "CAL-1.0",
        full_name: r#"Cryptographic Autonomy License 1.0"#,
        index: 102,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "CAL-1.0-Combined-Work-Exception",
        full_name: r#"Cryptographic Autonomy License 1.0 (Combined Work Exception)"#,
        index: 103,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "CATOSL-1.1",
        full_name: r#"Computer Associates Trusted Open Source License 1.1"#,
        index: 104,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "CC-BY-1.0",
        full_name: r#"Creative Commons Attribution 1.0 Generic"#,
        index: 105,
        flags: 0x0,
    },
    License {
        name: "CC-BY-2.0",
        full_name: r#"Creative Commons Attribution 2.0 Generic"#,
        index: 106,
        flags: 0x0,
    },
    License {
        name: "CC-BY-2.5",
        full_name: r#"Creative Commons Attribution 2.5 Generic"#,
        index: 107,
        flags: 0x0,
    },
    License {
        name: "CC-BY-2.5-AU",
        full_name: r#"Creative Commons Attribution 2.5 Australia"#,
        index: 108,
        flags: 0x0,
    },
    License {
        name: "CC-BY-3.0",
        full_name: r#"Creative Commons Attribution 3.0 Unported"#,
        index: 109,
        flags: 0x0,
    },
    License {
        name: "CC-BY-3.0-AT",
        full_name: r#"Creative Commons Attribution 3.0 Austria"#,
        index: 110,
        flags: 0x0,
    },
    License {
        name: "CC-BY-3.0-AU",
        full_name: r#"Creative Commons Attribution 3.0 Australia"#,
        index: 111,
        flags: 0x0,
    },
    License {
        name: "CC-BY-3.0-DE",
        full_name: r#"Creative Commons Attribution 3.0 Germany"#,
        index: 112,
        flags: 0x0,
    },
    License {
        name: "CC-BY-3.0-IGO",
        full_name: r#"Creative Commons Attribution 3.0 IGO"#,
        index: 113,
        flags: 0x0,
    },
    License {
        name: "CC-BY-3.0-NL",
        full_name: r#"Creative Commons Attribution 3.0 Netherlands"#,
        index: 114,
        flags: 0x0,
    },
    License {
        name: "CC-BY-3.0-US",
        full_name: r#"Creative Commons Attribution 3.0 United States"#,
        index: 115,
        flags: 0x0,
    },
    License {
        name: "CC-BY-4.0",
        full_name: r#"Creative Commons Attribution 4.0 International"#,
        index: 116,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "CC-BY-NC-1.0",
        full_name: r#"Creative Commons Attribution Non Commercial 1.0 Generic"#,
        index: 117,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-2.0",
        full_name: r#"Creative Commons Attribution Non Commercial 2.0 Generic"#,
        index: 118,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-2.5",
        full_name: r#"Creative Commons Attribution Non Commercial 2.5 Generic"#,
        index: 119,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-3.0",
        full_name: r#"Creative Commons Attribution Non Commercial 3.0 Unported"#,
        index: 120,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-3.0-DE",
        full_name: r#"Creative Commons Attribution Non Commercial 3.0 Germany"#,
        index: 121,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-4.0",
        full_name: r#"Creative Commons Attribution Non Commercial 4.0 International"#,
        index: 122,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-ND-1.0",
        full_name: r#"Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic"#,
        index: 123,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-ND-2.0",
        full_name: r#"Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic"#,
        index: 124,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-ND-2.5",
        full_name: r#"Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic"#,
        index: 125,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-ND-3.0",
        full_name: r#"Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported"#,
        index: 126,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-ND-3.0-DE",
        full_name: r#"Creative Commons Attribution Non Commercial No Derivatives 3.0 Germany"#,
        index: 127,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-ND-3.0-IGO",
        full_name: r#"Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO"#,
        index: 128,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-ND-4.0",
        full_name: r#"Creative Commons Attribution Non Commercial No Derivatives 4.0 International"#,
        index: 129,
        flags: 0x0,
    },
    License {
        name: "CC-BY-NC-SA-1.0",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 1.0 Generic"#,
        index: 130,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-2.0",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 2.0 Generic"#,
        index: 131,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-2.0-DE",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 2.0 Germany"#,
        index: 132,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-2.0-FR",
        full_name: r#"Creative Commons Attribution-NonCommercial-ShareAlike 2.0 France"#,
        index: 133,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-2.0-UK",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 2.0 England and Wales"#,
        index: 134,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-2.5",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 2.5 Generic"#,
        index: 135,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-3.0",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 3.0 Unported"#,
        index: 136,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-3.0-DE",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 3.0 Germany"#,
        index: 137,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-3.0-IGO",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 3.0 IGO"#,
        index: 138,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-NC-SA-4.0",
        full_name: r#"Creative Commons Attribution Non Commercial Share Alike 4.0 International"#,
        index: 139,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-ND-1.0",
        full_name: r#"Creative Commons Attribution No Derivatives 1.0 Generic"#,
        index: 140,
        flags: 0x0,
    },
    License {
        name: "CC-BY-ND-2.0",
        full_name: r#"Creative Commons Attribution No Derivatives 2.0 Generic"#,
        index: 141,
        flags: 0x0,
    },
    License {
        name: "CC-BY-ND-2.5",
        full_name: r#"Creative Commons Attribution No Derivatives 2.5 Generic"#,
        index: 142,
        flags: 0x0,
    },
    License {
        name: "CC-BY-ND-3.0",
        full_name: r#"Creative Commons Attribution No Derivatives 3.0 Unported"#,
        index: 143,
        flags: 0x0,
    },
    License {
        name: "CC-BY-ND-3.0-DE",
        full_name: r#"Creative Commons Attribution No Derivatives 3.0 Germany"#,
        index: 144,
        flags: 0x0,
    },
    License {
        name: "CC-BY-ND-4.0",
        full_name: r#"Creative Commons Attribution No Derivatives 4.0 International"#,
        index: 145,
        flags: 0x0,
    },
    License {
        name: "CC-BY-SA-1.0",
        full_name: r#"Creative Commons Attribution Share Alike 1.0 Generic"#,
        index: 146,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-2.0",
        full_name: r#"Creative Commons Attribution Share Alike 2.0 Generic"#,
        index: 147,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-2.0-UK",
        full_name: r#"Creative Commons Attribution Share Alike 2.0 England and Wales"#,
        index: 148,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-2.1-JP",
        full_name: r#"Creative Commons Attribution Share Alike 2.1 Japan"#,
        index: 149,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-2.5",
        full_name: r#"Creative Commons Attribution Share Alike 2.5 Generic"#,
        index: 150,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-3.0",
        full_name: r#"Creative Commons Attribution Share Alike 3.0 Unported"#,
        index: 151,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-3.0-AT",
        full_name: r#"Creative Commons Attribution Share Alike 3.0 Austria"#,
        index: 152,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-3.0-DE",
        full_name: r#"Creative Commons Attribution Share Alike 3.0 Germany"#,
        index: 153,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-3.0-IGO",
        full_name: r#"Creative Commons Attribution-ShareAlike 3.0 IGO"#,
        index: 154,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CC-BY-SA-4.0",
        full_name: r#"Creative Commons Attribution Share Alike 4.0 International"#,
        index: 155,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "CC-PDDC",
        full_name: r#"Creative Commons Public Domain Dedication and Certification"#,
        index: 156,
        flags: 0x0,
    },
    License {
        name: "CC-PDM-1.0",
        full_name: r#"Creative    Commons Public Domain Mark 1.0 Universal"#,
        index: 157,
        flags: 0x0,
    },
    License {
        name: "CC-SA-1.0",
        full_name: r#"Creative Commons Share Alike 1.0 Generic"#,
        index: 158,
        flags: 0x0,
    },
    License {
        name: "CC0-1.0",
        full_name: r#"Creative Commons Zero v1.0 Universal"#,
        index: 159,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "CDDL-1.0",
        full_name: r#"Common Development and Distribution License 1.0"#,
        index: 160,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "CDDL-1.1",
        full_name: r#"Common Development and Distribution License 1.1"#,
        index: 161,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CDL-1.0",
        full_name: r#"Common Documentation License 1.0"#,
        index: 162,
        flags: 0x0,
    },
    License {
        name: "CDLA-Permissive-1.0",
        full_name: r#"Community Data License Agreement Permissive 1.0"#,
        index: 163,
        flags: 0x0,
    },
    License {
        name: "CDLA-Permissive-2.0",
        full_name: r#"Community Data License Agreement Permissive 2.0"#,
        index: 164,
        flags: 0x0,
    },
    License {
        name: "CDLA-Sharing-1.0",
        full_name: r#"Community Data License Agreement Sharing 1.0"#,
        index: 165,
        flags: 0x0,
    },
    License {
        name: "CECILL-1.0",
        full_name: r#"CeCILL Free Software License Agreement v1.0"#,
        index: 166,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CECILL-1.1",
        full_name: r#"CeCILL Free Software License Agreement v1.1"#,
        index: 167,
        flags: IS_COPYLEFT,
    },
    License {
        name: "CECILL-2.0",
        full_name: r#"CeCILL Free Software License Agreement v2.0"#,
        index: 168,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "CECILL-2.1",
        full_name: r#"CeCILL Free Software License Agreement v2.1"#,
        index: 169,
        flags: IS_OSI_APPROVED | IS_COPYLEFT,
    },
    License {
        name: "CECILL-B",
        full_name: r#"CeCILL-B Free Software License Agreement"#,
        index: 170,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "CECILL-C",
        full_name: r#"CeCILL-C Free Software License Agreement"#,
        index: 171,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "CERN-OHL-1.1",
        full_name: r#"CERN Open Hardware Licence v1.1"#,
        index: 172,
        flags: 0x0,
    },
    License {
        name: "CERN-OHL-1.2",
        full_name: r#"CERN Open Hardware Licence v1.2"#,
        index: 173,
        flags: 0x0,
    },
    License {
        name: "CERN-OHL-P-2.0",
        full_name: r#"CERN Open Hardware Licence Version 2 - Permissive"#,
        index: 174,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "CERN-OHL-S-2.0",
        full_name: r#"CERN Open Hardware Licence Version 2 - Strongly Reciprocal"#,
        index: 175,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "CERN-OHL-W-2.0",
        full_name: r#"CERN Open Hardware Licence Version 2 - Weakly Reciprocal"#,
        index: 176,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "CFITSIO",
        full_name: r#"CFITSIO License"#,
        index: 177,
        flags: 0x0,
    },
    License {
        name: "CMU-Mach",
        full_name: r#"CMU Mach License"#,
        index: 178,
        flags: 0x0,
    },
    License {
        name: "CMU-Mach-nodoc",
        full_name: r#"CMU    Mach - no notices-in-documentation variant"#,
        index: 179,
        flags: 0x0,
    },
    License {
        name: "CNRI-Jython",
        full_name: r#"CNRI Jython License"#,
        index: 180,
        flags: 0x0,
    },
    License {
        name: "CNRI-Python",
        full_name: r#"CNRI Python License"#,
        index: 181,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "CNRI-Python-GPL-Compatible",
        full_name: r#"CNRI Python Open Source GPL Compatible License Agreement"#,
        index: 182,
        flags: 0x0,
    },
    License {
        name: "COIL-1.0",
        full_name: r#"Copyfree Open Innovation License"#,
        index: 183,
        flags: 0x0,
    },
    License {
        name: "CPAL-1.0",
        full_name: r#"Common Public Attribution License 1.0"#,
        index: 184,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "CPL-1.0",
        full_name: r#"Common Public License 1.0"#,
        index: 185,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "CPOL-1.02",
        full_name: r#"Code Project Open License 1.02"#,
        index: 186,
        flags: 0x0,
    },
    License {
        name: "CUA-OPL-1.0",
        full_name: r#"CUA Office Public License v1.0"#,
        index: 187,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Caldera",
        full_name: r#"Caldera License"#,
        index: 188,
        flags: 0x0,
    },
    License {
        name: "Caldera-no-preamble",
        full_name: r#"Caldera License (without preamble)"#,
        index: 189,
        flags: 0x0,
    },
    License {
        name: "Catharon",
        full_name: r#"Catharon License"#,
        index: 190,
        flags: 0x0,
    },
    License {
        name: "ClArtistic",
        full_name: r#"Clarified Artistic License"#,
        index: 191,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Clips",
        full_name: r#"Clips License"#,
        index: 192,
        flags: 0x0,
    },
    License {
        name: "Community-Spec-1.0",
        full_name: r#"Community Specification License 1.0"#,
        index: 193,
        flags: 0x0,
    },
    License {
        name: "Condor-1.1",
        full_name: r#"Condor Public License v1.1"#,
        index: 194,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Cornell-Lossless-JPEG",
        full_name: r#"Cornell Lossless JPEG License"#,
        index: 195,
        flags: 0x0,
    },
    License {
        name: "Cronyx",
        full_name: r#"Cronyx License"#,
        index: 196,
        flags: 0x0,
    },
    License {
        name: "Crossword",
        full_name: r#"Crossword License"#,
        index: 197,
        flags: 0x0,
    },
    License {
        name: "CryptoSwift",
        full_name: r#"CryptoSwift License"#,
        index: 198,
        flags: 0x0,
    },
    License {
        name: "CrystalStacker",
        full_name: r#"CrystalStacker License"#,
        index: 199,
        flags: 0x0,
    },
    License {
        name: "Cube",
        full_name: r#"Cube License"#,
        index: 200,
        flags: 0x0,
    },
    License {
        name: "D-FSL-1.0",
        full_name: r#"Deutsche Freie Software Lizenz"#,
        index: 201,
        flags: 0x0,
    },
    License {
        name: "DEC-3-Clause",
        full_name: r#"DEC 3-Clause License"#,
        index: 202,
        flags: 0x0,
    },
    License {
        name: "DL-DE-BY-2.0",
        full_name: r#"Data licence Germany – attribution – version 2.0"#,
        index: 203,
        flags: 0x0,
    },
    License {
        name: "DL-DE-ZERO-2.0",
        full_name: r#"Data licence Germany – zero – version 2.0"#,
        index: 204,
        flags: 0x0,
    },
    License {
        name: "DOC",
        full_name: r#"DOC License"#,
        index: 205,
        flags: 0x0,
    },
    License {
        name: "DRL-1.0",
        full_name: r#"Detection Rule License 1.0"#,
        index: 206,
        flags: 0x0,
    },
    License {
        name: "DRL-1.1",
        full_name: r#"Detection Rule License 1.1"#,
        index: 207,
        flags: 0x0,
    },
    License {
        name: "DSDP",
        full_name: r#"DSDP License"#,
        index: 208,
        flags: 0x0,
    },
    License {
        name: "DocBook-DTD",
        full_name: r#"DocBook DTD License"#,
        index: 209,
        flags: 0x0,
    },
    License {
        name: "DocBook-Schema",
        full_name: r#"DocBook Schema License"#,
        index: 210,
        flags: 0x0,
    },
    License {
        name: "DocBook-Stylesheet",
        full_name: r#"DocBook Stylesheet License"#,
        index: 211,
        flags: 0x0,
    },
    License {
        name: "DocBook-XML",
        full_name: r#"DocBook XML License"#,
        index: 212,
        flags: 0x0,
    },
    License {
        name: "Dotseqn",
        full_name: r#"Dotseqn License"#,
        index: 213,
        flags: 0x0,
    },
    License {
        name: "ECL-1.0",
        full_name: r#"Educational Community License v1.0"#,
        index: 214,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "ECL-2.0",
        full_name: r#"Educational Community License v2.0"#,
        index: 215,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "EFL-1.0",
        full_name: r#"Eiffel Forum License v1.0"#,
        index: 216,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "EFL-2.0",
        full_name: r#"Eiffel Forum License v2.0"#,
        index: 217,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "EPICS",
        full_name: r#"EPICS Open License"#,
        index: 218,
        flags: 0x0,
    },
    License {
        name: "EPL-1.0",
        full_name: r#"Eclipse Public License 1.0"#,
        index: 219,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "EPL-2.0",
        full_name: r#"Eclipse Public License 2.0"#,
        index: 220,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "EUDatagrid",
        full_name: r#"EU DataGrid Software License"#,
        index: 221,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "EUPL-1.0",
        full_name: r#"European Union Public License 1.0"#,
        index: 222,
        flags: IS_COPYLEFT,
    },
    License {
        name: "EUPL-1.1",
        full_name: r#"European Union Public License 1.1"#,
        index: 223,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "EUPL-1.2",
        full_name: r#"European Union Public License 1.2"#,
        index: 224,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "Elastic-2.0",
        full_name: r#"Elastic License 2.0"#,
        index: 225,
        flags: 0x0,
    },
    License {
        name: "Entessa",
        full_name: r#"Entessa Public License v1.0"#,
        index: 226,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "ErlPL-1.1",
        full_name: r#"Erlang Public License v1.1"#,
        index: 227,
        flags: 0x0,
    },
    License {
        name: "Eurosym",
        full_name: r#"Eurosym License"#,
        index: 228,
        flags: 0x0,
    },
    License {
        name: "FBM",
        full_name: r#"Fuzzy Bitmap License"#,
        index: 229,
        flags: 0x0,
    },
    License {
        name: "FDK-AAC",
        full_name: r#"Fraunhofer FDK AAC Codec Library"#,
        index: 230,
        flags: 0x0,
    },
    License {
        name: "FSFAP",
        full_name: r#"FSF All Permissive License"#,
        index: 231,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "FSFAP-no-warranty-disclaimer",
        full_name: r#"FSF All Permissive License (without Warranty)"#,
        index: 232,
        flags: 0x0,
    },
    License {
        name: "FSFUL",
        full_name: r#"FSF Unlimited License"#,
        index: 233,
        flags: 0x0,
    },
    License {
        name: "FSFULLR",
        full_name: r#"FSF Unlimited License (with License Retention)"#,
        index: 234,
        flags: 0x0,
    },
    License {
        name: "FSFULLRSD",
        full_name: r#"FSF Unlimited License (with License Retention and Short Disclaimer)"#,
        index: 235,
        flags: 0x0,
    },
    License {
        name: "FSFULLRWD",
        full_name: r#"FSF Unlimited License (With License Retention and Warranty Disclaimer)"#,
        index: 236,
        flags: 0x0,
    },
    License {
        name: "FSL-1.1-ALv2",
        full_name: r#"Functional Source License, Version 1.1, ALv2 Future License"#,
        index: 237,
        flags: 0x0,
    },
    License {
        name: "FSL-1.1-MIT",
        full_name: r#"Functional Source License, Version 1.1, MIT Future License"#,
        index: 238,
        flags: 0x0,
    },
    License {
        name: "FTL",
        full_name: r#"Freetype Project License"#,
        index: 239,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Fair",
        full_name: r#"Fair License"#,
        index: 240,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Ferguson-Twofish",
        full_name: r#"Ferguson Twofish License"#,
        index: 241,
        flags: 0x0,
    },
    License {
        name: "Frameworx-1.0",
        full_name: r#"Frameworx Open License 1.0"#,
        index: 242,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "FreeBSD-DOC",
        full_name: r#"FreeBSD Documentation License"#,
        index: 243,
        flags: 0x0,
    },
    License {
        name: "FreeImage",
        full_name: r#"FreeImage Public License v1.0"#,
        index: 244,
        flags: 0x0,
    },
    License {
        name: "Furuseth",
        full_name: r#"Furuseth License"#,
        index: 245,
        flags: 0x0,
    },
    License {
        name: "GCR-docs",
        full_name: r#"Gnome GCR Documentation License"#,
        index: 246,
        flags: 0x0,
    },
    License {
        name: "GD",
        full_name: r#"GD License"#,
        index: 247,
        flags: 0x0,
    },
    License {
        name: "GFDL-1.1",
        full_name: r#"GNU Free Documentation License v1.1"#,
        index: 248,
        flags: IS_DEPRECATED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-invariants",
        full_name: r#"GNU Free Documentation License v1.1 only - invariants"#,
        index: 249,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-invariants-only",
        full_name: r#"GNU Free Documentation License v1.1 only - invariants"#,
        index: 250,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-invariants-or-later",
        full_name: r#"GNU Free Documentation License v1.1 or later - invariants"#,
        index: 251,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-no-invariants",
        full_name: r#"GNU Free Documentation License v1.1 only - no invariants"#,
        index: 252,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-no-invariants-only",
        full_name: r#"GNU Free Documentation License v1.1 only - no invariants"#,
        index: 253,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-no-invariants-or-later",
        full_name: r#"GNU Free Documentation License v1.1 or later - no invariants"#,
        index: 254,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-only",
        full_name: r#"GNU Free Documentation License v1.1 only"#,
        index: 255,
        flags: IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.1-or-later",
        full_name: r#"GNU Free Documentation License v1.1 or later"#,
        index: 256,
        flags: IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2",
        full_name: r#"GNU Free Documentation License v1.2"#,
        index: 257,
        flags: IS_DEPRECATED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-invariants",
        full_name: r#"GNU Free Documentation License v1.2 only - invariants"#,
        index: 258,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-invariants-only",
        full_name: r#"GNU Free Documentation License v1.2 only - invariants"#,
        index: 259,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-invariants-or-later",
        full_name: r#"GNU Free Documentation License v1.2 or later - invariants"#,
        index: 260,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-no-invariants",
        full_name: r#"GNU Free Documentation License v1.2 only - no invariants"#,
        index: 261,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-no-invariants-only",
        full_name: r#"GNU Free Documentation License v1.2 only - no invariants"#,
        index: 262,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-no-invariants-or-later",
        full_name: r#"GNU Free Documentation License v1.2 or later - no invariants"#,
        index: 263,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-only",
        full_name: r#"GNU Free Documentation License v1.2 only"#,
        index: 264,
        flags: IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.2-or-later",
        full_name: r#"GNU Free Documentation License v1.2 or later"#,
        index: 265,
        flags: IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3",
        full_name: r#"GNU Free Documentation License v1.3"#,
        index: 266,
        flags: IS_DEPRECATED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-invariants",
        full_name: r#"GNU Free Documentation License v1.3 only - invariants"#,
        index: 267,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-invariants-only",
        full_name: r#"GNU Free Documentation License v1.3 only - invariants"#,
        index: 268,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-invariants-or-later",
        full_name: r#"GNU Free Documentation License v1.3 or later - invariants"#,
        index: 269,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-no-invariants",
        full_name: r#"GNU Free Documentation License v1.3 only - no invariants"#,
        index: 270,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-no-invariants-only",
        full_name: r#"GNU Free Documentation License v1.3 only - no invariants"#,
        index: 271,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-no-invariants-or-later",
        full_name: r#"GNU Free Documentation License v1.3 or later - no invariants"#,
        index: 272,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-only",
        full_name: r#"GNU Free Documentation License v1.3 only"#,
        index: 273,
        flags: IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GFDL-1.3-or-later",
        full_name: r#"GNU Free Documentation License v1.3 or later"#,
        index: 274,
        flags: IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GL2PS",
        full_name: r#"GL2PS License"#,
        index: 275,
        flags: 0x0,
    },
    License {
        name: "GLWTPL",
        full_name: r#"Good Luck With That Public License"#,
        index: 276,
        flags: 0x0,
    },
    License {
        name: "GPL-1.0",
        full_name: r#"GNU General Public License v1.0 only"#,
        index: 277,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-1.0+",
        full_name: r#"GNU General Public License v1.0 or later"#,
        index: 278,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-1.0-only",
        full_name: r#"GNU General Public License v1.0 only"#,
        index: 279,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-1.0-or-later",
        full_name: r#"GNU General Public License v1.0 or later"#,
        index: 280,
        flags: IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0",
        full_name: r#"GNU General Public License v2.0 only"#,
        index: 281,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0+",
        full_name: r#"GNU General Public License v2.0 or later"#,
        index: 282,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0-only",
        full_name: r#"GNU General Public License v2.0 only"#,
        index: 283,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0-or-later",
        full_name: r#"GNU General Public License v2.0 or later"#,
        index: 284,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0-with-GCC-exception",
        full_name: r#"GNU General Public License v2.0 w/GCC Runtime Library exception"#,
        index: 285,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0-with-autoconf-exception",
        full_name: r#"GNU General Public License v2.0 w/Autoconf exception"#,
        index: 286,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0-with-bison-exception",
        full_name: r#"GNU General Public License v2.0 w/Bison exception"#,
        index: 287,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0-with-classpath-exception",
        full_name: r#"GNU General Public License v2.0 w/Classpath exception"#,
        index: 288,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-2.0-with-font-exception",
        full_name: r#"GNU General Public License v2.0 w/Font exception"#,
        index: 289,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-3.0",
        full_name: r#"GNU General Public License v3.0 only"#,
        index: 290,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-3.0+",
        full_name: r#"GNU General Public License v3.0 or later"#,
        index: 291,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-3.0-only",
        full_name: r#"GNU General Public License v3.0 only"#,
        index: 292,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-3.0-or-later",
        full_name: r#"GNU General Public License v3.0 or later"#,
        index: 293,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-3.0-with-GCC-exception",
        full_name: r#"GNU General Public License v3.0 w/GCC Runtime Library exception"#,
        index: 294,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "GPL-3.0-with-autoconf-exception",
        full_name: r#"GNU General Public License v3.0 w/Autoconf exception"#,
        index: 295,
        flags: IS_DEPRECATED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "Game-Programming-Gems",
        full_name: r#"Game Programming Gems License"#,
        index: 296,
        flags: 0x0,
    },
    License {
        name: "Giftware",
        full_name: r#"Giftware License"#,
        index: 297,
        flags: 0x0,
    },
    License {
        name: "Glide",
        full_name: r#"3dfx Glide License"#,
        index: 298,
        flags: 0x0,
    },
    License {
        name: "Glulxe",
        full_name: r#"Glulxe License"#,
        index: 299,
        flags: 0x0,
    },
    License {
        name: "Graphics-Gems",
        full_name: r#"Graphics Gems License"#,
        index: 300,
        flags: 0x0,
    },
    License {
        name: "Gutmann",
        full_name: r#"Gutmann License"#,
        index: 301,
        flags: 0x0,
    },
    License {
        name: "HDF5",
        full_name: r#"HDF5 License"#,
        index: 302,
        flags: 0x0,
    },
    License {
        name: "HIDAPI",
        full_name: r#"HIDAPI License"#,
        index: 303,
        flags: 0x0,
    },
    License {
        name: "HP-1986",
        full_name: r#"Hewlett-Packard 1986 License"#,
        index: 304,
        flags: 0x0,
    },
    License {
        name: "HP-1989",
        full_name: r#"Hewlett-Packard 1989 License"#,
        index: 305,
        flags: 0x0,
    },
    License {
        name: "HPND",
        full_name: r#"Historical Permission Notice and Disclaimer"#,
        index: 306,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "HPND-DEC",
        full_name: r#"Historical Permission Notice and Disclaimer - DEC variant"#,
        index: 307,
        flags: 0x0,
    },
    License {
        name: "HPND-Fenneberg-Livingston",
        full_name: r#"Historical Permission Notice and Disclaimer - Fenneberg-Livingston variant"#,
        index: 308,
        flags: 0x0,
    },
    License {
        name: "HPND-INRIA-IMAG",
        full_name: r#"Historical Permission Notice and Disclaimer    - INRIA-IMAG variant"#,
        index: 309,
        flags: 0x0,
    },
    License {
        name: "HPND-Intel",
        full_name: r#"Historical Permission Notice and Disclaimer - Intel variant"#,
        index: 310,
        flags: 0x0,
    },
    License {
        name: "HPND-Kevlin-Henney",
        full_name: r#"Historical Permission Notice and Disclaimer - Kevlin Henney variant"#,
        index: 311,
        flags: 0x0,
    },
    License {
        name: "HPND-MIT-disclaimer",
        full_name: r#"Historical Permission Notice and Disclaimer with MIT disclaimer"#,
        index: 312,
        flags: 0x0,
    },
    License {
        name: "HPND-Markus-Kuhn",
        full_name: r#"Historical Permission Notice and Disclaimer - Markus Kuhn variant"#,
        index: 313,
        flags: 0x0,
    },
    License {
        name: "HPND-Netrek",
        full_name: r#"Historical Permission Notice and Disclaimer - Netrek variant"#,
        index: 314,
        flags: 0x0,
    },
    License {
        name: "HPND-Pbmplus",
        full_name: r#"Historical Permission Notice and Disclaimer - Pbmplus variant"#,
        index: 315,
        flags: 0x0,
    },
    License {
        name: "HPND-UC",
        full_name: r#"Historical Permission Notice and Disclaimer - University of California variant"#,
        index: 316,
        flags: 0x0,
    },
    License {
        name: "HPND-UC-export-US",
        full_name: r#"Historical Permission Notice and Disclaimer - University of California, US export warning"#,
        index: 317,
        flags: 0x0,
    },
    License {
        name: "HPND-doc",
        full_name: r#"Historical Permission Notice and Disclaimer - documentation variant"#,
        index: 318,
        flags: 0x0,
    },
    License {
        name: "HPND-doc-sell",
        full_name: r#"Historical Permission Notice and Disclaimer - documentation sell variant"#,
        index: 319,
        flags: 0x0,
    },
    License {
        name: "HPND-export-US",
        full_name: r#"HPND with US Government export control warning"#,
        index: 320,
        flags: 0x0,
    },
    License {
        name: "HPND-export-US-acknowledgement",
        full_name: r#"HPND with US Government export control warning and acknowledgment"#,
        index: 321,
        flags: 0x0,
    },
    License {
        name: "HPND-export-US-modify",
        full_name: r#"HPND with US Government export control warning and modification rqmt"#,
        index: 322,
        flags: 0x0,
    },
    License {
        name: "HPND-export2-US",
        full_name: r#"HPND with US Government export control and 2 disclaimers"#,
        index: 323,
        flags: 0x0,
    },
    License {
        name: "HPND-merchantability-variant",
        full_name: r#"Historical Permission Notice and Disclaimer - merchantability variant"#,
        index: 324,
        flags: 0x0,
    },
    License {
        name: "HPND-sell-MIT-disclaimer-xserver",
        full_name: r#"Historical Permission Notice and Disclaimer - sell xserver variant with MIT disclaimer"#,
        index: 325,
        flags: 0x0,
    },
    License {
        name: "HPND-sell-regexpr",
        full_name: r#"Historical Permission Notice and Disclaimer - sell regexpr variant"#,
        index: 326,
        flags: 0x0,
    },
    License {
        name: "HPND-sell-variant",
        full_name: r#"Historical Permission Notice and Disclaimer - sell variant"#,
        index: 327,
        flags: 0x0,
    },
    License {
        name: "HPND-sell-variant-MIT-disclaimer",
        full_name: r#"HPND sell variant with MIT disclaimer"#,
        index: 328,
        flags: 0x0,
    },
    License {
        name: "HPND-sell-variant-MIT-disclaimer-rev",
        full_name: r#"HPND sell variant with MIT disclaimer - reverse"#,
        index: 329,
        flags: 0x0,
    },
    License {
        name: "HTMLTIDY",
        full_name: r#"HTML Tidy License"#,
        index: 330,
        flags: 0x0,
    },
    License {
        name: "HaskellReport",
        full_name: r#"Haskell Language Report License"#,
        index: 331,
        flags: 0x0,
    },
    License {
        name: "Hippocratic-2.1",
        full_name: r#"Hippocratic License 2.1"#,
        index: 332,
        flags: 0x0,
    },
    License {
        name: "IBM-pibs",
        full_name: r#"IBM PowerPC Initialization and Boot Software"#,
        index: 333,
        flags: 0x0,
    },
    License {
        name: "ICU",
        full_name: r#"ICU License"#,
        index: 334,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "IEC-Code-Components-EULA",
        full_name: r#"IEC    Code Components End-user licence agreement"#,
        index: 335,
        flags: 0x0,
    },
    License {
        name: "IJG",
        full_name: r#"Independent JPEG Group License"#,
        index: 336,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "IJG-short",
        full_name: r#"Independent JPEG Group License - short"#,
        index: 337,
        flags: 0x0,
    },
    License {
        name: "IPA",
        full_name: r#"IPA Font License"#,
        index: 338,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "IPL-1.0",
        full_name: r#"IBM Public License v1.0"#,
        index: 339,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "ISC",
        full_name: r#"ISC License"#,
        index: 340,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "ISC-Veillard",
        full_name: r#"ISC Veillard variant"#,
        index: 341,
        flags: 0x0,
    },
    License {
        name: "ImageMagick",
        full_name: r#"ImageMagick License"#,
        index: 342,
        flags: 0x0,
    },
    License {
        name: "Imlib2",
        full_name: r#"Imlib2 License"#,
        index: 343,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Info-ZIP",
        full_name: r#"Info-ZIP License"#,
        index: 344,
        flags: 0x0,
    },
    License {
        name: "Inner-Net-2.0",
        full_name: r#"Inner Net License v2.0"#,
        index: 345,
        flags: 0x0,
    },
    License {
        name: "InnoSetup",
        full_name: r#"Inno Setup License"#,
        index: 346,
        flags: 0x0,
    },
    License {
        name: "Intel",
        full_name: r#"Intel Open Source License"#,
        index: 347,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Intel-ACPI",
        full_name: r#"Intel ACPI Software License Agreement"#,
        index: 348,
        flags: 0x0,
    },
    License {
        name: "Interbase-1.0",
        full_name: r#"Interbase Public License v1.0"#,
        index: 349,
        flags: 0x0,
    },
    License {
        name: "JPL-image",
        full_name: r#"JPL Image Use Policy"#,
        index: 350,
        flags: 0x0,
    },
    License {
        name: "JPNIC",
        full_name: r#"Japan Network Information Center License"#,
        index: 351,
        flags: 0x0,
    },
    License {
        name: "JSON",
        full_name: r#"JSON License"#,
        index: 352,
        flags: 0x0,
    },
    License {
        name: "Jam",
        full_name: r#"Jam License"#,
        index: 353,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "JasPer-2.0",
        full_name: r#"JasPer License"#,
        index: 354,
        flags: 0x0,
    },
    License {
        name: "Kastrup",
        full_name: r#"Kastrup License"#,
        index: 355,
        flags: 0x0,
    },
    License {
        name: "Kazlib",
        full_name: r#"Kazlib License"#,
        index: 356,
        flags: 0x0,
    },
    License {
        name: "Knuth-CTAN",
        full_name: r#"Knuth CTAN License"#,
        index: 357,
        flags: 0x0,
    },
    License {
        name: "LAL-1.2",
        full_name: r#"Licence Art Libre 1.2"#,
        index: 358,
        flags: 0x0,
    },
    License {
        name: "LAL-1.3",
        full_name: r#"Licence Art Libre 1.3"#,
        index: 359,
        flags: 0x0,
    },
    License {
        name: "LGPL-2.0",
        full_name: r#"GNU Library General Public License v2 only"#,
        index: 360,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-2.0+",
        full_name: r#"GNU Library General Public License v2 or later"#,
        index: 361,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-2.0-only",
        full_name: r#"GNU Library General Public License v2 only"#,
        index: 362,
        flags: IS_OSI_APPROVED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-2.0-or-later",
        full_name: r#"GNU Library General Public License v2 or later"#,
        index: 363,
        flags: IS_OSI_APPROVED | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-2.1",
        full_name: r#"GNU Lesser General Public License v2.1 only"#,
        index: 364,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-2.1+",
        full_name: r#"GNU Lesser General Public License v2.1 or later"#,
        index: 365,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-2.1-only",
        full_name: r#"GNU Lesser General Public License v2.1 only"#,
        index: 366,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-2.1-or-later",
        full_name: r#"GNU Lesser General Public License v2.1 or later"#,
        index: 367,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-3.0",
        full_name: r#"GNU Lesser General Public License v3.0 only"#,
        index: 368,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-3.0+",
        full_name: r#"GNU Lesser General Public License v3.0 or later"#,
        index: 369,
        flags: IS_DEPRECATED | IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-3.0-only",
        full_name: r#"GNU Lesser General Public License v3.0 only"#,
        index: 370,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPL-3.0-or-later",
        full_name: r#"GNU Lesser General Public License v3.0 or later"#,
        index: 371,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT | IS_GNU,
    },
    License {
        name: "LGPLLR",
        full_name: r#"Lesser General Public License For Linguistic Resources"#,
        index: 372,
        flags: 0x0,
    },
    License {
        name: "LOOP",
        full_name: r#"Common Lisp LOOP License"#,
        index: 373,
        flags: 0x0,
    },
    License {
        name: "LPD-document",
        full_name: r#"LPD Documentation License"#,
        index: 374,
        flags: 0x0,
    },
    License {
        name: "LPL-1.0",
        full_name: r#"Lucent Public License Version 1.0"#,
        index: 375,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "LPL-1.02",
        full_name: r#"Lucent Public License v1.02"#,
        index: 376,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "LPPL-1.0",
        full_name: r#"LaTeX Project Public License v1.0"#,
        index: 377,
        flags: 0x0,
    },
    License {
        name: "LPPL-1.1",
        full_name: r#"LaTeX Project Public License v1.1"#,
        index: 378,
        flags: 0x0,
    },
    License {
        name: "LPPL-1.2",
        full_name: r#"LaTeX Project Public License v1.2"#,
        index: 379,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "LPPL-1.3a",
        full_name: r#"LaTeX Project Public License v1.3a"#,
        index: 380,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "LPPL-1.3c",
        full_name: r#"LaTeX Project Public License v1.3c"#,
        index: 381,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "LZMA-SDK-9.11-to-9.20",
        full_name: r#"LZMA SDK License (versions 9.11 to 9.20)"#,
        index: 382,
        flags: 0x0,
    },
    License {
        name: "LZMA-SDK-9.22",
        full_name: r#"LZMA SDK License (versions 9.22 and beyond)"#,
        index: 383,
        flags: 0x0,
    },
    License {
        name: "Latex2e",
        full_name: r#"Latex2e License"#,
        index: 384,
        flags: 0x0,
    },
    License {
        name: "Latex2e-translated-notice",
        full_name: r#"Latex2e with translated notice permission"#,
        index: 385,
        flags: 0x0,
    },
    License {
        name: "Leptonica",
        full_name: r#"Leptonica License"#,
        index: 386,
        flags: 0x0,
    },
    License {
        name: "LiLiQ-P-1.1",
        full_name: r#"Licence Libre du Québec – Permissive version 1.1"#,
        index: 387,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "LiLiQ-R-1.1",
        full_name: r#"Licence Libre du Québec – Réciprocité version 1.1"#,
        index: 388,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "LiLiQ-Rplus-1.1",
        full_name: r#"Licence Libre du Québec – Réciprocité forte version 1.1"#,
        index: 389,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Libpng",
        full_name: r#"libpng License"#,
        index: 390,
        flags: 0x0,
    },
    License {
        name: "Linux-OpenIB",
        full_name: r#"Linux Kernel Variant of OpenIB.org license"#,
        index: 391,
        flags: 0x0,
    },
    License {
        name: "Linux-man-pages-1-para",
        full_name: r#"Linux man-pages - 1 paragraph"#,
        index: 392,
        flags: 0x0,
    },
    License {
        name: "Linux-man-pages-copyleft",
        full_name: r#"Linux man-pages Copyleft"#,
        index: 393,
        flags: 0x0,
    },
    License {
        name: "Linux-man-pages-copyleft-2-para",
        full_name: r#"Linux man-pages Copyleft - 2 paragraphs"#,
        index: 394,
        flags: 0x0,
    },
    License {
        name: "Linux-man-pages-copyleft-var",
        full_name: r#"Linux man-pages Copyleft Variant"#,
        index: 395,
        flags: 0x0,
    },
    License {
        name: "Lucida-Bitmap-Fonts",
        full_name: r#"Lucida Bitmap Fonts License"#,
        index: 396,
        flags: 0x0,
    },
    License {
        name: "MIPS",
        full_name: r#"MIPS License"#,
        index: 397,
        flags: 0x0,
    },
    License {
        name: "MIT",
        full_name: r#"MIT License"#,
        index: 398,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "MIT-0",
        full_name: r#"MIT No Attribution"#,
        index: 399,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "MIT-CMU",
        full_name: r#"CMU License"#,
        index: 400,
        flags: 0x0,
    },
    License {
        name: "MIT-Click",
        full_name: r#"MIT Click License"#,
        index: 401,
        flags: 0x0,
    },
    License {
        name: "MIT-Festival",
        full_name: r#"MIT Festival Variant"#,
        index: 402,
        flags: 0x0,
    },
    License {
        name: "MIT-Khronos-old",
        full_name: r#"MIT Khronos - old variant"#,
        index: 403,
        flags: 0x0,
    },
    License {
        name: "MIT-Modern-Variant",
        full_name: r#"MIT License Modern Variant"#,
        index: 404,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "MIT-Wu",
        full_name: r#"MIT Tom Wu Variant"#,
        index: 405,
        flags: 0x0,
    },
    License {
        name: "MIT-advertising",
        full_name: r#"Enlightenment License (e16)"#,
        index: 406,
        flags: 0x0,
    },
    License {
        name: "MIT-enna",
        full_name: r#"enna License"#,
        index: 407,
        flags: 0x0,
    },
    License {
        name: "MIT-feh",
        full_name: r#"feh License"#,
        index: 408,
        flags: 0x0,
    },
    License {
        name: "MIT-open-group",
        full_name: r#"MIT Open Group variant"#,
        index: 409,
        flags: 0x0,
    },
    License {
        name: "MIT-testregex",
        full_name: r#"MIT testregex Variant"#,
        index: 410,
        flags: 0x0,
    },
    License {
        name: "MITNFA",
        full_name: r#"MIT +no-false-attribs license"#,
        index: 411,
        flags: 0x0,
    },
    License {
        name: "MMIXware",
        full_name: r#"MMIXware License"#,
        index: 412,
        flags: 0x0,
    },
    License {
        name: "MPEG-SSG",
        full_name: r#"MPEG Software Simulation"#,
        index: 413,
        flags: 0x0,
    },
    License {
        name: "MPL-1.0",
        full_name: r#"Mozilla Public License 1.0"#,
        index: 414,
        flags: IS_OSI_APPROVED | IS_COPYLEFT,
    },
    License {
        name: "MPL-1.1",
        full_name: r#"Mozilla Public License 1.1"#,
        index: 415,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "MPL-2.0",
        full_name: r#"Mozilla Public License 2.0"#,
        index: 416,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "MPL-2.0-no-copyleft-exception",
        full_name: r#"Mozilla Public License 2.0 (no copyleft exception)"#,
        index: 417,
        flags: IS_OSI_APPROVED | IS_COPYLEFT,
    },
    License {
        name: "MS-LPL",
        full_name: r#"Microsoft Limited Public License"#,
        index: 418,
        flags: 0x0,
    },
    License {
        name: "MS-PL",
        full_name: r#"Microsoft Public License"#,
        index: 419,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "MS-RL",
        full_name: r#"Microsoft Reciprocal License"#,
        index: 420,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "MTLL",
        full_name: r#"Matrix Template Library License"#,
        index: 421,
        flags: 0x0,
    },
    License {
        name: "Mackerras-3-Clause",
        full_name: r#"Mackerras 3-Clause License"#,
        index: 422,
        flags: 0x0,
    },
    License {
        name: "Mackerras-3-Clause-acknowledgment",
        full_name: r#"Mackerras 3-Clause - acknowledgment variant"#,
        index: 423,
        flags: 0x0,
    },
    License {
        name: "MakeIndex",
        full_name: r#"MakeIndex License"#,
        index: 424,
        flags: 0x0,
    },
    License {
        name: "Martin-Birgmeier",
        full_name: r#"Martin Birgmeier License"#,
        index: 425,
        flags: 0x0,
    },
    License {
        name: "McPhee-slideshow",
        full_name: r#"McPhee Slideshow License"#,
        index: 426,
        flags: 0x0,
    },
    License {
        name: "Minpack",
        full_name: r#"Minpack License"#,
        index: 427,
        flags: 0x0,
    },
    License {
        name: "MirOS",
        full_name: r#"The MirOS Licence"#,
        index: 428,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Motosoto",
        full_name: r#"Motosoto License"#,
        index: 429,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "MulanPSL-1.0",
        full_name: r#"Mulan Permissive Software License, Version 1"#,
        index: 430,
        flags: 0x0,
    },
    License {
        name: "MulanPSL-2.0",
        full_name: r#"Mulan Permissive Software License, Version 2"#,
        index: 431,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Multics",
        full_name: r#"Multics License"#,
        index: 432,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Mup",
        full_name: r#"Mup License"#,
        index: 433,
        flags: 0x0,
    },
    License {
        name: "NAIST-2003",
        full_name: r#"Nara Institute of Science and Technology License (2003)"#,
        index: 434,
        flags: 0x0,
    },
    License {
        name: "NASA-1.3",
        full_name: r#"NASA Open Source Agreement 1.3"#,
        index: 435,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "NBPL-1.0",
        full_name: r#"Net Boolean Public License v1"#,
        index: 436,
        flags: 0x0,
    },
    License {
        name: "NCBI-PD",
        full_name: r#"NCBI Public Domain Notice"#,
        index: 437,
        flags: 0x0,
    },
    License {
        name: "NCGL-UK-2.0",
        full_name: r#"Non-Commercial Government Licence"#,
        index: 438,
        flags: 0x0,
    },
    License {
        name: "NCL",
        full_name: r#"NCL Source Code License"#,
        index: 439,
        flags: 0x0,
    },
    License {
        name: "NCSA",
        full_name: r#"University of Illinois/NCSA Open Source License"#,
        index: 440,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "NGPL",
        full_name: r#"Nethack General Public License"#,
        index: 441,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "NICTA-1.0",
        full_name: r#"NICTA Public Software License, Version 1.0"#,
        index: 442,
        flags: 0x0,
    },
    License {
        name: "NIST-PD",
        full_name: r#"NIST Public Domain Notice"#,
        index: 443,
        flags: 0x0,
    },
    License {
        name: "NIST-PD-fallback",
        full_name: r#"NIST Public Domain Notice with license fallback"#,
        index: 444,
        flags: 0x0,
    },
    License {
        name: "NIST-Software",
        full_name: r#"NIST Software License"#,
        index: 445,
        flags: 0x0,
    },
    License {
        name: "NLOD-1.0",
        full_name: r#"Norwegian Licence for Open Government Data (NLOD) 1.0"#,
        index: 446,
        flags: 0x0,
    },
    License {
        name: "NLOD-2.0",
        full_name: r#"Norwegian Licence for Open Government Data (NLOD) 2.0"#,
        index: 447,
        flags: 0x0,
    },
    License {
        name: "NLPL",
        full_name: r#"No Limit Public License"#,
        index: 448,
        flags: 0x0,
    },
    License {
        name: "NOASSERTION",
        full_name: r#"NOASSERTION"#,
        index: 449,
        flags: 0x0,
    },
    License {
        name: "NOSL",
        full_name: r#"Netizen Open Source License"#,
        index: 450,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "NPL-1.0",
        full_name: r#"Netscape Public License v1.0"#,
        index: 451,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "NPL-1.1",
        full_name: r#"Netscape Public License v1.1"#,
        index: 452,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "NPOSL-3.0",
        full_name: r#"Non-Profit Open Software License 3.0"#,
        index: 453,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "NRL",
        full_name: r#"NRL License"#,
        index: 454,
        flags: 0x0,
    },
    License {
        name: "NTIA-PD",
        full_name: r#"NTIA Public Domain Notice"#,
        index: 455,
        flags: 0x0,
    },
    License {
        name: "NTP",
        full_name: r#"NTP License"#,
        index: 456,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "NTP-0",
        full_name: r#"NTP No Attribution"#,
        index: 457,
        flags: 0x0,
    },
    License {
        name: "Naumen",
        full_name: r#"Naumen Public License"#,
        index: 458,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Net-SNMP",
        full_name: r#"Net-SNMP License"#,
        index: 459,
        flags: IS_DEPRECATED,
    },
    License {
        name: "NetCDF",
        full_name: r#"NetCDF license"#,
        index: 460,
        flags: 0x0,
    },
    License {
        name: "Newsletr",
        full_name: r#"Newsletr License"#,
        index: 461,
        flags: 0x0,
    },
    License {
        name: "Nokia",
        full_name: r#"Nokia Open Source License"#,
        index: 462,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Noweb",
        full_name: r#"Noweb License"#,
        index: 463,
        flags: 0x0,
    },
    License {
        name: "Nunit",
        full_name: r#"Nunit License"#,
        index: 464,
        flags: IS_DEPRECATED | IS_FSF_LIBRE,
    },
    License {
        name: "O-UDA-1.0",
        full_name: r#"Open Use of Data Agreement v1.0"#,
        index: 465,
        flags: 0x0,
    },
    License {
        name: "OAR",
        full_name: r#"OAR License"#,
        index: 466,
        flags: 0x0,
    },
    License {
        name: "OCCT-PL",
        full_name: r#"Open CASCADE Technology Public License"#,
        index: 467,
        flags: 0x0,
    },
    License {
        name: "OCLC-2.0",
        full_name: r#"OCLC Research Public License 2.0"#,
        index: 468,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "ODC-By-1.0",
        full_name: r#"Open Data Commons Attribution License v1.0"#,
        index: 469,
        flags: 0x0,
    },
    License {
        name: "ODbL-1.0",
        full_name: r#"Open Data Commons Open Database License v1.0"#,
        index: 470,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "OFFIS",
        full_name: r#"OFFIS License"#,
        index: 471,
        flags: 0x0,
    },
    License {
        name: "OFL-1.0",
        full_name: r#"SIL Open Font License 1.0"#,
        index: 472,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "OFL-1.0-RFN",
        full_name: r#"SIL Open Font License 1.0 with Reserved Font Name"#,
        index: 473,
        flags: 0x0,
    },
    License {
        name: "OFL-1.0-no-RFN",
        full_name: r#"SIL Open Font License 1.0 with no Reserved Font Name"#,
        index: 474,
        flags: 0x0,
    },
    License {
        name: "OFL-1.1",
        full_name: r#"SIL Open Font License 1.1"#,
        index: 475,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "OFL-1.1-RFN",
        full_name: r#"SIL Open Font License 1.1 with Reserved Font Name"#,
        index: 476,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "OFL-1.1-no-RFN",
        full_name: r#"SIL Open Font License 1.1 with no Reserved Font Name"#,
        index: 477,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "OGC-1.0",
        full_name: r#"OGC Software License, Version 1.0"#,
        index: 478,
        flags: 0x0,
    },
    License {
        name: "OGDL-Taiwan-1.0",
        full_name: r#"Taiwan Open Government Data License, version 1.0"#,
        index: 479,
        flags: 0x0,
    },
    License {
        name: "OGL-Canada-2.0",
        full_name: r#"Open Government Licence - Canada"#,
        index: 480,
        flags: 0x0,
    },
    License {
        name: "OGL-UK-1.0",
        full_name: r#"Open Government Licence v1.0"#,
        index: 481,
        flags: 0x0,
    },
    License {
        name: "OGL-UK-2.0",
        full_name: r#"Open Government Licence v2.0"#,
        index: 482,
        flags: 0x0,
    },
    License {
        name: "OGL-UK-3.0",
        full_name: r#"Open Government Licence v3.0"#,
        index: 483,
        flags: 0x0,
    },
    License {
        name: "OGTSL",
        full_name: r#"Open Group Test Suite License"#,
        index: 484,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "OLDAP-1.1",
        full_name: r#"Open LDAP Public License v1.1"#,
        index: 485,
        flags: 0x0,
    },
    License {
        name: "OLDAP-1.2",
        full_name: r#"Open LDAP Public License v1.2"#,
        index: 486,
        flags: 0x0,
    },
    License {
        name: "OLDAP-1.3",
        full_name: r#"Open LDAP Public License v1.3"#,
        index: 487,
        flags: 0x0,
    },
    License {
        name: "OLDAP-1.4",
        full_name: r#"Open LDAP Public License v1.4"#,
        index: 488,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.0",
        full_name: r#"Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)"#,
        index: 489,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.0.1",
        full_name: r#"Open LDAP Public License v2.0.1"#,
        index: 490,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.1",
        full_name: r#"Open LDAP Public License v2.1"#,
        index: 491,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.2",
        full_name: r#"Open LDAP Public License v2.2"#,
        index: 492,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.2.1",
        full_name: r#"Open LDAP Public License v2.2.1"#,
        index: 493,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.2.2",
        full_name: r#"Open LDAP Public License 2.2.2"#,
        index: 494,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.3",
        full_name: r#"Open LDAP Public License v2.3"#,
        index: 495,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "OLDAP-2.4",
        full_name: r#"Open LDAP Public License v2.4"#,
        index: 496,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.5",
        full_name: r#"Open LDAP Public License v2.5"#,
        index: 497,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.6",
        full_name: r#"Open LDAP Public License v2.6"#,
        index: 498,
        flags: 0x0,
    },
    License {
        name: "OLDAP-2.7",
        full_name: r#"Open LDAP Public License v2.7"#,
        index: 499,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "OLDAP-2.8",
        full_name: r#"Open LDAP Public License v2.8"#,
        index: 500,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "OLFL-1.3",
        full_name: r#"Open Logistics Foundation License Version 1.3"#,
        index: 501,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "OML",
        full_name: r#"Open Market License"#,
        index: 502,
        flags: 0x0,
    },
    License {
        name: "OPL-1.0",
        full_name: r#"Open Public License v1.0"#,
        index: 503,
        flags: 0x0,
    },
    License {
        name: "OPL-UK-3.0",
        full_name: r#"United    Kingdom Open Parliament Licence v3.0"#,
        index: 504,
        flags: 0x0,
    },
    License {
        name: "OPUBL-1.0",
        full_name: r#"Open Publication License v1.0"#,
        index: 505,
        flags: 0x0,
    },
    License {
        name: "OSET-PL-2.1",
        full_name: r#"OSET Public License version 2.1"#,
        index: 506,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "OSL-1.0",
        full_name: r#"Open Software License 1.0"#,
        index: 507,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "OSL-1.1",
        full_name: r#"Open Software License 1.1"#,
        index: 508,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "OSL-2.0",
        full_name: r#"Open Software License 2.0"#,
        index: 509,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "OSL-2.1",
        full_name: r#"Open Software License 2.1"#,
        index: 510,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "OSL-3.0",
        full_name: r#"Open Software License 3.0"#,
        index: 511,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "OpenPBS-2.3",
        full_name: r#"OpenPBS v2.3 Software License"#,
        index: 512,
        flags: 0x0,
    },
    License {
        name: "OpenSSL",
        full_name: r#"OpenSSL License"#,
        index: 513,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "OpenSSL-standalone",
        full_name: r#"OpenSSL License - standalone"#,
        index: 514,
        flags: 0x0,
    },
    License {
        name: "OpenVision",
        full_name: r#"OpenVision License"#,
        index: 515,
        flags: 0x0,
    },
    License {
        name: "PADL",
        full_name: r#"PADL License"#,
        index: 516,
        flags: 0x0,
    },
    License {
        name: "PDDL-1.0",
        full_name: r#"Open Data Commons Public Domain Dedication & License 1.0"#,
        index: 517,
        flags: 0x0,
    },
    License {
        name: "PHP-3.0",
        full_name: r#"PHP License v3.0"#,
        index: 518,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "PHP-3.01",
        full_name: r#"PHP License v3.01"#,
        index: 519,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "PPL",
        full_name: r#"Peer Production License"#,
        index: 520,
        flags: 0x0,
    },
    License {
        name: "PSF-2.0",
        full_name: r#"Python Software Foundation License 2.0"#,
        index: 521,
        flags: 0x0,
    },
    License {
        name: "Parity-6.0.0",
        full_name: r#"The Parity Public License 6.0.0"#,
        index: 522,
        flags: IS_COPYLEFT,
    },
    License {
        name: "Parity-7.0.0",
        full_name: r#"The Parity Public License 7.0.0"#,
        index: 523,
        flags: 0x0,
    },
    License {
        name: "Pixar",
        full_name: r#"Pixar License"#,
        index: 524,
        flags: 0x0,
    },
    License {
        name: "Plexus",
        full_name: r#"Plexus Classworlds License"#,
        index: 525,
        flags: 0x0,
    },
    License {
        name: "PolyForm-Noncommercial-1.0.0",
        full_name: r#"PolyForm Noncommercial License 1.0.0"#,
        index: 526,
        flags: 0x0,
    },
    License {
        name: "PolyForm-Small-Business-1.0.0",
        full_name: r#"PolyForm Small Business License 1.0.0"#,
        index: 527,
        flags: 0x0,
    },
    License {
        name: "PostgreSQL",
        full_name: r#"PostgreSQL License"#,
        index: 528,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Python-2.0",
        full_name: r#"Python License 2.0"#,
        index: 529,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Python-2.0.1",
        full_name: r#"Python License 2.0.1"#,
        index: 530,
        flags: 0x0,
    },
    License {
        name: "QPL-1.0",
        full_name: r#"Q Public License 1.0"#,
        index: 531,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "QPL-1.0-INRIA-2004",
        full_name: r#"Q Public License 1.0 - INRIA 2004 variant"#,
        index: 532,
        flags: 0x0,
    },
    License {
        name: "Qhull",
        full_name: r#"Qhull License"#,
        index: 533,
        flags: 0x0,
    },
    License {
        name: "RHeCos-1.1",
        full_name: r#"Red Hat eCos Public License v1.1"#,
        index: 534,
        flags: 0x0,
    },
    License {
        name: "RPL-1.1",
        full_name: r#"Reciprocal Public License 1.1"#,
        index: 535,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "RPL-1.5",
        full_name: r#"Reciprocal Public License 1.5"#,
        index: 536,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "RPSL-1.0",
        full_name: r#"RealNetworks Public Source License v1.0"#,
        index: 537,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "RSA-MD",
        full_name: r#"RSA Message-Digest License"#,
        index: 538,
        flags: 0x0,
    },
    License {
        name: "RSCPL",
        full_name: r#"Ricoh Source Code Public License"#,
        index: 539,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Rdisc",
        full_name: r#"Rdisc License"#,
        index: 540,
        flags: 0x0,
    },
    License {
        name: "Ruby",
        full_name: r#"Ruby License"#,
        index: 541,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Ruby-pty",
        full_name: r#"Ruby pty extension license"#,
        index: 542,
        flags: 0x0,
    },
    License {
        name: "SAX-PD",
        full_name: r#"Sax Public Domain Notice"#,
        index: 543,
        flags: 0x0,
    },
    License {
        name: "SAX-PD-2.0",
        full_name: r#"Sax Public Domain Notice 2.0"#,
        index: 544,
        flags: 0x0,
    },
    License {
        name: "SCEA",
        full_name: r#"SCEA Shared Source License"#,
        index: 545,
        flags: 0x0,
    },
    License {
        name: "SGI-B-1.0",
        full_name: r#"SGI Free Software License B v1.0"#,
        index: 546,
        flags: 0x0,
    },
    License {
        name: "SGI-B-1.1",
        full_name: r#"SGI Free Software License B v1.1"#,
        index: 547,
        flags: 0x0,
    },
    License {
        name: "SGI-B-2.0",
        full_name: r#"SGI Free Software License B v2.0"#,
        index: 548,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "SGI-OpenGL",
        full_name: r#"SGI OpenGL License"#,
        index: 549,
        flags: 0x0,
    },
    License {
        name: "SGP4",
        full_name: r#"SGP4 Permission Notice"#,
        index: 550,
        flags: 0x0,
    },
    License {
        name: "SHL-0.5",
        full_name: r#"Solderpad Hardware License v0.5"#,
        index: 551,
        flags: 0x0,
    },
    License {
        name: "SHL-0.51",
        full_name: r#"Solderpad Hardware License, Version 0.51"#,
        index: 552,
        flags: 0x0,
    },
    License {
        name: "SISSL",
        full_name: r#"Sun Industry Standards Source License v1.1"#,
        index: 553,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "SISSL-1.2",
        full_name: r#"Sun Industry Standards Source License v1.2"#,
        index: 554,
        flags: 0x0,
    },
    License {
        name: "SL",
        full_name: r#"SL License"#,
        index: 555,
        flags: 0x0,
    },
    License {
        name: "SMAIL-GPL",
        full_name: r#"SMAIL General Public License"#,
        index: 556,
        flags: 0x0,
    },
    License {
        name: "SMLNJ",
        full_name: r#"Standard ML of New Jersey License"#,
        index: 557,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "SMPPL",
        full_name: r#"Secure Messaging Protocol Public License"#,
        index: 558,
        flags: 0x0,
    },
    License {
        name: "SNIA",
        full_name: r#"SNIA Public License 1.1"#,
        index: 559,
        flags: 0x0,
    },
    License {
        name: "SOFA",
        full_name: r#"SOFA Software License"#,
        index: 560,
        flags: 0x0,
    },
    License {
        name: "SPL-1.0",
        full_name: r#"Sun Public License v1.0"#,
        index: 561,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "SSH-OpenSSH",
        full_name: r#"SSH OpenSSH license"#,
        index: 562,
        flags: 0x0,
    },
    License {
        name: "SSH-short",
        full_name: r#"SSH short notice"#,
        index: 563,
        flags: 0x0,
    },
    License {
        name: "SSLeay-standalone",
        full_name: r#"SSLeay License - standalone"#,
        index: 564,
        flags: 0x0,
    },
    License {
        name: "SSPL-1.0",
        full_name: r#"Server Side Public License, v 1"#,
        index: 565,
        flags: 0x0,
    },
    License {
        name: "SUL-1.0",
        full_name: r#"Sustainable Use License v1.0"#,
        index: 566,
        flags: 0x0,
    },
    License {
        name: "SWL",
        full_name: r#"Scheme Widget Library (SWL) Software License Agreement"#,
        index: 567,
        flags: 0x0,
    },
    License {
        name: "Saxpath",
        full_name: r#"Saxpath License"#,
        index: 568,
        flags: 0x0,
    },
    License {
        name: "SchemeReport",
        full_name: r#"Scheme Language Report License"#,
        index: 569,
        flags: 0x0,
    },
    License {
        name: "Sendmail",
        full_name: r#"Sendmail License"#,
        index: 570,
        flags: 0x0,
    },
    License {
        name: "Sendmail-8.23",
        full_name: r#"Sendmail License 8.23"#,
        index: 571,
        flags: 0x0,
    },
    License {
        name: "Sendmail-Open-Source-1.1",
        full_name: r#"Sendmail Open Source License v1.1"#,
        index: 572,
        flags: 0x0,
    },
    License {
        name: "SimPL-2.0",
        full_name: r#"Simple Public License 2.0"#,
        index: 573,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Sleepycat",
        full_name: r#"Sleepycat License"#,
        index: 574,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Soundex",
        full_name: r#"Soundex License"#,
        index: 575,
        flags: 0x0,
    },
    License {
        name: "Spencer-86",
        full_name: r#"Spencer License 86"#,
        index: 576,
        flags: 0x0,
    },
    License {
        name: "Spencer-94",
        full_name: r#"Spencer License 94"#,
        index: 577,
        flags: 0x0,
    },
    License {
        name: "Spencer-99",
        full_name: r#"Spencer License 99"#,
        index: 578,
        flags: 0x0,
    },
    License {
        name: "StandardML-NJ",
        full_name: r#"Standard ML of New Jersey License"#,
        index: 579,
        flags: IS_DEPRECATED | IS_FSF_LIBRE,
    },
    License {
        name: "SugarCRM-1.1.3",
        full_name: r#"SugarCRM Public License v1.1.3"#,
        index: 580,
        flags: 0x0,
    },
    License {
        name: "Sun-PPP",
        full_name: r#"Sun PPP License"#,
        index: 581,
        flags: 0x0,
    },
    License {
        name: "Sun-PPP-2000",
        full_name: r#"Sun PPP License (2000)"#,
        index: 582,
        flags: 0x0,
    },
    License {
        name: "SunPro",
        full_name: r#"SunPro License"#,
        index: 583,
        flags: 0x0,
    },
    License {
        name: "Symlinks",
        full_name: r#"Symlinks License"#,
        index: 584,
        flags: 0x0,
    },
    License {
        name: "TAPR-OHL-1.0",
        full_name: r#"TAPR Open Hardware License v1.0"#,
        index: 585,
        flags: 0x0,
    },
    License {
        name: "TCL",
        full_name: r#"TCL/TK License"#,
        index: 586,
        flags: 0x0,
    },
    License {
        name: "TCP-wrappers",
        full_name: r#"TCP Wrappers License"#,
        index: 587,
        flags: 0x0,
    },
    License {
        name: "TGPPL-1.0",
        full_name: r#"Transitive Grace Period Public Licence 1.0"#,
        index: 588,
        flags: 0x0,
    },
    License {
        name: "TMate",
        full_name: r#"TMate Open Source License"#,
        index: 589,
        flags: 0x0,
    },
    License {
        name: "TORQUE-1.1",
        full_name: r#"TORQUE v2.5+ Software License v1.1"#,
        index: 590,
        flags: 0x0,
    },
    License {
        name: "TOSL",
        full_name: r#"Trusster Open Source License"#,
        index: 591,
        flags: 0x0,
    },
    License {
        name: "TPDL",
        full_name: r#"Time::ParseDate License"#,
        index: 592,
        flags: 0x0,
    },
    License {
        name: "TPL-1.0",
        full_name: r#"THOR Public License 1.0"#,
        index: 593,
        flags: 0x0,
    },
    License {
        name: "TTWL",
        full_name: r#"Text-Tabs+Wrap License"#,
        index: 594,
        flags: 0x0,
    },
    License {
        name: "TTYP0",
        full_name: r#"TTYP0 License"#,
        index: 595,
        flags: 0x0,
    },
    License {
        name: "TU-Berlin-1.0",
        full_name: r#"Technische Universitaet Berlin License 1.0"#,
        index: 596,
        flags: 0x0,
    },
    License {
        name: "TU-Berlin-2.0",
        full_name: r#"Technische Universitaet Berlin License 2.0"#,
        index: 597,
        flags: 0x0,
    },
    License {
        name: "TermReadKey",
        full_name: r#"TermReadKey License"#,
        index: 598,
        flags: 0x0,
    },
    License {
        name: "ThirdEye",
        full_name: r#"ThirdEye License"#,
        index: 599,
        flags: 0x0,
    },
    License {
        name: "TrustedQSL",
        full_name: r#"TrustedQSL License"#,
        index: 600,
        flags: 0x0,
    },
    License {
        name: "UCAR",
        full_name: r#"UCAR License"#,
        index: 601,
        flags: 0x0,
    },
    License {
        name: "UCL-1.0",
        full_name: r#"Upstream Compatibility License v1.0"#,
        index: 602,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "UMich-Merit",
        full_name: r#"Michigan/Merit Networks License"#,
        index: 603,
        flags: 0x0,
    },
    License {
        name: "UPL-1.0",
        full_name: r#"Universal Permissive License v1.0"#,
        index: 604,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "URT-RLE",
        full_name: r#"Utah Raster Toolkit Run Length Encoded License"#,
        index: 605,
        flags: 0x0,
    },
    License {
        name: "Ubuntu-font-1.0",
        full_name: r#"Ubuntu Font Licence v1.0"#,
        index: 606,
        flags: 0x0,
    },
    License {
        name: "Unicode-3.0",
        full_name: r#"Unicode License v3"#,
        index: 607,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Unicode-DFS-2015",
        full_name: r#"Unicode License Agreement - Data Files and Software (2015)"#,
        index: 608,
        flags: 0x0,
    },
    License {
        name: "Unicode-DFS-2016",
        full_name: r#"Unicode License Agreement - Data Files and Software (2016)"#,
        index: 609,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Unicode-TOU",
        full_name: r#"Unicode Terms of Use"#,
        index: 610,
        flags: 0x0,
    },
    License {
        name: "UnixCrypt",
        full_name: r#"UnixCrypt License"#,
        index: 611,
        flags: 0x0,
    },
    License {
        name: "Unlicense",
        full_name: r#"The Unlicense"#,
        index: 612,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Unlicense-libtelnet",
        full_name: r#"Unlicense - libtelnet variant"#,
        index: 613,
        flags: 0x0,
    },
    License {
        name: "Unlicense-libwhirlpool",
        full_name: r#"Unlicense - libwhirlpool variant"#,
        index: 614,
        flags: 0x0,
    },
    License {
        name: "VOSTROM",
        full_name: r#"VOSTROM Public License for Open Source"#,
        index: 615,
        flags: 0x0,
    },
    License {
        name: "VSL-1.0",
        full_name: r#"Vovida Software License v1.0"#,
        index: 616,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Vim",
        full_name: r#"Vim License"#,
        index: 617,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "W3C",
        full_name: r#"W3C Software Notice and License (2002-12-31)"#,
        index: 618,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "W3C-19980720",
        full_name: r#"W3C Software Notice and License (1998-07-20)"#,
        index: 619,
        flags: 0x0,
    },
    License {
        name: "W3C-20150513",
        full_name: r#"W3C Software Notice and Document License (2015-05-13)"#,
        index: 620,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "WTFPL",
        full_name: r#"Do What The F*ck You Want To Public License"#,
        index: 621,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Watcom-1.0",
        full_name: r#"Sybase Open Watcom Public License 1.0"#,
        index: 622,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "Widget-Workshop",
        full_name: r#"Widget Workshop License"#,
        index: 623,
        flags: 0x0,
    },
    License {
        name: "Wsuipa",
        full_name: r#"Wsuipa License"#,
        index: 624,
        flags: 0x0,
    },
    License {
        name: "X11",
        full_name: r#"X11 License"#,
        index: 625,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "X11-distribute-modifications-variant",
        full_name: r#"X11 License Distribution Modification Variant"#,
        index: 626,
        flags: 0x0,
    },
    License {
        name: "X11-swapped",
        full_name: r#"X11 swapped final paragraphs"#,
        index: 627,
        flags: 0x0,
    },
    License {
        name: "XFree86-1.1",
        full_name: r#"XFree86 License 1.1"#,
        index: 628,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "XSkat",
        full_name: r#"XSkat License"#,
        index: 629,
        flags: 0x0,
    },
    License {
        name: "Xdebug-1.03",
        full_name: r#"Xdebug License v 1.03"#,
        index: 630,
        flags: 0x0,
    },
    License {
        name: "Xerox",
        full_name: r#"Xerox License"#,
        index: 631,
        flags: 0x0,
    },
    License {
        name: "Xfig",
        full_name: r#"Xfig License"#,
        index: 632,
        flags: 0x0,
    },
    License {
        name: "Xnet",
        full_name: r#"X.Net License"#,
        index: 633,
        flags: IS_OSI_APPROVED,
    },
    License {
        name: "YPL-1.0",
        full_name: r#"Yahoo! Public License v1.0"#,
        index: 634,
        flags: 0x0,
    },
    License {
        name: "YPL-1.1",
        full_name: r#"Yahoo! Public License v1.1"#,
        index: 635,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "ZPL-1.1",
        full_name: r#"Zope Public License 1.1"#,
        index: 636,
        flags: 0x0,
    },
    License {
        name: "ZPL-2.0",
        full_name: r#"Zope Public License 2.0"#,
        index: 637,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "ZPL-2.1",
        full_name: r#"Zope Public License 2.1"#,
        index: 638,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "Zed",
        full_name: r#"Zed License"#,
        index: 639,
        flags: 0x0,
    },
    License {
        name: "Zeeff",
        full_name: r#"Zeeff License"#,
        index: 640,
        flags: 0x0,
    },
    License {
        name: "Zend-2.0",
        full_name: r#"Zend License v2.0"#,
        index: 641,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Zimbra-1.3",
        full_name: r#"Zimbra Public License v1.3"#,
        index: 642,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "Zimbra-1.4",
        full_name: r#"Zimbra Public License v1.4"#,
        index: 643,
        flags: 0x0,
    },
    License {
        name: "Zlib",
        full_name: r#"zlib License"#,
        index: 644,
        flags: IS_OSI_APPROVED | IS_FSF_LIBRE,
    },
    License {
        name: "any-OSI",
        full_name: r#"Any OSI License"#,
        index: 645,
        flags: 0x0,
    },
    License {
        name: "any-OSI-perl-modules",
        full_name: r#"Any OSI License - Perl Modules"#,
        index: 646,
        flags: 0x0,
    },
    License {
        name: "bcrypt-Solar-Designer",
        full_name: r#"bcrypt Solar Designer License"#,
        index: 647,
        flags: 0x0,
    },
    License {
        name: "blessing",
        full_name: r#"SQLite Blessing"#,
        index: 648,
        flags: 0x0,
    },
    License {
        name: "bzip2-1.0.5",
        full_name: r#"bzip2 and libbzip2 License v1.0.5"#,
        index: 649,
        flags: IS_DEPRECATED,
    },
    License {
        name: "bzip2-1.0.6",
        full_name: r#"bzip2 and libbzip2 License v1.0.6"#,
        index: 650,
        flags: 0x0,
    },
    License {
        name: "check-cvs",
        full_name: r#"check-cvs License"#,
        index: 651,
        flags: 0x0,
    },
    License {
        name: "checkmk",
        full_name: r#"Checkmk License"#,
        index: 652,
        flags: 0x0,
    },
    License {
        name: "copyleft-next-0.3.0",
        full_name: r#"copyleft-next 0.3.0"#,
        index: 653,
        flags: 0x0,
    },
    License {
        name: "copyleft-next-0.3.1",
        full_name: r#"copyleft-next 0.3.1"#,
        index: 654,
        flags: 0x0,
    },
    License {
        name: "curl",
        full_name: r#"curl License"#,
        index: 655,
        flags: 0x0,
    },
    License {
        name: "cve-tou",
        full_name: r#"Common Vulnerability Enumeration ToU License"#,
        index: 656,
        flags: 0x0,
    },
    License {
        name: "diffmark",
        full_name: r#"diffmark license"#,
        index: 657,
        flags: 0x0,
    },
    License {
        name: "dtoa",
        full_name: r#"David M. Gay dtoa License"#,
        index: 658,
        flags: 0x0,
    },
    License {
        name: "dvipdfm",
        full_name: r#"dvipdfm License"#,
        index: 659,
        flags: 0x0,
    },
    License {
        name: "eCos-2.0",
        full_name: r#"eCos license version 2.0"#,
        index: 660,
        flags: IS_DEPRECATED | IS_FSF_LIBRE,
    },
    License {
        name: "eGenix",
        full_name: r#"eGenix.com Public License 1.1.0"#,
        index: 661,
        flags: 0x0,
    },
    License {
        name: "etalab-2.0",
        full_name: r#"Etalab Open License 2.0"#,
        index: 662,
        flags: 0x0,
    },
    License {
        name: "fwlw",
        full_name: r#"fwlw License"#,
        index: 663,
        flags: 0x0,
    },
    License {
        name: "gSOAP-1.3b",
        full_name: r#"gSOAP Public License v1.3b"#,
        index: 664,
        flags: 0x0,
    },
    License {
        name: "generic-xts",
        full_name: r#"Generic XTS License"#,
        index: 665,
        flags: 0x0,
    },
    License {
        name: "gnuplot",
        full_name: r#"gnuplot License"#,
        index: 666,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "gtkbook",
        full_name: r#"gtkbook License"#,
        index: 667,
        flags: 0x0,
    },
    License {
        name: "hdparm",
        full_name: r#"hdparm License"#,
        index: 668,
        flags: 0x0,
    },
    License {
        name: "iMatix",
        full_name: r#"iMatix Standard Function Library Agreement"#,
        index: 669,
        flags: IS_FSF_LIBRE,
    },
    License {
        name: "jove",
        full_name: r#"Jove License"#,
        index: 670,
        flags: 0x0,
    },
    License {
        name: "libpng-1.6.35",
        full_name: r#"PNG Reference Library License v1 (for libpng 0.5 through 1.6.35)"#,
        index: 671,
        flags: 0x0,
    },
    License {
        name: "libpng-2.0",
        full_name: r#"PNG Reference Library version 2"#,
        index: 672,
        flags: 0x0,
    },
    License {
        name: "libselinux-1.0",
        full_name: r#"libselinux public domain notice"#,
        index: 673,
        flags: 0x0,
    },
    License {
        name: "libtiff",
        full_name: r#"libtiff License"#,
        index: 674,
        flags: 0x0,
    },
    License {
        name: "libutil-David-Nugent",
        full_name: r#"libutil David Nugent License"#,
        index: 675,
        flags: 0x0,
    },
    License {
        name: "lsof",
        full_name: r#"lsof License"#,
        index: 676,
        flags: 0x0,
    },
    License {
        name: "magaz",
        full_name: r#"magaz License"#,
        index: 677,
        flags: 0x0,
    },
    License {
        name: "mailprio",
        full_name: r#"mailprio License"#,
        index: 678,
        flags: 0x0,
    },
    License {
        name: "man2html",
        full_name: r#"man2html License"#,
        index: 679,
        flags: 0x0,
    },
    License {
        name: "metamail",
        full_name: r#"metamail License"#,
        index: 680,
        flags: 0x0,
    },
    License {
        name: "mpi-permissive",
        full_name: r#"mpi Permissive License"#,
        index: 681,
        flags: 0x0,
    },
    License {
        name: "mpich2",
        full_name: r#"mpich2 License"#,
        index: 682,
        flags: 0x0,
    },
    License {
        name: "mplus",
        full_name: r#"mplus Font License"#,
        index: 683,
        flags: 0x0,
    },
    License {
        name: "ngrep",
        full_name: r#"ngrep License"#,
        index: 684,
        flags: 0x0,
    },
    License {
        name: "pkgconf",
        full_name: r#"pkgconf License"#,
        index: 685,
        flags: 0x0,
    },
    License {
        name: "pnmstitch",
        full_name: r#"pnmstitch License"#,
        index: 686,
        flags: 0x0,
    },
    License {
        name: "psfrag",
        full_name: r#"psfrag License"#,
        index: 687,
        flags: 0x0,
    },
    License {
        name: "psutils",
        full_name: r#"psutils License"#,
        index: 688,
        flags: 0x0,
    },
    License {
        name: "python-ldap",
        full_name: r#"Python ldap License"#,
        index: 689,
        flags: 0x0,
    },
    License {
        name: "radvd",
        full_name: r#"radvd License"#,
        index: 690,
        flags: 0x0,
    },
    License {
        name: "snprintf",
        full_name: r#"snprintf License"#,
        index: 691,
        flags: 0x0,
    },
    License {
        name: "softSurfer",
        full_name: r#"softSurfer License"#,
        index: 692,
        flags: 0x0,
    },
    License {
        name: "ssh-keyscan",
        full_name: r#"ssh-keyscan License"#,
        index: 693,
        flags: 0x0,
    },
    License {
        name: "swrule",
        full_name: r#"swrule License"#,
        index: 694,
        flags: 0x0,
    },
    License {
        name: "threeparttable",
        full_name: r#"threeparttable License"#,
        index: 695,
        flags: 0x0,
    },
    License {
        name: "ulem",
        full_name: r#"ulem License"#,
        index: 696,
        flags: 0x0,
    },
    License {
        name: "w3m",
        full_name: r#"w3m License"#,
        index: 697,
        flags: 0x0,
    },
    License {
        name: "wwl",
        full_name: r#"WWL License"#,
        index: 698,
        flags: 0x0,
    },
    License {
        name: "wxWindows",
        full_name: r#"wxWindows Library License"#,
        index: 699,
        flags: IS_DEPRECATED | IS_OSI_APPROVED,
    },
    License {
        name: "xinetd",
        full_name: r#"xinetd License"#,
        index: 700,
        flags: IS_FSF_LIBRE | IS_COPYLEFT,
    },
    License {
        name: "xkeyboard-config-Zinoviev",
        full_name: r#"xkeyboard-config Zinoviev License"#,
        index: 701,
        flags: 0x0,
    },
    License {
        name: "xlock",
        full_name: r#"xlock License"#,
        index: 702,
        flags: 0x0,
    },
    License {
        name: "xpp",
        full_name: r#"XPP License"#,
        index: 703,
        flags: 0x0,
    },
    License {
        name: "xzoom",
        full_name: r#"xzoom License"#,
        index: 704,
        flags: 0x0,
    },
    License {
        name: "zlib-acknowledgement",
        full_name: r#"zlib/libpng License with Acknowledgement"#,
        index: 705,
        flags: 0x0,
    },
];

/// Pairs an invalid license identifier with its valid SPDX license identifier.
/// These invalid identifiers are only allowed when using `Lax` parsing.
pub const IMPRECISE_NAMES: &[(&str, &str)] = &[
    ("agplv3", "AGPL-3.0"),
    ("agpl", "AGPL-3.0"),
    ("apache 2.0", "Apache-2.0"),
    ("apache-2", "Apache-2.0"),
    ("apache2", "Apache-2.0"),
    ("apache", "Apache-2.0"),
    ("asl2.0", "Apache-2.0"),
    ("bsd 2-clause", "BSD-2-Clause"),
    ("bsd-2clause", "BSD-2-Clause"),
    ("bsd3", "BSD-3-Clause"),
    ("bsd", "BSD-2-Clause"),
    ("cc0", "CC0-1.0"),
    ("gnu gpl v2", "GPL-3.0-only"),
    ("gnu gpl v3", "GPL-3.0-only"),
    ("gpl v2", "GPL-2.0-only"),
    ("gpl v3", "GPL-3.0-only"),
    ("gpl-1.0", "GPL-1.0-only"),
    ("gpl-2.0", "GPL-2.0-only"),
    ("gpl-3.0", "GPL-3.0-only"),
    ("gpl2", "GPL-2.0-only"),
    ("gpl3", "GPL-3.0-only"),
    ("gplv2", "GPL-2.0-only"),
    ("gplv3", "GPL-3.0-only"),
    ("gpl", "GPL-2.0-only"),
    ("lgpl", "LGPL-2.0-only"),
    ("GPL-1.0", "GPL-1.0-only"),
    ("GPL-2.0", "GPL-2.0-only"),
    ("GPL-3.0", "GPL-3.0-only"),
    ("mit", "MIT"),
    ("mpl2", "MPL-2.0"),
    ("mpl", "MPL-2.0"),
    ("simplified bsd license", "BSD-2-Clause"),
    ("zlib", "Zlib"),
];

pub const EXCEPTIONS: &[Exception] = &[
    Exception {
        name: "389-exception",
        index: 0,
        flags: 0,
    },
    Exception {
        name: "Asterisk-exception",
        index: 1,
        flags: 0,
    },
    Exception {
        name: "Asterisk-linking-protocols-exception",
        index: 2,
        flags: 0,
    },
    Exception {
        name: "Autoconf-exception-2.0",
        index: 3,
        flags: 0,
    },
    Exception {
        name: "Autoconf-exception-3.0",
        index: 4,
        flags: 0,
    },
    Exception {
        name: "Autoconf-exception-generic",
        index: 5,
        flags: 0,
    },
    Exception {
        name: "Autoconf-exception-generic-3.0",
        index: 6,
        flags: 0,
    },
    Exception {
        name: "Autoconf-exception-macro",
        index: 7,
        flags: 0,
    },
    Exception {
        name: "Bison-exception-1.24",
        index: 8,
        flags: 0,
    },
    Exception {
        name: "Bison-exception-2.2",
        index: 9,
        flags: 0,
    },
    Exception {
        name: "Bootloader-exception",
        index: 10,
        flags: 0,
    },
    Exception {
        name: "CGAL-linking-exception",
        index: 11,
        flags: 0,
    },
    Exception {
        name: "CLISP-exception-2.0",
        index: 12,
        flags: 0,
    },
    Exception {
        name: "Classpath-exception-2.0",
        index: 13,
        flags: 0,
    },
    Exception {
        name: "DigiRule-FOSS-exception",
        index: 14,
        flags: 0,
    },
    Exception {
        name: "Digia-Qt-LGPL-exception-1.1",
        index: 15,
        flags: 0,
    },
    Exception {
        name: "FLTK-exception",
        index: 16,
        flags: 0,
    },
    Exception {
        name: "Fawkes-Runtime-exception",
        index: 17,
        flags: 0,
    },
    Exception {
        name: "Font-exception-2.0",
        index: 18,
        flags: 0,
    },
    Exception {
        name: "GCC-exception-2.0",
        index: 19,
        flags: 0,
    },
    Exception {
        name: "GCC-exception-2.0-note",
        index: 20,
        flags: 0,
    },
    Exception {
        name: "GCC-exception-3.1",
        index: 21,
        flags: 0,
    },
    Exception {
        name: "GNAT-exception",
        index: 22,
        flags: 0,
    },
    Exception {
        name: "GNOME-examples-exception",
        index: 23,
        flags: 0,
    },
    Exception {
        name: "GNU-compiler-exception",
        index: 24,
        flags: 0,
    },
    Exception {
        name: "GPL-3.0-389-ds-base-exception",
        index: 25,
        flags: 0,
    },
    Exception {
        name: "GPL-3.0-interface-exception",
        index: 26,
        flags: 0,
    },
    Exception {
        name: "GPL-3.0-linking-exception",
        index: 27,
        flags: 0,
    },
    Exception {
        name: "GPL-3.0-linking-source-exception",
        index: 28,
        flags: 0,
    },
    Exception {
        name: "GPL-CC-1.0",
        index: 29,
        flags: 0,
    },
    Exception {
        name: "GStreamer-exception-2005",
        index: 30,
        flags: 0,
    },
    Exception {
        name: "GStreamer-exception-2008",
        index: 31,
        flags: 0,
    },
    Exception {
        name: "Gmsh-exception",
        index: 32,
        flags: 0,
    },
    Exception {
        name: "Independent-modules-exception",
        index: 33,
        flags: 0,
    },
    Exception {
        name: "KiCad-libraries-exception",
        index: 34,
        flags: 0,
    },
    Exception {
        name: "LGPL-3.0-linking-exception",
        index: 35,
        flags: 0,
    },
    Exception {
        name: "LLGPL",
        index: 36,
        flags: 0,
    },
    Exception {
        name: "LLVM-exception",
        index: 37,
        flags: 0,
    },
    Exception {
        name: "LZMA-exception",
        index: 38,
        flags: 0,
    },
    Exception {
        name: "Libtool-exception",
        index: 39,
        flags: 0,
    },
    Exception {
        name: "Linux-syscall-note",
        index: 40,
        flags: 0,
    },
    Exception {
        name: "Nokia-Qt-exception-1.1",
        index: 41,
        flags: IS_DEPRECATED,
    },
    Exception {
        name: "OCCT-exception-1.0",
        index: 42,
        flags: 0,
    },
    Exception {
        name: "OCaml-LGPL-linking-exception",
        index: 43,
        flags: 0,
    },
    Exception {
        name: "OpenJDK-assembly-exception-1.0",
        index: 44,
        flags: 0,
    },
    Exception {
        name: "PCRE2-exception",
        index: 45,
        flags: 0,
    },
    Exception {
        name: "PS-or-PDF-font-exception-20170817",
        index: 46,
        flags: 0,
    },
    Exception {
        name: "QPL-1.0-INRIA-2004-exception",
        index: 47,
        flags: 0,
    },
    Exception {
        name: "Qt-GPL-exception-1.0",
        index: 48,
        flags: 0,
    },
    Exception {
        name: "Qt-LGPL-exception-1.1",
        index: 49,
        flags: 0,
    },
    Exception {
        name: "Qwt-exception-1.0",
        index: 50,
        flags: 0,
    },
    Exception {
        name: "RRDtool-FLOSS-exception-2.0",
        index: 51,
        flags: 0,
    },
    Exception {
        name: "SANE-exception",
        index: 52,
        flags: 0,
    },
    Exception {
        name: "SHL-2.0",
        index: 53,
        flags: 0,
    },
    Exception {
        name: "SHL-2.1",
        index: 54,
        flags: 0,
    },
    Exception {
        name: "SWI-exception",
        index: 55,
        flags: 0,
    },
    Exception {
        name: "Swift-exception",
        index: 56,
        flags: 0,
    },
    Exception {
        name: "Texinfo-exception",
        index: 57,
        flags: 0,
    },
    Exception {
        name: "UBDL-exception",
        index: 58,
        flags: 0,
    },
    Exception {
        name: "Universal-FOSS-exception-1.0",
        index: 59,
        flags: 0,
    },
    Exception {
        name: "WxWindows-exception-3.1",
        index: 60,
        flags: 0,
    },
    Exception {
        name: "cryptsetup-OpenSSL-exception",
        index: 61,
        flags: 0,
    },
    Exception {
        name: "eCos-exception-2.0",
        index: 62,
        flags: 0,
    },
    Exception {
        name: "erlang-otp-linking-exception",
        index: 63,
        flags: 0,
    },
    Exception {
        name: "fmt-exception",
        index: 64,
        flags: 0,
    },
    Exception {
        name: "freertos-exception-2.0",
        index: 65,
        flags: 0,
    },
    Exception {
        name: "gnu-javamail-exception",
        index: 66,
        flags: 0,
    },
    Exception {
        name: "harbour-exception",
        index: 67,
        flags: 0,
    },
    Exception {
        name: "i2p-gpl-java-exception",
        index: 68,
        flags: 0,
    },
    Exception {
        name: "libpri-OpenH323-exception",
        index: 69,
        flags: 0,
    },
    Exception {
        name: "mif-exception",
        index: 70,
        flags: 0,
    },
    Exception {
        name: "mxml-exception",
        index: 71,
        flags: 0,
    },
    Exception {
        name: "openvpn-openssl-exception",
        index: 72,
        flags: 0,
    },
    Exception {
        name: "polyparse-exception",
        index: 73,
        flags: 0,
    },
    Exception {
        name: "romic-exception",
        index: 74,
        flags: 0,
    },
    Exception {
        name: "stunnel-exception",
        index: 75,
        flags: 0,
    },
    Exception {
        name: "u-boot-exception-2.0",
        index: 76,
        flags: 0,
    },
    Exception {
        name: "vsftpd-openssl-exception",
        index: 77,
        flags: 0,
    },
    Exception {
        name: "x11vnc-openssl-exception",
        index: 78,
        flags: 0,
    },
];
