//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"io"
	"time"
)

// DirectoryClientCreateResponse contains the response from method DirectoryClient.Create.
type DirectoryClientCreateResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// NFSFileType contains the information returned from the x-ms-file-file-type header response.
	NFSFileType *NFSFileType

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientDeleteResponse contains the response from method DirectoryClient.Delete.
type DirectoryClientDeleteResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientForceCloseHandlesResponse contains the response from method DirectoryClient.ForceCloseHandles.
type DirectoryClientForceCloseHandlesResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// Marker contains the information returned from the x-ms-marker header response.
	Marker *string

	// NumberOfHandlesClosed contains the information returned from the x-ms-number-of-handles-closed header response.
	NumberOfHandlesClosed *int32

	// NumberOfHandlesFailedToClose contains the information returned from the x-ms-number-of-handles-failed header response.
	NumberOfHandlesFailedToClose *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientGetPropertiesResponse contains the response from method DirectoryClient.GetProperties.
type DirectoryClientGetPropertiesResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]*string

	// NFSFileType contains the information returned from the x-ms-file-file-type header response.
	NFSFileType *NFSFileType

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientListFilesAndDirectoriesSegmentResponse contains the response from method DirectoryClient.NewListFilesAndDirectoriesSegmentPager.
type DirectoryClientListFilesAndDirectoriesSegmentResponse struct {
	// An enumeration of directories and files.
	ListFilesAndDirectoriesSegmentResponse

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientListHandlesResponse contains the response from method DirectoryClient.ListHandles.
type DirectoryClientListHandlesResponse struct {
	// An enumeration of handles.
	ListHandlesResponse

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientRenameResponse contains the response from method DirectoryClient.Rename.
type DirectoryClientRenameResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientSetMetadataResponse contains the response from method DirectoryClient.SetMetadata.
type DirectoryClientSetMetadataResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryClientSetPropertiesResponse contains the response from method DirectoryClient.SetProperties.
type DirectoryClientSetPropertiesResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientAbortCopyResponse contains the response from method FileClient.AbortCopy.
type FileClientAbortCopyResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientAcquireLeaseResponse contains the response from method FileClient.AcquireLease.
type FileClientAcquireLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientBreakLeaseResponse contains the response from method FileClient.BreakLease.
type FileClientBreakLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientChangeLeaseResponse contains the response from method FileClient.ChangeLease.
type FileClientChangeLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientCreateHardLinkResponse contains the response from method FileClient.CreateHardLink.
type FileClientCreateHardLinkResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LinkCount contains the information returned from the x-ms-link-count header response.
	LinkCount *int64

	// NFSFileType contains the information returned from the x-ms-file-file-type header response.
	NFSFileType *NFSFileType

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientCreateResponse contains the response from method FileClient.Create.
type FileClientCreateResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// NFSFileType contains the information returned from the x-ms-file-file-type header response.
	NFSFileType *NFSFileType

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientCreateSymbolicLinkResponse contains the response from method FileClient.CreateSymbolicLink.
type FileClientCreateSymbolicLinkResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// NFSFileType contains the information returned from the x-ms-file-file-type header response.
	NFSFileType *NFSFileType

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientDeleteResponse contains the response from method FileClient.Delete.
type FileClientDeleteResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// LinkCount contains the information returned from the x-ms-link-count header response.
	LinkCount *int64

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientDownloadResponse contains the response from method FileClient.Download.
type FileClientDownloadResponse struct {
	// AcceptRanges contains the information returned from the Accept-Ranges header response.
	AcceptRanges *string

	// Body contains the streaming response.
	Body io.ReadCloser

	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentRange contains the information returned from the Content-Range header response.
	ContentRange *string

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileContentMD5 contains the information returned from the x-ms-content-md5 header response.
	FileContentMD5 []byte

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// LinkCount contains the information returned from the x-ms-link-count header response.
	LinkCount *int64

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]*string

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// StructuredBodyType contains the information returned from the x-ms-structured-body header response.
	StructuredBodyType *string

	// StructuredContentLength contains the information returned from the x-ms-structured-content-length header response.
	StructuredContentLength *int64

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientForceCloseHandlesResponse contains the response from method FileClient.ForceCloseHandles.
type FileClientForceCloseHandlesResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// Marker contains the information returned from the x-ms-marker header response.
	Marker *string

	// NumberOfHandlesClosed contains the information returned from the x-ms-number-of-handles-closed header response.
	NumberOfHandlesClosed *int32

	// NumberOfHandlesFailedToClose contains the information returned from the x-ms-number-of-handles-failed header response.
	NumberOfHandlesFailedToClose *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientGetPropertiesResponse contains the response from method FileClient.GetProperties.
type FileClientGetPropertiesResponse struct {
	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// FileType contains the information returned from the x-ms-type header response.
	FileType *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// LinkCount contains the information returned from the x-ms-link-count header response.
	LinkCount *int64

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]*string

	// NFSFileType contains the information returned from the x-ms-file-file-type header response.
	NFSFileType *NFSFileType

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientGetRangeListResponse contains the response from method FileClient.GetRangeList.
type FileClientGetRangeListResponse struct {
	// The list of file ranges
	ShareFileRangeList

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileContentLength contains the information returned from the x-ms-content-length header response.
	FileContentLength *int64

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientGetSymbolicLinkResponse contains the response from method FileClient.GetSymbolicLink.
type FileClientGetSymbolicLinkResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LinkText contains the information returned from the x-ms-link-text header response.
	LinkText *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientListHandlesResponse contains the response from method FileClient.ListHandles.
type FileClientListHandlesResponse struct {
	// An enumeration of handles.
	ListHandlesResponse

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientReleaseLeaseResponse contains the response from method FileClient.ReleaseLease.
type FileClientReleaseLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientRenameResponse contains the response from method FileClient.Rename.
type FileClientRenameResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientSetHTTPHeadersResponse contains the response from method FileClient.SetHTTPHeaders.
type FileClientSetHTTPHeadersResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileAttributes contains the information returned from the x-ms-file-attributes header response.
	FileAttributes *string

	// FileChangeTime contains the information returned from the x-ms-file-change-time header response.
	FileChangeTime *time.Time

	// FileCreationTime contains the information returned from the x-ms-file-creation-time header response.
	FileCreationTime *time.Time

	// ID contains the information returned from the x-ms-file-id header response.
	ID *string

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// FileMode contains the information returned from the x-ms-mode header response.
	FileMode *string

	// ParentID contains the information returned from the x-ms-file-parent-id header response.
	ParentID *string

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// Group contains the information returned from the x-ms-group header response.
	Group *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LinkCount contains the information returned from the x-ms-link-count header response.
	LinkCount *int64

	// Owner contains the information returned from the x-ms-owner header response.
	Owner *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientSetMetadataResponse contains the response from method FileClient.SetMetadata.
type FileClientSetMetadataResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientStartCopyResponse contains the response from method FileClient.StartCopy.
type FileClientStartCopyResponse struct {
	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// FileClientUploadRangeFromURLResponse contains the response from method FileClient.UploadRangeFromURL.
type FileClientUploadRangeFromURLResponse struct {
	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// FileClientUploadRangeResponse contains the response from method FileClient.UploadRange.
type FileClientUploadRangeResponse struct {
	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// FileLastWriteTime contains the information returned from the x-ms-file-last-write-time header response.
	FileLastWriteTime *time.Time

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// StructuredBodyType contains the information returned from the x-ms-structured-body header response.
	StructuredBodyType *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ServiceClientGetPropertiesResponse contains the response from method ServiceClient.GetProperties.
type ServiceClientGetPropertiesResponse struct {
	// Storage service properties.
	StorageServiceProperties

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ServiceClientListSharesSegmentResponse contains the response from method ServiceClient.NewListSharesSegmentPager.
type ServiceClientListSharesSegmentResponse struct {
	// An enumeration of shares.
	ListSharesResponse

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ServiceClientSetPropertiesResponse contains the response from method ServiceClient.SetProperties.
type ServiceClientSetPropertiesResponse struct {
	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientAcquireLeaseResponse contains the response from method ShareClient.AcquireLease.
type ShareClientAcquireLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientBreakLeaseResponse contains the response from method ShareClient.BreakLease.
type ShareClientBreakLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// LeaseTime contains the information returned from the x-ms-lease-time header response.
	LeaseTime *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientChangeLeaseResponse contains the response from method ShareClient.ChangeLease.
type ShareClientChangeLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientCreatePermissionResponse contains the response from method ShareClient.CreatePermission.
type ShareClientCreatePermissionResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// FilePermissionKey contains the information returned from the x-ms-file-permission-key header response.
	FilePermissionKey *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientCreateResponse contains the response from method ShareClient.Create.
type ShareClientCreateResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// MaxBurstCreditsForIops contains the information returned from the x-ms-share-max-burst-credits-for-iops header response.
	MaxBurstCreditsForIops *int64

	// Quota contains the information returned from the x-ms-share-quota header response.
	Quota *int64

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// ShareIncludedBurstIops contains the information returned from the x-ms-share-included-burst-iops header response.
	ShareIncludedBurstIops *int64

	// ShareProvisionedBandwidthMibps contains the information returned from the x-ms-share-provisioned-bandwidth-mibps header
	// response.
	ShareProvisionedBandwidthMibps *int64

	// ShareProvisionedIops contains the information returned from the x-ms-share-provisioned-iops header response.
	ShareProvisionedIops *int64

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientCreateSnapshotResponse contains the response from method ShareClient.CreateSnapshot.
type ShareClientCreateSnapshotResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Snapshot contains the information returned from the x-ms-snapshot header response.
	Snapshot *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientDeleteResponse contains the response from method ShareClient.Delete.
type ShareClientDeleteResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// FileShareSnapshotUsageBytes contains the information returned from the x-ms-file-share-snapshot-usage-bytes header response.
	FileShareSnapshotUsageBytes *int64

	// FileShareUsageBytes contains the information returned from the x-ms-file-share-usage-bytes header response.
	FileShareUsageBytes *int64
}

// ShareClientGetAccessPolicyResponse contains the response from method ShareClient.GetAccessPolicy.
type ShareClientGetAccessPolicyResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// A collection of signed identifiers.
	SignedIdentifiers []*SignedIdentifier `xml:"SignedIdentifier"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientGetPermissionResponse contains the response from method ShareClient.GetPermission.
type ShareClientGetPermissionResponse struct {
	// A permission (a security descriptor) at the share level.
	SharePermission

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientGetPropertiesResponse contains the response from method ShareClient.GetProperties.
type ShareClientGetPropertiesResponse struct {
	// AccessTier contains the information returned from the x-ms-access-tier header response.
	AccessTier *string

	// AccessTierChangeTime contains the information returned from the x-ms-access-tier-change-time header response.
	AccessTierChangeTime *time.Time

	// AccessTierTransitionState contains the information returned from the x-ms-access-tier-transition-state header response.
	AccessTierTransitionState *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// EnableSnapshotVirtualDirectoryAccess contains the information returned from the x-ms-enable-snapshot-virtual-directory-access
	// header response.
	EnableSnapshotVirtualDirectoryAccess *bool

	// EnabledProtocols contains the information returned from the x-ms-enabled-protocols header response.
	EnabledProtocols *string

	// IncludedBurstIops contains the information returned from the x-ms-share-included-burst-iops header response.
	IncludedBurstIops *int64

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// MaxBurstCreditsForIops contains the information returned from the x-ms-share-max-burst-credits-for-iops header response.
	MaxBurstCreditsForIops *int64

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]*string

	// NextAllowedProvisionedBandwidthDowngradeTime contains the information returned from the x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time
	// header response.
	NextAllowedProvisionedBandwidthDowngradeTime *time.Time

	// NextAllowedProvisionedIopsDowngradeTime contains the information returned from the x-ms-share-next-allowed-provisioned-iops-downgrade-time
	// header response.
	NextAllowedProvisionedIopsDowngradeTime *time.Time

	// NextAllowedQuotaDowngradeTime contains the information returned from the x-ms-share-next-allowed-quota-downgrade-time header
	// response.
	NextAllowedQuotaDowngradeTime *time.Time

	// PaidBurstingEnabled contains the information returned from the x-ms-share-paid-bursting-enabled header response.
	PaidBurstingEnabled *bool

	// PaidBurstingMaxBandwidthMibps contains the information returned from the x-ms-share-paid-bursting-max-bandwidth-mibps header
	// response.
	PaidBurstingMaxBandwidthMibps *int64

	// PaidBurstingMaxIops contains the information returned from the x-ms-share-paid-bursting-max-iops header response.
	PaidBurstingMaxIops *int64

	// ProvisionedBandwidthMiBps contains the information returned from the x-ms-share-provisioned-bandwidth-mibps header response.
	ProvisionedBandwidthMiBps *int32

	// ProvisionedEgressMBps contains the information returned from the x-ms-share-provisioned-egress-mbps header response.
	ProvisionedEgressMBps *int32

	// ProvisionedIngressMBps contains the information returned from the x-ms-share-provisioned-ingress-mbps header response.
	ProvisionedIngressMBps *int32

	// ProvisionedIops contains the information returned from the x-ms-share-provisioned-iops header response.
	ProvisionedIops *int32

	// Quota contains the information returned from the x-ms-share-quota header response.
	Quota *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// RootSquash contains the information returned from the x-ms-root-squash header response.
	RootSquash *ShareRootSquash

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientGetStatisticsResponse contains the response from method ShareClient.GetStatistics.
type ShareClientGetStatisticsResponse struct {
	// Stats for the share.
	ShareStats

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientReleaseLeaseResponse contains the response from method ShareClient.ReleaseLease.
type ShareClientReleaseLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientRenewLeaseResponse contains the response from method ShareClient.RenewLease.
type ShareClientRenewLeaseResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientRestoreResponse contains the response from method ShareClient.Restore.
type ShareClientRestoreResponse struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// IncludedBurstIops contains the information returned from the x-ms-share-included-burst-iops header response.
	IncludedBurstIops *int64

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// MaxBurstCreditsForIops contains the information returned from the x-ms-share-max-burst-credits-for-iops header response.
	MaxBurstCreditsForIops *int64

	// ProvisionedBandwidthMibps contains the information returned from the x-ms-share-provisioned-bandwidth-mibps header response.
	ProvisionedBandwidthMibps *int64

	// ProvisionedIops contains the information returned from the x-ms-share-provisioned-iops header response.
	ProvisionedIops *int64

	// Quota contains the information returned from the x-ms-share-quota header response.
	Quota *int64

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientSetAccessPolicyResponse contains the response from method ShareClient.SetAccessPolicy.
type ShareClientSetAccessPolicyResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientSetMetadataResponse contains the response from method ShareClient.SetMetadata.
type ShareClientSetMetadataResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ShareClientSetPropertiesResponse contains the response from method ShareClient.SetProperties.
type ShareClientSetPropertiesResponse struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *azcore.ETag

	// IncludedBurstIops contains the information returned from the x-ms-share-included-burst-iops header response.
	IncludedBurstIops *int64

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// MaxBurstCreditsForIops contains the information returned from the x-ms-share-max-burst-credits-for-iops header response.
	MaxBurstCreditsForIops *int64

	// NextAllowedProvisionedBandwidthDowngradeTime contains the information returned from the x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time
	// header response.
	NextAllowedProvisionedBandwidthDowngradeTime *time.Time

	// NextAllowedProvisionedIopsDowngradeTime contains the information returned from the x-ms-share-next-allowed-provisioned-iops-downgrade-time
	// header response.
	NextAllowedProvisionedIopsDowngradeTime *time.Time

	// NextAllowedQuotaDowngradeTime contains the information returned from the x-ms-share-next-allowed-quota-downgrade-time header
	// response.
	NextAllowedQuotaDowngradeTime *time.Time

	// ProvisionedBandwidthMibps contains the information returned from the x-ms-share-provisioned-bandwidth-mibps header response.
	ProvisionedBandwidthMibps *int64

	// ProvisionedIops contains the information returned from the x-ms-share-provisioned-iops header response.
	ProvisionedIops *int64

	// Quota contains the information returned from the x-ms-share-quota header response.
	Quota *int64

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}
