/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Comparator;
import java.util.Objects;

public interface ChronoZonedDateTime<D extends ChronoLocalDate>
extends Temporal,
Comparable<ChronoZonedDateTime<?>> {
    public static Comparator<ChronoZonedDateTime<?>> timeLineOrder() {
        return AbstractChronology.INSTANT_ORDER;
    }

    public static ChronoZonedDateTime<?> from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof ChronoZonedDateTime) {
            return (ChronoZonedDateTime)temporalAccessor;
        }
        Objects.requireNonNull(temporalAccessor, "temporal");
        Chronology chronology = temporalAccessor.query(TemporalQueries.chronology());
        if (chronology == null) {
            throw new DateTimeException("Unable to obtain ChronoZonedDateTime from TemporalAccessor: " + temporalAccessor.getClass());
        }
        return chronology.zonedDateTime(temporalAccessor);
    }

    @Override
    default public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.toLocalDateTime().range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    default public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    throw new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.toLocalDateTime().get(temporalField);
        }
        return Temporal.super.get(temporalField);
    }

    @Override
    default public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.toLocalDateTime().getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    default public D toLocalDate() {
        return this.toLocalDateTime().toLocalDate();
    }

    default public LocalTime toLocalTime() {
        return this.toLocalDateTime().toLocalTime();
    }

    public ChronoLocalDateTime<D> toLocalDateTime();

    default public Chronology getChronology() {
        return this.toLocalDate().getChronology();
    }

    public ZoneOffset getOffset();

    public ZoneId getZone();

    public ChronoZonedDateTime<D> withEarlierOffsetAtOverlap();

    public ChronoZonedDateTime<D> withLaterOffsetAtOverlap();

    public ChronoZonedDateTime<D> withZoneSameLocal(ZoneId var1);

    public ChronoZonedDateTime<D> withZoneSameInstant(ZoneId var1);

    @Override
    public boolean isSupported(TemporalField var1);

    @Override
    default public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit != ChronoUnit.FOREVER;
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    default public ChronoZonedDateTime<D> with(TemporalAdjuster temporalAdjuster) {
        return ChronoZonedDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.with(temporalAdjuster));
    }

    @Override
    public ChronoZonedDateTime<D> with(TemporalField var1, long var2);

    @Override
    default public ChronoZonedDateTime<D> plus(TemporalAmount temporalAmount) {
        return ChronoZonedDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.plus(temporalAmount));
    }

    @Override
    public ChronoZonedDateTime<D> plus(long var1, TemporalUnit var3);

    @Override
    default public ChronoZonedDateTime<D> minus(TemporalAmount temporalAmount) {
        return ChronoZonedDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.minus(temporalAmount));
    }

    @Override
    default public ChronoZonedDateTime<D> minus(long l, TemporalUnit temporalUnit) {
        return ChronoZonedDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.minus(l, temporalUnit));
    }

    @Override
    default public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.zoneId()) {
            return (R)this.getZone();
        }
        if (temporalQuery == TemporalQueries.offset()) {
            return (R)this.getOffset();
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)this.getChronology();
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return temporalQuery.queryFrom(this);
    }

    default public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    default public Instant toInstant() {
        return Instant.ofEpochSecond(this.toEpochSecond(), this.toLocalTime().getNano());
    }

    default public long toEpochSecond() {
        long l = this.toLocalDate().toEpochDay();
        long l2 = l * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return l2 -= (long)this.getOffset().getTotalSeconds();
    }

    @Override
    default public int compareTo(ChronoZonedDateTime<?> chronoZonedDateTime) {
        int n = Long.compare(this.toEpochSecond(), chronoZonedDateTime.toEpochSecond());
        if (n == 0 && (n = this.toLocalTime().getNano() - chronoZonedDateTime.toLocalTime().getNano()) == 0 && (n = this.toLocalDateTime().compareTo(chronoZonedDateTime.toLocalDateTime())) == 0 && (n = this.getZone().getId().compareTo(chronoZonedDateTime.getZone().getId())) == 0) {
            n = this.getChronology().compareTo(chronoZonedDateTime.getChronology());
        }
        return n;
    }

    default public boolean isBefore(ChronoZonedDateTime<?> chronoZonedDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 < (l = chronoZonedDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() < chronoZonedDateTime.toLocalTime().getNano();
    }

    default public boolean isAfter(ChronoZonedDateTime<?> chronoZonedDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 > (l = chronoZonedDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() > chronoZonedDateTime.toLocalTime().getNano();
    }

    default public boolean isEqual(ChronoZonedDateTime<?> chronoZonedDateTime) {
        return this.toEpochSecond() == chronoZonedDateTime.toEpochSecond() && this.toLocalTime().getNano() == chronoZonedDateTime.toLocalTime().getNano();
    }

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

