//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollersourcetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImagePickerControllerSourceType(pub NSInteger);
impl UIImagePickerControllerSourceType {
    #[doc(alias = "UIImagePickerControllerSourceTypePhotoLibrary")]
    #[deprecated = "Will be removed in a future release, use PHPicker."]
    pub const PhotoLibrary: Self = Self(0);
    #[doc(alias = "UIImagePickerControllerSourceTypeCamera")]
    pub const Camera: Self = Self(1);
    #[doc(alias = "UIImagePickerControllerSourceTypeSavedPhotosAlbum")]
    #[deprecated = "Will be removed in a future release, use PHPicker."]
    pub const SavedPhotosAlbum: Self = Self(2);
}

unsafe impl Encode for UIImagePickerControllerSourceType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImagePickerControllerSourceType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerqualitytype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImagePickerControllerQualityType(pub NSInteger);
impl UIImagePickerControllerQualityType {
    #[doc(alias = "UIImagePickerControllerQualityTypeHigh")]
    pub const TypeHigh: Self = Self(0);
    #[doc(alias = "UIImagePickerControllerQualityTypeMedium")]
    pub const TypeMedium: Self = Self(1);
    #[doc(alias = "UIImagePickerControllerQualityTypeLow")]
    pub const TypeLow: Self = Self(2);
    #[doc(alias = "UIImagePickerControllerQualityType640x480")]
    pub const Type640x480: Self = Self(3);
    #[doc(alias = "UIImagePickerControllerQualityTypeIFrame1280x720")]
    pub const TypeIFrame1280x720: Self = Self(4);
    #[doc(alias = "UIImagePickerControllerQualityTypeIFrame960x540")]
    pub const TypeIFrame960x540: Self = Self(5);
}

unsafe impl Encode for UIImagePickerControllerQualityType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImagePickerControllerQualityType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollercameracapturemode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImagePickerControllerCameraCaptureMode(pub NSInteger);
impl UIImagePickerControllerCameraCaptureMode {
    #[doc(alias = "UIImagePickerControllerCameraCaptureModePhoto")]
    pub const Photo: Self = Self(0);
    #[doc(alias = "UIImagePickerControllerCameraCaptureModeVideo")]
    pub const Video: Self = Self(1);
}

unsafe impl Encode for UIImagePickerControllerCameraCaptureMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImagePickerControllerCameraCaptureMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollercameradevice?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImagePickerControllerCameraDevice(pub NSInteger);
impl UIImagePickerControllerCameraDevice {
    #[doc(alias = "UIImagePickerControllerCameraDeviceRear")]
    pub const Rear: Self = Self(0);
    #[doc(alias = "UIImagePickerControllerCameraDeviceFront")]
    pub const Front: Self = Self(1);
}

unsafe impl Encode for UIImagePickerControllerCameraDevice {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImagePickerControllerCameraDevice {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollercameraflashmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImagePickerControllerCameraFlashMode(pub NSInteger);
impl UIImagePickerControllerCameraFlashMode {
    #[doc(alias = "UIImagePickerControllerCameraFlashModeOff")]
    pub const Off: Self = Self(-1);
    #[doc(alias = "UIImagePickerControllerCameraFlashModeAuto")]
    pub const Auto: Self = Self(0);
    #[doc(alias = "UIImagePickerControllerCameraFlashModeOn")]
    pub const On: Self = Self(1);
}

unsafe impl Encode for UIImagePickerControllerCameraFlashMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImagePickerControllerCameraFlashMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerimageurlexportpreset?language=objc)
// NS_ENUM
#[deprecated = "Will be removed in a future release, use PHPicker."]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImagePickerControllerImageURLExportPreset(pub NSInteger);
impl UIImagePickerControllerImageURLExportPreset {
    #[doc(alias = "UIImagePickerControllerImageURLExportPresetCompatible")]
    #[deprecated = "Will be removed in a future release, use PHPicker."]
    pub const Compatible: Self = Self(0);
    #[doc(alias = "UIImagePickerControllerImageURLExportPresetCurrent")]
    #[deprecated = "Will be removed in a future release, use PHPicker."]
    pub const Current: Self = Self(1);
}

unsafe impl Encode for UIImagePickerControllerImageURLExportPreset {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImagePickerControllerImageURLExportPreset {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerinfokey?language=objc)
// NS_TYPED_ENUM
pub type UIImagePickerControllerInfoKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollermediatype?language=objc)
    pub static UIImagePickerControllerMediaType: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrolleroriginalimage?language=objc)
    pub static UIImagePickerControllerOriginalImage: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollereditedimage?language=objc)
    pub static UIImagePickerControllerEditedImage: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollercroprect?language=objc)
    pub static UIImagePickerControllerCropRect: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollermediaurl?language=objc)
    pub static UIImagePickerControllerMediaURL: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerreferenceurl?language=objc)
    #[deprecated = "Will be removed in a future release, use PHPicker."]
    pub static UIImagePickerControllerReferenceURL: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollermediametadata?language=objc)
    pub static UIImagePickerControllerMediaMetadata: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerlivephoto?language=objc)
    pub static UIImagePickerControllerLivePhoto: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerphasset?language=objc)
    #[deprecated = "Will be removed in a future release, use PHPicker."]
    pub static UIImagePickerControllerPHAsset: &'static UIImagePickerControllerInfoKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerimageurl?language=objc)
    pub static UIImagePickerControllerImageURL: &'static UIImagePickerControllerInfoKey;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontroller?language=objc)
    #[unsafe(super(UINavigationController, UIViewController, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(
        feature = "UINavigationController",
        feature = "UIResponder",
        feature = "UIViewController"
    ))]
    pub struct UIImagePickerController;
);

#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl NSCoding for UIImagePickerController {}
);

#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIImagePickerController {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIImagePickerController {}
);

#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIContentContainer for UIImagePickerController {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIImagePickerController {}
);

#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIImagePickerController {}
);

#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIImagePickerController {}
);

#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
impl UIImagePickerController {
    extern_methods!(
        #[unsafe(method(isSourceTypeAvailable:))]
        #[unsafe(method_family = none)]
        pub fn isSourceTypeAvailable(
            source_type: UIImagePickerControllerSourceType,
            mtm: MainThreadMarker,
        ) -> bool;

        #[unsafe(method(availableMediaTypesForSourceType:))]
        #[unsafe(method_family = none)]
        pub fn availableMediaTypesForSourceType(
            source_type: UIImagePickerControllerSourceType,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSArray<NSString>>>;

        #[unsafe(method(isCameraDeviceAvailable:))]
        #[unsafe(method_family = none)]
        pub fn isCameraDeviceAvailable(
            camera_device: UIImagePickerControllerCameraDevice,
            mtm: MainThreadMarker,
        ) -> bool;

        #[unsafe(method(isFlashAvailableForCameraDevice:))]
        #[unsafe(method_family = none)]
        pub fn isFlashAvailableForCameraDevice(
            camera_device: UIImagePickerControllerCameraDevice,
            mtm: MainThreadMarker,
        ) -> bool;

        #[unsafe(method(availableCaptureModesForCameraDevice:))]
        #[unsafe(method_family = none)]
        pub fn availableCaptureModesForCameraDevice(
            camera_device: UIImagePickerControllerCameraDevice,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSArray<NSNumber>>>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(
            &self,
        ) -> Option<
            Retained<
                AnyObject, /* UINavigationControllerDelegate+ UIImagePickerControllerDelegate */
            >,
        >;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `delegate` should be of the correct type.
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<
                &AnyObject, /* UINavigationControllerDelegate+ UIImagePickerControllerDelegate */
            >,
        );

        #[unsafe(method(sourceType))]
        #[unsafe(method_family = none)]
        pub fn sourceType(&self) -> UIImagePickerControllerSourceType;

        /// Setter for [`sourceType`][Self::sourceType].
        #[unsafe(method(setSourceType:))]
        #[unsafe(method_family = none)]
        pub fn setSourceType(&self, source_type: UIImagePickerControllerSourceType);

        #[unsafe(method(mediaTypes))]
        #[unsafe(method_family = none)]
        pub fn mediaTypes(&self) -> Retained<NSArray<NSString>>;

        /// Setter for [`mediaTypes`][Self::mediaTypes].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setMediaTypes:))]
        #[unsafe(method_family = none)]
        pub fn setMediaTypes(&self, media_types: &NSArray<NSString>);

        #[unsafe(method(allowsEditing))]
        #[unsafe(method_family = none)]
        pub fn allowsEditing(&self) -> bool;

        /// Setter for [`allowsEditing`][Self::allowsEditing].
        #[unsafe(method(setAllowsEditing:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsEditing(&self, allows_editing: bool);

        #[deprecated]
        #[unsafe(method(allowsImageEditing))]
        #[unsafe(method_family = none)]
        pub fn allowsImageEditing(&self) -> bool;

        /// Setter for [`allowsImageEditing`][Self::allowsImageEditing].
        #[deprecated]
        #[unsafe(method(setAllowsImageEditing:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsImageEditing(&self, allows_image_editing: bool);

        #[deprecated = "Will be removed in a future release, use PHPicker."]
        #[unsafe(method(imageExportPreset))]
        #[unsafe(method_family = none)]
        pub fn imageExportPreset(&self) -> UIImagePickerControllerImageURLExportPreset;

        /// Setter for [`imageExportPreset`][Self::imageExportPreset].
        #[deprecated = "Will be removed in a future release, use PHPicker."]
        #[unsafe(method(setImageExportPreset:))]
        #[unsafe(method_family = none)]
        pub fn setImageExportPreset(
            &self,
            image_export_preset: UIImagePickerControllerImageURLExportPreset,
        );

        #[unsafe(method(videoMaximumDuration))]
        #[unsafe(method_family = none)]
        pub fn videoMaximumDuration(&self) -> NSTimeInterval;

        /// Setter for [`videoMaximumDuration`][Self::videoMaximumDuration].
        #[unsafe(method(setVideoMaximumDuration:))]
        #[unsafe(method_family = none)]
        pub fn setVideoMaximumDuration(&self, video_maximum_duration: NSTimeInterval);

        #[unsafe(method(videoQuality))]
        #[unsafe(method_family = none)]
        pub fn videoQuality(&self) -> UIImagePickerControllerQualityType;

        /// Setter for [`videoQuality`][Self::videoQuality].
        #[unsafe(method(setVideoQuality:))]
        #[unsafe(method_family = none)]
        pub fn setVideoQuality(&self, video_quality: UIImagePickerControllerQualityType);

        #[deprecated = "Will be removed in a future release, use PHPicker."]
        #[unsafe(method(videoExportPreset))]
        #[unsafe(method_family = none)]
        pub fn videoExportPreset(&self) -> Retained<NSString>;

        /// Setter for [`videoExportPreset`][Self::videoExportPreset].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "Will be removed in a future release, use PHPicker."]
        #[unsafe(method(setVideoExportPreset:))]
        #[unsafe(method_family = none)]
        pub fn setVideoExportPreset(&self, video_export_preset: &NSString);

        #[unsafe(method(showsCameraControls))]
        #[unsafe(method_family = none)]
        pub fn showsCameraControls(&self) -> bool;

        /// Setter for [`showsCameraControls`][Self::showsCameraControls].
        #[unsafe(method(setShowsCameraControls:))]
        #[unsafe(method_family = none)]
        pub fn setShowsCameraControls(&self, shows_camera_controls: bool);

        #[cfg(feature = "UIView")]
        #[unsafe(method(cameraOverlayView))]
        #[unsafe(method_family = none)]
        pub fn cameraOverlayView(&self) -> Option<Retained<UIView>>;

        #[cfg(feature = "UIView")]
        /// Setter for [`cameraOverlayView`][Self::cameraOverlayView].
        #[unsafe(method(setCameraOverlayView:))]
        #[unsafe(method_family = none)]
        pub fn setCameraOverlayView(&self, camera_overlay_view: Option<&UIView>);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(cameraViewTransform))]
        #[unsafe(method_family = none)]
        pub fn cameraViewTransform(&self) -> CGAffineTransform;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`cameraViewTransform`][Self::cameraViewTransform].
        #[unsafe(method(setCameraViewTransform:))]
        #[unsafe(method_family = none)]
        pub fn setCameraViewTransform(&self, camera_view_transform: CGAffineTransform);

        #[unsafe(method(takePicture))]
        #[unsafe(method_family = none)]
        pub fn takePicture(&self);

        #[unsafe(method(startVideoCapture))]
        #[unsafe(method_family = none)]
        pub fn startVideoCapture(&self) -> bool;

        #[unsafe(method(stopVideoCapture))]
        #[unsafe(method_family = none)]
        pub fn stopVideoCapture(&self);

        #[unsafe(method(cameraCaptureMode))]
        #[unsafe(method_family = none)]
        pub fn cameraCaptureMode(&self) -> UIImagePickerControllerCameraCaptureMode;

        /// Setter for [`cameraCaptureMode`][Self::cameraCaptureMode].
        #[unsafe(method(setCameraCaptureMode:))]
        #[unsafe(method_family = none)]
        pub fn setCameraCaptureMode(
            &self,
            camera_capture_mode: UIImagePickerControllerCameraCaptureMode,
        );

        #[unsafe(method(cameraDevice))]
        #[unsafe(method_family = none)]
        pub fn cameraDevice(&self) -> UIImagePickerControllerCameraDevice;

        /// Setter for [`cameraDevice`][Self::cameraDevice].
        #[unsafe(method(setCameraDevice:))]
        #[unsafe(method_family = none)]
        pub fn setCameraDevice(&self, camera_device: UIImagePickerControllerCameraDevice);

        #[unsafe(method(cameraFlashMode))]
        #[unsafe(method_family = none)]
        pub fn cameraFlashMode(&self) -> UIImagePickerControllerCameraFlashMode;

        /// Setter for [`cameraFlashMode`][Self::cameraFlashMode].
        #[unsafe(method(setCameraFlashMode:))]
        #[unsafe(method_family = none)]
        pub fn setCameraFlashMode(&self, camera_flash_mode: UIImagePickerControllerCameraFlashMode);
    );
}

/// Methods declared on superclass `UINavigationController`.
#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
impl UIImagePickerController {
    extern_methods!(
        /// # Safety
        ///
        /// - `navigation_bar_class` probably has further requirements.
        /// - `toolbar_class` probably has further requirements.
        #[unsafe(method(initWithNavigationBarClass:toolbarClass:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithNavigationBarClass_toolbarClass(
            this: Allocated<Self>,
            navigation_bar_class: Option<&AnyClass>,
            toolbar_class: Option<&AnyClass>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithRootViewController:))]
        #[unsafe(method_family = init)]
        pub fn initWithRootViewController(
            this: Allocated<Self>,
            root_view_controller: &UIViewController,
        ) -> Retained<Self>;

        #[unsafe(method(initWithNibName:bundle:))]
        #[unsafe(method_family = init)]
        pub fn initWithNibName_bundle(
            this: Allocated<Self>,
            nib_name_or_nil: Option<&NSString>,
            nib_bundle_or_nil: Option<&NSBundle>,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `a_decoder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            a_decoder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(
    feature = "UINavigationController",
    feature = "UIResponder",
    feature = "UIViewController"
))]
impl UIImagePickerController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagepickercontrollerdelegate?language=objc)
    pub unsafe trait UIImagePickerControllerDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(all(
            feature = "UIImage",
            feature = "UINavigationController",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        /// # Safety
        ///
        /// `editing_info` generic should be of the correct type.
        #[deprecated]
        #[optional]
        #[unsafe(method(imagePickerController:didFinishPickingImage:editingInfo:))]
        #[unsafe(method_family = none)]
        unsafe fn imagePickerController_didFinishPickingImage_editingInfo(
            &self,
            picker: &UIImagePickerController,
            image: &UIImage,
            editing_info: Option<&NSDictionary<UIImagePickerControllerInfoKey, AnyObject>>,
        );

        #[cfg(all(
            feature = "UINavigationController",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        /// # Safety
        ///
        /// `info` generic should be of the correct type.
        #[optional]
        #[unsafe(method(imagePickerController:didFinishPickingMediaWithInfo:))]
        #[unsafe(method_family = none)]
        unsafe fn imagePickerController_didFinishPickingMediaWithInfo(
            &self,
            picker: &UIImagePickerController,
            info: &NSDictionary<UIImagePickerControllerInfoKey, AnyObject>,
        );

        #[cfg(all(
            feature = "UINavigationController",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        #[optional]
        #[unsafe(method(imagePickerControllerDidCancel:))]
        #[unsafe(method_family = none)]
        fn imagePickerControllerDidCancel(&self, picker: &UIImagePickerController);
    }
);

#[cfg(feature = "UIImage")]
impl UIImage {
    /// # Safety
    ///
    /// - `completion_target` should be of the correct type.
    /// - `completion_selector` must be a valid selector.
    /// - `context_info` must be a valid pointer or null.
    #[doc(alias = "UIImageWriteToSavedPhotosAlbum")]
    #[cfg(feature = "UIImage")]
    #[inline]
    pub unsafe fn write_to_saved_photos_album(
        &self,
        completion_target: Option<&AnyObject>,
        completion_selector: Option<Sel>,
        context_info: *mut c_void,
    ) {
        extern "C-unwind" {
            fn UIImageWriteToSavedPhotosAlbum(
                image: &UIImage,
                completion_target: Option<&AnyObject>,
                completion_selector: Option<Sel>,
                context_info: *mut c_void,
            );
        }
        unsafe {
            UIImageWriteToSavedPhotosAlbum(
                self,
                completion_target,
                completion_selector,
                context_info,
            )
        }
    }
}

#[inline]
pub extern "C-unwind" fn UIVideoAtPathIsCompatibleWithSavedPhotosAlbum(
    video_path: &NSString,
) -> bool {
    extern "C-unwind" {
        fn UIVideoAtPathIsCompatibleWithSavedPhotosAlbum(video_path: &NSString) -> Bool;
    }
    unsafe { UIVideoAtPathIsCompatibleWithSavedPhotosAlbum(video_path) }.as_bool()
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `completion_target` should be of the correct type.
    /// - `completion_selector` must be a valid selector.
    /// - `context_info` must be a valid pointer or null.
    pub fn UISaveVideoAtPathToSavedPhotosAlbum(
        video_path: &NSString,
        completion_target: Option<&AnyObject>,
        completion_selector: Option<Sel>,
        context_info: *mut c_void,
    );
}

extern "C-unwind" {
    #[cfg(feature = "UIImage")]
    #[deprecated = "renamed to `UIImage::write_to_saved_photos_album`"]
    pub fn UIImageWriteToSavedPhotosAlbum(
        image: &UIImage,
        completion_target: Option<&AnyObject>,
        completion_selector: Option<Sel>,
        context_info: *mut c_void,
    );
}
