//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckquerycursor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKQueryCursor;
);

extern_conformance!(
    unsafe impl NSCoding for CKQueryCursor {}
);

extern_conformance!(
    unsafe impl NSCopying for CKQueryCursor {}
);

unsafe impl CopyingHelper for CKQueryCursor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKQueryCursor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKQueryCursor {}
);

impl CKQueryCursor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern "C" {
    /// Query operations have a dynamically defined maximum number of results.  If the results of a query exceed this max, your completion block will invoked with a cursor.
    /// Issue a new query with that cursor to fetch the next batch of results.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckqueryoperationmaximumresults?language=objc)
    pub static CKQueryOperationMaximumResults: NSUInteger;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckqueryoperation?language=objc)
    #[unsafe(super(CKDatabaseOperation, CKOperation, NSOperation, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
    pub struct CKQueryOperation;
);

#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for CKQueryOperation {}
);

#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
impl CKQueryOperation {
    extern_methods!(
        /// Queries invoked within a sharedCloudDatabase must specify a zoneID.  Cross-zone queries are not supported in a sharedCloudDatabase
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "CKQuery")]
        #[unsafe(method(initWithQuery:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithQuery(this: Allocated<Self>, query: &CKQuery) -> Retained<Self>;

        #[unsafe(method(initWithCursor:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCursor(
            this: Allocated<Self>,
            cursor: &CKQueryCursor,
        ) -> Retained<Self>;

        #[cfg(feature = "CKQuery")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(query))]
        #[unsafe(method_family = none)]
        pub unsafe fn query(&self) -> Option<Retained<CKQuery>>;

        #[cfg(feature = "CKQuery")]
        /// Setter for [`query`][Self::query].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setQuery:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setQuery(&self, query: Option<&CKQuery>);

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(cursor))]
        #[unsafe(method_family = none)]
        pub unsafe fn cursor(&self) -> Option<Retained<CKQueryCursor>>;

        /// Setter for [`cursor`][Self::cursor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setCursor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCursor(&self, cursor: Option<&CKQueryCursor>);

        #[cfg(feature = "CKRecordZoneID")]
        /// Indicates which record zone to query.
        ///
        ///
        /// For query operations constructed using a cursor, this property is ignored and instead will be evaluated in the record zone in which the cursor was originally created.
        /// Queries that do not specify a
        /// `zoneID`will perform a query across all zones in the database.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(zoneID))]
        #[unsafe(method_family = none)]
        pub unsafe fn zoneID(&self) -> Option<Retained<CKRecordZoneID>>;

        #[cfg(feature = "CKRecordZoneID")]
        /// Setter for [`zoneID`][Self::zoneID].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setZoneID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setZoneID(&self, zone_id: Option<&CKRecordZoneID>);

        /// Defaults to
        /// `CKQueryOperationMaximumResults.`Queries may return fewer than
        /// `resultsLimit`in some scenarios:
        /// - There are legitimately fewer than
        /// `resultsLimit`number of records matching the query (and visible to the current user).
        /// - During the process of querying and fetching the results, some records were deleted, or became un-readable by the current user.
        /// When determining if there are more records to fetch, always check for the presence of a cursor in
        /// `queryCompletionBlock.`
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(resultsLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn resultsLimit(&self) -> NSUInteger;

        /// Setter for [`resultsLimit`][Self::resultsLimit].
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setResultsLimit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResultsLimit(&self, results_limit: NSUInteger);

        #[cfg(feature = "CKRecord")]
        /// Declares which user-defined keys should be fetched and added to the resulting CKRecords.
        ///
        ///
        /// If nil, declares the entire record should be downloaded. If set to an empty array, declares that no user fields should be downloaded.
        /// Defaults to
        /// `nil.`
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(desiredKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn desiredKeys(&self) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`desiredKeys`][Self::desiredKeys].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setDesiredKeys:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDesiredKeys(&self, desired_keys: Option<&NSArray<CKRecordFieldKey>>);

        #[cfg(all(feature = "CKRecord", feature = "block2"))]
        /// This block will be called once for every record that is returned as a result of the query.
        ///
        ///
        /// The callbacks will happen in the order that the results were sorted in.
        /// If the replacement callback
        /// `recordMatchedBlock`is set, this callback block is ignored.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer.
        /// - This might not be thread-safe.
        #[deprecated = "Use recordMatchedBlock instead, which surfaces per-record errors"]
        #[unsafe(method(recordFetchedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordFetchedBlock(&self)
            -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecord>)>;

        #[cfg(all(feature = "CKRecord", feature = "block2"))]
        /// Setter for [`recordFetchedBlock`][Self::recordFetchedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Use recordMatchedBlock instead, which surfaces per-record errors"]
        #[unsafe(method(setRecordFetchedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordFetchedBlock(
            &self,
            record_fetched_block: Option<&block2::DynBlock<dyn Fn(NonNull<CKRecord>)>>,
        );

        #[cfg(all(feature = "CKRecord", feature = "CKRecordID", feature = "block2"))]
        /// This block will be called once for every record that is returned as a result of the query.
        ///
        ///
        /// The callbacks will happen in the order that the results were sorted in.  If a record fails in post-processing (say, a network failure materializing a
        /// `CKAsset`record field), the per-record error will be passed here.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer.
        /// - The returned block's argument 2 must be a valid pointer or null.
        /// - The returned block's argument 3 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(recordMatchedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordMatchedBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecordID>, *mut CKRecord, *mut NSError)>;

        #[cfg(all(feature = "CKRecord", feature = "CKRecordID", feature = "block2"))]
        /// Setter for [`recordMatchedBlock`][Self::recordMatchedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordMatchedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordMatchedBlock(
            &self,
            record_matched_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKRecordID>, *mut CKRecord, *mut NSError)>,
            >,
        );

        #[cfg(feature = "block2")]
        /// This block is called when the operation completes.
        ///
        ///
        /// The
        ///
        /// ```text
        ///  -[NSOperation completionBlock]
        /// ```
        ///
        /// will also be called if both are set.
        /// If the error is
        /// `CKErrorPartialFailure,`the error's userInfo dictionary contains a dictionary of recordIDs to errors keyed off of
        /// `CKPartialErrorsByItemIDKey.`These errors are repeats of those sent back in previous
        /// `recordMatchedBlock`invocations
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer or null.
        /// - The returned block's argument 2 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(queryCompletionBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn queryCompletionBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(*mut CKQueryCursor, *mut NSError)>;

        #[cfg(feature = "block2")]
        /// Setter for [`queryCompletionBlock`][Self::queryCompletionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setQueryCompletionBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setQueryCompletionBlock(
            &self,
            query_completion_block: Option<
                &block2::DynBlock<dyn Fn(*mut CKQueryCursor, *mut NSError)>,
            >,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
impl CKQueryOperation {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
