// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// SpanEvent is a time-stamped annotation of the span, consisting of user-supplied
// text description and key-value pairs. See OTLP for event definition.
type SpanEvent struct {
	Name                   string
	Attributes             []KeyValue
	TimeUnixNano           uint64
	DroppedAttributesCount uint32
}

var (
	protoPoolSpanEvent = sync.Pool{
		New: func() any {
			return &SpanEvent{}
		},
	}
)

func NewSpanEvent() *SpanEvent {
	if !UseProtoPooling.IsEnabled() {
		return &SpanEvent{}
	}
	return protoPoolSpanEvent.Get().(*SpanEvent)
}

func DeleteSpanEvent(orig *SpanEvent, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolSpanEvent.Put(orig)
	}
}

func CopySpanEvent(dest, src *SpanEvent) *SpanEvent {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSpanEvent()
	}
	dest.TimeUnixNano = src.TimeUnixNano
	dest.Name = src.Name
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.DroppedAttributesCount = src.DroppedAttributesCount

	return dest
}

func CopySpanEventSlice(dest, src []SpanEvent) []SpanEvent {
	var newDest []SpanEvent
	if cap(dest) < len(src) {
		newDest = make([]SpanEvent, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpanEvent(&dest[i], false)
		}
	}
	for i := range src {
		CopySpanEvent(&newDest[i], &src[i])
	}
	return newDest
}

func CopySpanEventPtrSlice(dest, src []*SpanEvent) []*SpanEvent {
	var newDest []*SpanEvent
	if cap(dest) < len(src) {
		newDest = make([]*SpanEvent, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpanEvent()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpanEvent(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpanEvent()
		}
	}
	for i := range src {
		CopySpanEvent(newDest[i], src[i])
	}
	return newDest
}

func (orig *SpanEvent) Reset() {
	*orig = SpanEvent{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *SpanEvent) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Name != "" {
		dest.WriteObjectField("name")
		dest.WriteString(orig.Name)
	}
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *SpanEvent) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "name":
			orig.Name = iter.ReadString()
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func (orig *SpanEvent) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.TimeUnixNano != uint64(0) {
		n += 9
	}

	l = len(orig.Name)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	return n
}

func (orig *SpanEvent) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.TimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x9
	}
	l = len(orig.Name)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Name)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	if orig.DroppedAttributesCount != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x20
	}
	return len(buf) - pos
}

func (orig *SpanEvent) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Name = string(buf[startPos:pos])

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.DroppedAttributesCount = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSpanEvent() *SpanEvent {
	orig := NewSpanEvent()
	orig.TimeUnixNano = uint64(13)
	orig.Name = "test_name"
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.DroppedAttributesCount = uint32(13)
	return orig
}

func GenTestSpanEventPtrSlice() []*SpanEvent {
	orig := make([]*SpanEvent, 5)
	orig[0] = NewSpanEvent()
	orig[1] = GenTestSpanEvent()
	orig[2] = NewSpanEvent()
	orig[3] = GenTestSpanEvent()
	orig[4] = NewSpanEvent()
	return orig
}

func GenTestSpanEventSlice() []SpanEvent {
	orig := make([]SpanEvent, 5)
	orig[1] = *GenTestSpanEvent()
	orig[3] = *GenTestSpanEvent()
	return orig
}
