/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.PseudoCylindricalProjection;

public class RobinsonProjection
extends PseudoCylindricalProjection {
    private static final double[][] X = new double[][]{{1.0, 2.2199E-17f, -7.15515E-5f, 3.1103E-6f}, {0.9986f, -4.82243E-4f, -2.4897E-5f, -1.3309E-6f}, {0.9954f, -8.3103E-4f, -4.48605E-5f, -9.86701E-7f}, {0.99f, -0.00135364f, -5.9661E-5f, 3.6777E-6f}, {0.9822f, -0.00167442f, -4.49547E-6f, -5.72411E-6f}, {0.973f, -0.00214868f, -9.03571E-5f, 1.8736E-8f}, {0.96f, -0.00305085f, -9.00761E-5f, 1.64917E-6f}, {0.9427f, -0.00382792f, -6.53386E-5f, -2.6154E-6f}, {0.9216f, -0.00467746f, -1.0457E-4f, 4.81243E-6f}, {0.8962f, -0.00536223f, -3.23831E-5f, -5.43431997357402E-6}, {0.8679f, -0.00609363f, -1.13898E-4f, 3.32484E-6f}, {0.835f, -0.00698325f, -6.40253E-5f, 9.34959018650261E-7}, {0.7986f, -0.00755338f, -5.00009E-5f, 9.35324E-7f}, {0.7597f, -0.00798324029892683, -3.5971E-5f, -2.27626E-6f}, {0.7186f, -0.00851367f, -7.01149E-5f, -8.6303E-6f}, {0.6732f, -0.00986209f, -1.99569E-4f, 1.91974E-5f}, {0.6213f, -0.010418f, 8.83923E-5f, 6.24051E-6f}, {0.5722f, -0.00906601f, 1.82E-4f, 6.24051E-6f}, {0.5322f, -0.00677797f, 2.75608E-4f, 6.24051E-6f}};
    private static final double[][] Y = new double[][]{{-5.20417E-18f, 0.0124f, 1.21431E-18f, -8.45284E-11f}, {0.062f, 0.0124f, -1.26793E-9f, 4.22642E-10f}, {0.124f, 0.0124f, 5.07171E-9f, -1.60604E-9f}, {0.186f, 0.0123999f, -1.90189E-8f, 6.00152E-9f}, {0.248f, 0.0124002f, 7.10039E-8f, -2.24E-8f}, {0.31f, 0.0123992f, -2.64997E-7f, 8.35986E-8f}, {0.372f, 0.0124029f, 9.88982947092154E-7, -3.11994E-7f}, {0.434f, 0.0123893f, -3.69093E-6f, -4.35621E-7f}, {0.4958f, 0.0123198f, -1.02252E-5f, -3.45523E-7f}, {0.5571f, 0.0121916f, -1.54081E-5f, -5.82288E-7f}, {0.6176f, 0.0119938f, -2.41424E-5f, -5.25327E-7f}, {0.6769f, 0.011713f, -3.20223E-5f, -5.16405E-7f}, {0.7346f, 0.0113541f, -3.97684E-5f, -6.09052E-7f}, {0.7903f, 0.0109107f, -4.89042E-5f, -1.04739E-6f}, {0.8435f, 0.0103431f, -6.4615E-5f, -1.40374E-9f}, {0.8936f, 0.00969686f, -6.4636E-5f, -8.547E-6f}, {0.9394f, 0.00840947f, -1.92841E-4f, -4.2106E-6f}, {0.9761f, 0.00616527f, -2.56E-4f, -4.2106E-6f}, {1.0, 0.00328947f, -3.19159E-4f, -4.2106E-6f}};
    private final int NODES = 18;
    private static final double FXC = 0.8487;
    private static final double FYC = 1.3523;
    private static final double C1 = 11.459155902616464;
    private static final double RC1 = 0.08726646259971647;
    private static final double ONEEPS = 1.000001;
    private static final double EPS = 1.0E-10;
    private static final int MAX_ITER = 100;

    private double V(double[] C, double z) {
        return C[0] + z * (C[1] + z * (C[2] + z * C[3]));
    }

    private double DV(double[] C, double z) {
        return C[1] + 2.0 * z * C[2] + z * z * 3.0 * C[3];
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        double phi = Math.abs(lpphi);
        int i2 = (int)Math.floor(phi * 11.459155902616464);
        if (i2 >= 18) {
            i2 = 18;
        }
        phi = Math.toDegrees(phi - 0.08726646259971647 * (double)i2);
        xy.x = this.V(X[i2], phi) * 0.8487 * lplam;
        xy.y = this.V(Y[i2], phi) * 1.3523;
        if (lpphi < 0.0) {
            xy.y = -xy.y;
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        lp.x = x / 0.8487;
        lp.y = Math.abs(y / 1.3523);
        if (lp.y >= 1.0) {
            if (lp.y > 1.000001) {
                lp.x = Double.NaN;
                lp.y = Double.NaN;
                return lp;
            }
            lp.y = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            lp.x /= X[18][0];
        } else {
            int i2 = (int)Math.floor(lp.y * 18.0);
            if (i2 < 0 || i2 >= 18) {
                lp.x = Double.NaN;
                lp.y = Double.NaN;
                return lp;
            }
            while (true) {
                if (Y[i2][0] > lp.y) {
                    --i2;
                    continue;
                }
                if (!(Y[i2 + 1][0] <= lp.y)) break;
                ++i2;
            }
            double[] T = Y[i2];
            double t = 5.0 * (lp.y - Y[i2][0]) / (Y[i2 + 1][0] - Y[i2][0]);
            for (int iters = 100; iters > 0; --iters) {
                double t1 = (this.V(T, t) - lp.y) / this.DV(T, t);
                t -= t1;
                if (Math.abs(t1) < 1.0E-10) break;
            }
            lp.y = Math.toRadians((double)(5 * i2) + t);
            if (y < 0.0) {
                lp.y = -lp.y;
            }
            lp.x /= this.V(X[i2], t);
            if (Math.abs(lp.x) > Math.PI) {
                lp.x = Double.NaN;
                lp.y = Double.NaN;
            }
        }
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Robinson";
    }
}

