/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomResourceBundle
extends ResourceBundle {
    private static final Logger LOG = Logger.getInstance(CustomResourceBundle.class);
    private final List<PropertiesFile> myFiles;
    private final String myBaseName;

    private CustomResourceBundle(List<PropertiesFile> files, @NotNull String baseName) {
        if (baseName == null) {
            CustomResourceBundle.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!files.isEmpty());
        this.myFiles = ContainerUtil.sorted(files, Comparator.comparing(PropertiesFile::getName));
        this.myBaseName = baseName;
    }

    public static CustomResourceBundle fromState(CustomResourceBundleState state, Project project) {
        List files = ContainerUtil.mapNotNull(state.getFiles(VirtualFileManager.getInstance()), virtualFile -> PropertiesImplUtil.getPropertiesFile(virtualFile, project));
        return files.size() < 2 ? null : new CustomResourceBundle(files, state.getBaseName());
    }

    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        List<PropertiesFile> list = this.myFiles;
        if (list == null) {
            CustomResourceBundle.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        PropertiesFile propertiesFile = (PropertiesFile)ContainerUtil.getFirstItem(this.myFiles);
        if (propertiesFile == null) {
            CustomResourceBundle.$$$reportNull$$$0(2);
        }
        return propertiesFile;
    }

    @NotNull
    public String getBaseName() {
        String string = this.myBaseName;
        if (string == null) {
            CustomResourceBundle.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public VirtualFile getBaseDirectory() {
        VirtualFile baseDir = null;
        for (PropertiesFile file : this.myFiles) {
            VirtualFile currentBaseDir = file.getContainingFile().getVirtualFile().getParent();
            if (baseDir == null) {
                baseDir = currentBaseDir;
                continue;
            }
            if (baseDir.equals(currentBaseDir)) continue;
            return null;
        }
        return baseDir;
    }

    public boolean isValid() {
        for (PropertiesFile file : this.myFiles) {
            if (file.getContainingFile().isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CustomResourceBundle resourceBundle = (CustomResourceBundle)((Object)o);
        return resourceBundle.getPropertiesFiles().equals(this.getPropertiesFiles()) && resourceBundle.getBaseName().equals(this.getBaseName());
    }

    public int hashCode() {
        return this.myFiles.hashCode() * 31 + this.myBaseName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/CustomResourceBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/CustomResourceBundle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropertiesFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

