/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackCommandReporter;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.SafeSpanStack;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReporterCommandAsTelemetrySpan
implements PlaybackCommandReporter {
    private SafeSpanStack myOTSpanLogger;
    private Span mySpan;
    private final PlaybackCommandReporter myChainedReporter;
    public static final String USE_SPAN_WRAPPER_FOR_COMMAND = "performance.execute.script.reportEachCommandAsTelemetrySpan";
    public static final String REPORT_RUNNER_SPAN_AS_ROOT = "performance.execute.script.reportScriptRunnerAsRootSpan";

    public ReporterCommandAsTelemetrySpan() {
        this(EMPTY_PLAYBACK_COMMAND_REPORTER);
    }

    public ReporterCommandAsTelemetrySpan(@NotNull PlaybackCommandReporter chainedReporter) {
        if (chainedReporter == null) {
            ReporterCommandAsTelemetrySpan.$$$reportNull$$$0(0);
        }
        this.myChainedReporter = chainedReporter;
    }

    public void startOfCommand(@NotNull String fullCommandLine) {
        if (fullCommandLine == null) {
            ReporterCommandAsTelemetrySpan.$$$reportNull$$$0(1);
        }
        this.myChainedReporter.startOfCommand(fullCommandLine);
        this.myOTSpanLogger.startSpan(fullCommandLine);
    }

    public void endOfCommand(@Nullable String errDescriptionOrNull) {
        this.myOTSpanLogger.endSpan(errDescriptionOrNull);
        this.myChainedReporter.endOfCommand(errDescriptionOrNull);
    }

    public void startOfScript(@Nullable Project project) {
        this.myChainedReporter.startOfScript(project);
        SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder("Script Runner");
        if (SystemProperties.getBooleanProperty((String)REPORT_RUNNER_SPAN_AS_ROOT, (boolean)false)) {
            spanBuilder = spanBuilder.setNoParent();
        }
        this.mySpan = spanBuilder.startSpan();
        this.myOTSpanLogger = new SafeSpanStack(PerformanceTestSpan.TRACER, Context.current().with((ImplicitContextKeyed)this.mySpan));
    }

    public void scriptCanceled() {
        this.myChainedReporter.scriptCanceled();
    }

    public void endOfScript(@Nullable Project project) {
        Disposer.dispose((Disposable)this.myOTSpanLogger);
        this.mySpan.end();
        this.myChainedReporter.endOfScript(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chainedReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCommandLine";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/utils/ReporterCommandAsTelemetrySpan";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startOfCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

