/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageDescriptorEx;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testing.JsTestFileByTestNamesIndexKt;
import com.intellij.javascript.testing.detection.CachingJsTestFileIndexDataCollector;
import com.intellij.javascript.testing.detection.JsTestFileIndexData;
import com.intellij.javascript.testing.detection.JsTestFileIndexDataKt;
import com.intellij.javascript.testing.detection.JsTestFrameworkApiDesign;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectors;
import com.intellij.javascript.testing.detection.JsTestFrameworkPackageDescriptor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaDetectorKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015JY\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u001e0 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002H\u001e0 2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u0002H\u001e0 H\u0002\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0005J \u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-J\"\u00103\u001a\u0004\u0018\u0001012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/nodejs/mocha/execution/MochaDetector;", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkDetector;", "<init>", "()V", "frameworkName", "", "getFrameworkName", "()Ljava/lang/String;", "frameworkApiDesign", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkApiDesign;", "getFrameworkApiDesign", "()Lcom/intellij/javascript/testing/detection/JsTestFrameworkApiDesign;", "packageDescriptor", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkPackageDescriptor;", "getPackageDescriptor", "()Lcom/intellij/javascript/testing/detection/JsTestFrameworkPackageDescriptor;", "indexDataCollector", "Lcom/intellij/javascript/testing/detection/CachingJsTestFileIndexDataCollector;", "findFileBasedIndexData", "Lcom/intellij/javascript/testing/detection/JsTestFileIndexData;", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "checkIsProbablyTestFile", "", "findTestsStructureWithUi", "Lkotlin/Pair;", "Lcom/intellij/javascript/testFramework/AbstractTestFileStructure;", "findTestsStructure", "findTestStructureUi", "detectMochaStructure", "T", "handleJasmineStructure", "Lkotlin/Function1;", "Lcom/intellij/javascript/testFramework/jasmine/JasmineFileStructure;", "handleQUnitStructure", "Lcom/intellij/javascript/testFramework/qunit/QUnitFileStructure;", "handleMochaTddStructure", "Lcom/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure;", "(Lcom/intellij/lang/javascript/psi/JSFile;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "findTestFilesInIndexesBySelector", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "testSelector", "Lcom/intellij/javascript/testFramework/JsTestSelector;", "findTestStructureForNavigation", "interfaceName", "findPsiElementByProbableInterface", "Lcom/intellij/psi/PsiElement;", "probableInterfaceName", "tryToFindPsiElementInInterfaceForNavigation", "Companion", "intellij.nodeJS"})
@SourceDebugExtension(value={"SMAP\nMochaDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MochaDetector.kt\ncom/jetbrains/nodejs/mocha/execution/MochaDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1869#2:210\n1870#2:212\n1869#2,2:213\n1#3:211\n*S KotlinDebug\n*F\n+ 1 MochaDetector.kt\ncom/jetbrains/nodejs/mocha/execution/MochaDetector\n*L\n173#1:210\n173#1:212\n184#1:213,2\n*E\n"})
public final class MochaDetector
implements JsTestFrameworkDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frameworkName;
    @NotNull
    private final JsTestFrameworkApiDesign frameworkApiDesign = JsTestFrameworkApiDesign.GLOBAL_VARIABLES;
    @NotNull
    private final JsTestFrameworkPackageDescriptor packageDescriptor;
    @NotNull
    private final CachingJsTestFileIndexDataCollector indexDataCollector;

    public MochaDetector() {
        this.frameworkName = "Mocha";
        JsTestFrameworkDetector jsTestFrameworkDetector = this;
        NodePackageDescriptor nodePackageDescriptor = MochaUtil.PACKAGE_DESCRIPTOR;
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageDescriptor, (String)"PACKAGE_DESCRIPTOR");
        this.packageDescriptor = new JsTestFrameworkPackageDescriptor(jsTestFrameworkDetector, new NodePackageDescriptorEx(nodePackageDescriptor, MochaDetectorKt.access$getBlockingPackages()));
        this.indexDataCollector = new CachingJsTestFileIndexDataCollector((JsTestFrameworkDetector)this, MochaDetector::indexDataCollector$lambda$0);
    }

    @NotNull
    public String getFrameworkName() {
        return this.frameworkName;
    }

    @NotNull
    public JsTestFrameworkApiDesign getFrameworkApiDesign() {
        return this.frameworkApiDesign;
    }

    @NotNull
    public JsTestFrameworkPackageDescriptor getPackageDescriptor() {
        return this.packageDescriptor;
    }

    @NotNull
    public JsTestFileIndexData findFileBasedIndexData(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return this.indexDataCollector.getIndexData(jsFile);
    }

    public boolean checkIsProbablyTestFile(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return this.indexDataCollector.getIndexData(jsFile).getHasData();
    }

    @Nullable
    public final Pair<AbstractTestFileStructure, String> findTestsStructureWithUi(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return (Pair)this.detectMochaStructure(jsFile, MochaDetector::findTestsStructureWithUi$lambda$1, MochaDetector::findTestsStructureWithUi$lambda$2, MochaDetector::findTestsStructureWithUi$lambda$3);
    }

    @Nullable
    public AbstractTestFileStructure findTestsStructure(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        Pair<AbstractTestFileStructure, String> pair = this.findTestsStructureWithUi(jsFile);
        return pair != null ? (AbstractTestFileStructure)pair.getFirst() : null;
    }

    @Nullable
    public final String findTestStructureUi(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        Pair<AbstractTestFileStructure, String> pair = this.findTestsStructureWithUi(jsFile);
        return pair != null ? (String)pair.getSecond() : null;
    }

    private final <T> T detectMochaStructure(JSFile jsFile, Function1<? super JasmineFileStructure, ? extends T> handleJasmineStructure, Function1<? super QUnitFileStructure, ? extends T> handleQUnitStructure, Function1<? super MochaTddFileStructure, ? extends T> handleMochaTddStructure) {
        AbstractTestFileStructure abstractTestFileStructure = JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure, (String)"fetchCachedTestFileStructure(...)");
        JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)abstractTestFileStructure;
        if (!jasmineFileStructure.isEmpty()) {
            return (T)handleJasmineStructure.invoke((Object)jasmineFileStructure);
        }
        AbstractTestFileStructure abstractTestFileStructure2 = QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure2, (String)"fetchCachedTestFileStructure(...)");
        QUnitFileStructure qUnitStructure = (QUnitFileStructure)abstractTestFileStructure2;
        if (!qUnitStructure.isEmpty()) {
            return (T)handleQUnitStructure.invoke((Object)qUnitStructure);
        }
        AbstractTestFileStructure abstractTestFileStructure3 = MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure3, (String)"fetchCachedTestFileStructure(...)");
        MochaTddFileStructure tddStructure = (MochaTddFileStructure)abstractTestFileStructure3;
        if (!tddStructure.isEmpty()) {
            return (T)handleMochaTddStructure.invoke((Object)tddStructure);
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> findTestFilesInIndexesBySelector(@NotNull Project project, @NotNull JsTestSelector testSelector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testSelector, (String)"testSelector");
        return JsTestFileByTestNamesIndexKt.findTestFilesByTestSelector((Project)project, (JsTestSelector)testSelector, (JsTestFrameworkDetector)this);
    }

    @Nullable
    public final AbstractTestFileStructure findTestStructureForNavigation(@NotNull JSFile jsFile, @NotNull String interfaceName) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        Intrinsics.checkNotNullParameter((Object)interfaceName, (String)"interfaceName");
        if (MochaDetectorKt.access$getMOCHA_INTERFACES_TO_STRUCTURE_BUILDERS$p().containsKey(interfaceName)) {
            AbstractTestFileStructureBuilder abstractTestFileStructureBuilder = (AbstractTestFileStructureBuilder)MochaDetectorKt.access$getMOCHA_INTERFACES_TO_STRUCTURE_BUILDERS$p().get(interfaceName);
            AbstractTestFileStructure structure = abstractTestFileStructureBuilder != null ? abstractTestFileStructureBuilder.fetchCachedTestFileStructure(jsFile) : null;
            return structure != null && !structure.isEmpty() ? structure : null;
        }
        return null;
    }

    @Nullable
    public final PsiElement findPsiElementByProbableInterface(@NotNull JSFile jsFile, @NotNull String probableInterfaceName, @NotNull JsTestSelector testSelector) {
        String interfaceName;
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        Intrinsics.checkNotNullParameter((Object)probableInterfaceName, (String)"probableInterfaceName");
        Intrinsics.checkNotNullParameter((Object)testSelector, (String)"testSelector");
        String string = probableInterfaceName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String interfaceLikeName = string;
        Set notCheckedInterfaces = new LinkedHashSet();
        Iterable $this$forEach$iv = MochaDetectorKt.access$getMOCHA_INTERFACES_FOR_LOOKUP_BY_PROBABLE_INTERFACE$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            interfaceName = (String)element$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)interfaceLikeName, (CharSequence)interfaceName, (boolean)false, (int)2, null)) {
                PsiElement psiElement = this.tryToFindPsiElementInInterfaceForNavigation(jsFile, interfaceName, testSelector);
                if (psiElement == null) continue;
                PsiElement it = psiElement;
                boolean bl2 = false;
                return it;
            }
            notCheckedInterfaces.add(interfaceName);
        }
        $this$forEach$iv = notCheckedInterfaces;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            interfaceName = (String)element$iv;
            boolean bl = false;
            PsiElement psiElement = this.tryToFindPsiElementInInterfaceForNavigation(jsFile, interfaceName, testSelector);
            if (psiElement == null) continue;
            PsiElement it = psiElement;
            boolean bl3 = false;
            return it;
        }
        return null;
    }

    private final PsiElement tryToFindPsiElementInInterfaceForNavigation(JSFile jsFile, String interfaceName, JsTestSelector testSelector) {
        PsiElement psiElement;
        AbstractTestFileStructure structure;
        AbstractTestFileStructureBuilder abstractTestFileStructureBuilder = (AbstractTestFileStructureBuilder)MochaDetectorKt.access$getMOCHA_INTERFACES_TO_STRUCTURE_BUILDERS$p().get(interfaceName);
        Object object = structure = abstractTestFileStructureBuilder != null ? abstractTestFileStructureBuilder.fetchCachedTestFileStructure(jsFile) : null;
        if (structure != null && !structure.isEmpty() && (psiElement = structure.findPsiElement(testSelector)) != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private static final JsTestFileIndexData indexDataCollector$lambda$0(JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        Set names = new LinkedHashSet();
        AbstractTestFileStructure abstractTestFileStructure = JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure, (String)"fetchCachedTestFileStructure(...)");
        JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)abstractTestFileStructure;
        if (!jasmineFileStructure.isEmpty()) {
            Set set = jasmineFileStructure.collectElementPaths("\u0000");
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collectElementPaths(...)");
            names.addAll(set);
        }
        AbstractTestFileStructure abstractTestFileStructure2 = QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure2, (String)"fetchCachedTestFileStructure(...)");
        QUnitFileStructure qUnitFileStructure = (QUnitFileStructure)abstractTestFileStructure2;
        if (!qUnitFileStructure.isEmpty()) {
            Set set = qUnitFileStructure.collectElementPaths("\u0000");
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collectElementPaths(...)");
            names.addAll(set);
        }
        AbstractTestFileStructure abstractTestFileStructure3 = MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue((Object)abstractTestFileStructure3, (String)"fetchCachedTestFileStructure(...)");
        MochaTddFileStructure mochaTddFileStructure = (MochaTddFileStructure)abstractTestFileStructure3;
        if (!mochaTddFileStructure.isEmpty()) {
            Set set = mochaTddFileStructure.collectElementPaths("\u0000");
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collectElementPaths(...)");
            names.addAll(set);
        }
        return !((Collection)names).isEmpty() ? new JsTestFileIndexData(names, true, null, 4, null) : JsTestFileIndexDataKt.emptyJsTestFileIndexData();
    }

    private static final Pair findTestsStructureWithUi$lambda$1(JasmineFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Pair((Object)it, (Object)"bdd");
    }

    private static final Pair findTestsStructureWithUi$lambda$2(QUnitFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Pair((Object)it, (Object)"qunit");
    }

    private static final Pair findTestsStructureWithUi$lambda$3(MochaTddFileStructure it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String ui = it.hasMochaTypeScriptDeclarations() ? "mocha-typescript" : "tdd";
        return new Pair((Object)it, (Object)ui);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/nodejs/mocha/execution/MochaDetector$Companion;", "", "<init>", "()V", "instance", "Lcom/jetbrains/nodejs/mocha/execution/MochaDetector;", "getInstance", "()Lcom/jetbrains/nodejs/mocha/execution/MochaDetector;", "intellij.nodeJS"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MochaDetector getInstance() {
            return (MochaDetector)JsTestFrameworkDetectors.Companion.getDetectorOrFail(MochaDetector.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

