/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.filters;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilterProvider;
import com.intellij.lang.javascript.psi.resolve.JSDefaultPlaceFilters;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeContextFilter;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnqualifiedReferenceFilterProvider
implements JSCompletionPlaceFilterProvider {
    @Override
    @Nullable
    public JSCompletionPlaceFilter forPlace(@NotNull PsiElement place) {
        if (place == null) {
            JSUnqualifiedReferenceFilterProvider.$$$reportNull$$$0(0);
        }
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() == null) {
            if (ResolveProcessor.completeConstructorName(place)) {
                return JSDefaultPlaceFilters.JS_NEW_EXPRESSION_FILTER;
            }
            if (TypeScriptPsiUtil.isTsIndexerType(place)) {
                return JSDefaultPlaceFilters.TS_INDEXER_TYPE_FILTER;
            }
            final boolean strictTypeContext = JSResolveUtil.isExprInTypeContext((JSReferenceExpression)place);
            JSVariable variable = JSUnqualifiedReferenceFilterProvider.getOwnLetOrConstVariableDeclaration(place);
            TypeScriptImportStatement importStatement = JSUnqualifiedReferenceFilterProvider.getOwnImportStatement(place);
            final String varName = variable == null ? null : variable.getName();
            final String importName = importStatement == null ? null : importStatement.getName();
            final JSCompletionPlaceFilter.ContextKind contextKind = JSCompletionPlaceFilter.getContextKind(place);
            final boolean isDecorator = place.getParent() instanceof ES6Decorator;
            return new JSTypeContextFilter(){

                @Override
                public boolean isAcceptable(@NotNull JSPsiElementBase element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (contextKind == JSCompletionPlaceFilter.ContextKind.TypeDeclaration && 1.isStrictlyNonTypeUsage(element2)) {
                        return false;
                    }
                    if (contextKind == JSCompletionPlaceFilter.ContextKind.Expression && element2 instanceof TypeScriptCompileTimeType) {
                        return false;
                    }
                    if (contextKind == JSCompletionPlaceFilter.ContextKind.Expression && isDecorator && element2 instanceof TypeScriptCallSignature && ((TypeScriptCallSignature)element2).hasNew()) {
                        return false;
                    }
                    return !this.skipSameVariable(element2) && !this.skipSameImport(element2);
                }

                private boolean skipSameImport(@NotNull JSPsiElementBase element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element2 instanceof TypeScriptImportStatement) {
                        TypeScriptImportStatement statement = (TypeScriptImportStatement)element2;
                        if (importName == null) {
                            return false;
                        }
                        return importName.equals(statement.getName());
                    }
                    return false;
                }

                private boolean skipSameVariable(@NotNull JSPsiElementBase element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (element2 instanceof JSVariable) {
                        JSVariable var = (JSVariable)element2;
                        if (varName == null) {
                            return false;
                        }
                        return varName.equals(var.getName());
                    }
                    return false;
                }

                @Override
                public boolean isPartialResult(@NotNull JSPsiElementBase element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return strictTypeContext && super.isPartialResult(element2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "element";
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/filters/JSUnqualifiedReferenceFilterProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isAcceptable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "skipSameImport";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "skipSameVariable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isPartialResult";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return null;
    }

    @Nullable
    public static JSVariable getOwnLetOrConstVariableDeclaration(@NotNull PsiElement place) {
        PsiElement parent;
        if (place == null) {
            JSUnqualifiedReferenceFilterProvider.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = parent = place instanceof JSVariable ? place : PsiTreeUtil.getParentOfType((PsiElement)place, JSVariable.class, (boolean)false, (Class[])new Class[]{JSFunction.class});
        if (parent == null) {
            return null;
        }
        JSVarStatement varStatement = ((JSVariable)parent).getStatement();
        if (varStatement == null) {
            return null;
        }
        JSVarStatement.VarKeyword varKeyword = varStatement.getVarKeyword();
        return varKeyword == JSVarStatement.VarKeyword.LET || varKeyword == JSVarStatement.VarKeyword.CONST ? (JSVariable)parent : null;
    }

    @Nullable
    public static TypeScriptImportStatement getOwnImportStatement(@NotNull PsiElement place) {
        if (place == null) {
            JSUnqualifiedReferenceFilterProvider.$$$reportNull$$$0(2);
        }
        TypeScriptImportStatement importStatement = null;
        if (place instanceof TypeScriptEntityName && place.getParent() instanceof TypeScriptImportStatement) {
            importStatement = (TypeScriptImportStatement)place.getParent();
        }
        return importStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "place";
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/filters/JSUnqualifiedReferenceFilterProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forPlace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOwnLetOrConstVariableDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOwnImportStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

