/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsbtTaskFetchException
extends Exception {
    private final VirtualFile myBuildfile;
    private final List<JsbtInvalidSetting> myInvalidSettings;
    private final JsbtTaskListFetchFail myFetchFail;

    private JsbtTaskFetchException(@NotNull VirtualFile buildfile, @Nullable String message, @NotNull List<JsbtInvalidSetting> invalidSettings, @Nullable JsbtTaskListFetchFail fetchFail) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(0);
        }
        if (invalidSettings == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(1);
        }
        super(message);
        this.myBuildfile = buildfile;
        this.myInvalidSettings = ImmutableList.copyOf(invalidSettings);
        this.myFetchFail = fetchFail;
    }

    @NotNull
    public VirtualFile getBuildfile() {
        VirtualFile virtualFile = this.myBuildfile;
        if (virtualFile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public boolean hasInvalidSettings() {
        return !this.myInvalidSettings.isEmpty();
    }

    @Nullable
    public JsbtTaskListFetchFail getFetchFail() {
        return this.myFetchFail;
    }

    @NotNull
    public String getDescription() {
        if (!this.myInvalidSettings.isEmpty()) {
            StringBuilder buf = new StringBuilder("Cannot fetch task list, because of invalid parameters:");
            for (JsbtInvalidSetting setting : this.myInvalidSettings) {
                buf.append("\n");
                buf.append(setting.getName());
                if (setting.getValue() != null) {
                    buf.append(":").append(setting.getValue());
                }
                buf.append(" (").append(setting.getErrorMessage()).append(")");
            }
            String string = buf.toString();
            if (string == null) {
                JsbtTaskFetchException.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (this.myFetchFail != null) {
            String string = this.myFetchFail.getDescription();
            if (string == null) {
                JsbtTaskFetchException.$$$reportNull$$$0(4);
            }
            return string;
        }
        throw new AssertionError((Object)"Unreachable assertion");
    }

    @NotNull
    public static JsbtTaskFetchException newInvalidSettings(@NotNull VirtualFile buildfile, @NotNull List<JsbtInvalidSetting> invalidSettings) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(5);
        }
        if (invalidSettings == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(6);
        }
        return new JsbtTaskFetchException(buildfile, null, invalidSettings, null);
    }

    @NotNull
    public static JsbtTaskFetchException newBuildfileSyntaxError(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(7);
        }
        return new JsbtTaskFetchException(buildfile, null, (List<JsbtInvalidSetting>)ImmutableList.of(), null);
    }

    @NotNull
    public static JsbtTaskFetchException newGenericException(@NotNull VirtualFile buildfile, @NotNull String message) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(8);
        }
        if (message == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(9);
        }
        return new JsbtTaskFetchException(buildfile, message, (List<JsbtInvalidSetting>)ImmutableList.of(), null);
    }

    @NotNull
    public static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile buildfile, @NotNull JsbtApplicationService service, @NotNull String buildToolName, @Nullable Icon icon, @NotNull String message, @Nullable GeneralCommandLine commandLine, @Nullable String commandLineFoldedText, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(10);
        }
        if (service == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(11);
        }
        if (buildToolName == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(12);
        }
        if (message == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(13);
        }
        return new JsbtTaskFetchException(buildfile, null, (List<JsbtInvalidSetting>)ImmutableList.of(), new JsbtTaskListFetchFail(buildfile, service, buildToolName, icon, message, commandLine, commandLineFoldedText, executionException, processHandler, processOutput));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildfile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newInvalidSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newBuildfileSyntaxError";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newGenericException";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newFetchFail";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class WrapperException
    extends Exception {
        private final JsbtTaskFetchException myCause;
        private final JsbtFileStructure myEmptyFileStructure;

        @RequiresBackgroundThread
        public WrapperException(@NotNull JsbtTaskFetchException cause, @NotNull JsbtService service) {
            if (cause == null) {
                WrapperException.$$$reportNull$$$0(0);
            }
            if (service == null) {
                WrapperException.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertBackgroundThread();
            super(cause);
            this.myCause = cause;
            this.myEmptyFileStructure = service.createEmptyFileStructure(cause.getBuildfile());
            this.myEmptyFileStructure.updateInBackground(service.myProject);
        }

        @NotNull
        public JsbtTaskFetchException getJsbtTaskFetchException() {
            JsbtTaskFetchException jsbtTaskFetchException = this.myCause;
            if (jsbtTaskFetchException == null) {
                WrapperException.$$$reportNull$$$0(2);
            }
            return jsbtTaskFetchException;
        }

        @NotNull
        public JsbtFileStructure getEmptyFileStructure() {
            JsbtFileStructure jsbtFileStructure = this.myEmptyFileStructure;
            if (jsbtFileStructure == null) {
                WrapperException.$$$reportNull$$$0(3);
            }
            return jsbtFileStructure;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException$WrapperException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException$WrapperException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJsbtTaskFetchException";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptyFileStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

