/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import org.jetbrains.idea.maven.execution.RunnerBundle;

public class MavenExecutionOptions {

    public static enum ChecksumPolicy {
        NOT_SET("maven.checksum.nopolicy", ""),
        FAIL("maven.checksum.fail", "--strict-checksums"),
        WARN("maven.checksum.warn", "--lax-checksums");

        private final String myMessageKey;
        private final String myCommandLineOption;

        private ChecksumPolicy(String messageKey, String commandLineOption) {
            this.myMessageKey = messageKey;
            this.myCommandLineOption = commandLineOption;
        }

        public String getDisplayString() {
            return RunnerBundle.message(this.myMessageKey, new Object[0]);
        }

        public String getCommandLineOption() {
            return this.myCommandLineOption;
        }
    }

    public static enum FailureMode {
        NOT_SET("maven.failure.mode.default", ""),
        FAST("maven.failure.mode.failfast", "--fail-fast"),
        AT_END("maven.failure.mode.failend", "--fail-at-end"),
        NEVER("maven.failure.mode.never", "--fail-never");

        private final String myMessageKey;
        private final String myCommandLineOption;

        private FailureMode(String messageKey, String commandLineOption) {
            this.myMessageKey = messageKey;
            this.myCommandLineOption = commandLineOption;
        }

        public String getDisplayString() {
            return RunnerBundle.message(this.myMessageKey, new Object[0]);
        }

        public String getCommandLineOption() {
            return this.myCommandLineOption;
        }
    }

    public static enum LoggingLevel {
        DEBUG("maven.log.level.debug", 0),
        INFO("maven.log.level.info", 1),
        WARN("maven.log.level.warn", 2),
        ERROR("maven.log.level.error", 3),
        FATAL("maven.log.level.fatal", 4),
        DISABLED("maven.log.level.disabled", 5);

        private final String myMessageKey;
        private final int myLevel;

        private LoggingLevel(String messageKey, int level) {
            this.myMessageKey = messageKey;
            this.myLevel = level;
        }

        public String getDisplayString() {
            return RunnerBundle.message(this.myMessageKey, new Object[0]);
        }

        public int getLevel() {
            return this.myLevel;
        }
    }
}

