/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.substring;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.substring.ReplaceSubstringInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/substring/ReplaceSubstringWithDropLastInspection;", "Lorg/jetbrains/kotlin/idea/inspections/substring/ReplaceSubstringInspection;", "<init>", "()V", "inspectionText", "", "element", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableInner", "", "isLengthAccess", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedReceiver", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReplaceSubstringWithDropLastInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceSubstringWithDropLastInspection.kt\norg/jetbrains/kotlin/idea/inspections/substring/ReplaceSubstringWithDropLastInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class ReplaceSubstringWithDropLastInspection
extends ReplaceSubstringInspection {
    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"inspection.replace.substring.with.drop.last.display.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"replace.substring.call.with.droplast.call", (Object[])new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = UtilsKt.getCallExpression((KtQualifiedExpression)element);
        if (object == null || (object = object.getValueArguments()) == null || (object = (KtValueArgument)CollectionsKt.getOrNull((List)object, (int)1)) == null || (object = object.getArgumentExpression()) == null) {
            return;
        }
        Object argument2 = object;
        KtBinaryExpression ktBinaryExpression = argument2 instanceof KtBinaryExpression ? (KtBinaryExpression)argument2 : null;
        if (ktBinaryExpression == null || (ktBinaryExpression = ktBinaryExpression.getRight()) == null) {
            return;
        }
        KtBinaryExpression rightExpression = ktBinaryExpression;
        this.replaceWith(element, "$0.dropLast($1)", (KtExpression)rightExpression);
    }

    @Override
    protected boolean isApplicableInner(@NotNull KtDotQualifiedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = UtilsKt.getCallExpression((KtQualifiedExpression)element);
        if (object == null || (object = object.getValueArguments()) == null) {
            return false;
        }
        Object arguments2 = object;
        if (arguments2.size() != 2 || !this.isFirstArgumentZero(element)) {
            return false;
        }
        KtExpression ktExpression = ((KtValueArgument)arguments2.get(1)).getArgumentExpression();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression secondArgumentExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)secondArgumentExpression.getOperationReference().getReferencedNameElementType(), (Object)KtTokens.MINUS)) {
            return false;
        }
        return this.isLengthAccess(secondArgumentExpression.getLeft(), element.getReceiverExpression());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLengthAccess(KtExpression expression, KtExpression expectedReceiver) {
        if (!(expression instanceof KtDotQualifiedExpression)) return false;
        KtExpression it = ((KtDotQualifiedExpression)expression).getSelectorExpression();
        boolean bl = false;
        if (!(it instanceof KtNameReferenceExpression)) return false;
        if (!Intrinsics.areEqual((Object)((KtNameReferenceExpression)it).getReferencedName(), (Object)"length")) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (!org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt.isSimplifiableTo(((KtDotQualifiedExpression)expression).getReceiverExpression(), expectedReceiver)) return false;
        return true;
    }
}

