/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.ContinuationVariableValueDescriptorImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineScopeExtractor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010 \u001a\u00020!J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0016J\u000f\u0010#\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0012H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineStackFrameProxyImpl;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameProxyImpl;", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "threadProxy", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "stackFrame", "Lcom/sun/jdi/StackFrame;", "indexFromBottom", "", "<init>", "(Lcom/sun/jdi/Location;Ljava/util/List;Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/sun/jdi/StackFrame;I)V", "getSpilledVariables", "()Ljava/util/List;", "continuation", "Lcom/sun/jdi/ObjectReference;", "Lorg/jetbrains/annotations/Nullable;", "getContinuation", "()Lcom/sun/jdi/ObjectReference;", "coroutineScope", "getCoroutineScope", "coroutineScope$delegate", "Lkotlin/Lazy;", "updateSpilledVariableValue", "", "name", "", "value", "Lcom/sun/jdi/Value;", "isCoroutineScopeAvailable", "", "thisObject", "dispatchReceiver", "extractCoroutineScope", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\ncoroutineStackFrameProxys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineStackFrameProxys.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineStackFrameProxyImpl\n+ 2 safeUtil.kt\norg/jetbrains/kotlin/idea/debugger/base/util/SafeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,89:1\n161#2,4:90\n1#3:94\n1#3:96\n11#4:95\n12#4:97\n*S KotlinDebug\n*F\n+ 1 coroutineStackFrameProxys.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineStackFrameProxyImpl\n*L\n35#1:90,4\n61#1:96\n61#1:95\n61#1:97\n*E\n"})
public final class CoroutineStackFrameProxyImpl
extends KotlinStackFrameProxyImpl {
    @Nullable
    private final Location location;
    @NotNull
    private final List<JavaValue> spilledVariables;
    @Nullable
    private final ObjectReference continuation;
    @NotNull
    private final Lazy coroutineScope$delegate;

    public CoroutineStackFrameProxyImpl(@Nullable Location location, @NotNull List<? extends JavaValue> spilledVariables, @NotNull ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame stackFrame, int indexFromBottom) {
        ObjectReference objectReference;
        Intrinsics.checkNotNullParameter(spilledVariables, (String)"spilledVariables");
        Intrinsics.checkNotNullParameter((Object)threadProxy, (String)"threadProxy");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        super(threadProxy, stackFrame, indexFromBottom);
        this.location = location;
        this.spilledVariables = spilledVariables;
        CoroutineStackFrameProxyImpl coroutineStackFrameProxyImpl = this;
        boolean $i$f$wrapEvaluateException = false;
        try {
            boolean bl = false;
            objectReference = super.thisObject();
        }
        catch (EvaluateException e$iv) {
            objectReference = null;
        }
        coroutineStackFrameProxyImpl.continuation = objectReference;
        this.coroutineScope$delegate = LazyKt.lazy(() -> CoroutineStackFrameProxyImpl.coroutineScope_delegate$lambda$1(this));
    }

    @NotNull
    public final List<JavaValue> getSpilledVariables() {
        return this.spilledVariables;
    }

    @Nullable
    public final ObjectReference getContinuation() {
        return this.continuation;
    }

    private final ObjectReference getCoroutineScope() {
        Lazy lazy = this.coroutineScope$delegate;
        return (ObjectReference)lazy.getValue();
    }

    public final void updateSpilledVariableValue(@NotNull String name2, @Nullable Value value) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Iterable iterable = this.spilledVariables;
            for (Object t : iterable) {
                JavaValue it = (JavaValue)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        JavaValue javaValue = v0;
        ValueDescriptorImpl valueDescriptorImpl = javaValue != null ? javaValue.getDescriptor() : null;
        ContinuationVariableValueDescriptorImpl continuationVariableValueDescriptorImpl = valueDescriptorImpl instanceof ContinuationVariableValueDescriptorImpl ? (ContinuationVariableValueDescriptorImpl)valueDescriptorImpl : null;
        if (continuationVariableValueDescriptorImpl == null) {
            return;
        }
        ContinuationVariableValueDescriptorImpl descriptor2 = continuationVariableValueDescriptorImpl;
        descriptor2.updateValue(value);
    }

    public final boolean isCoroutineScopeAvailable() {
        return this.getCoroutineScope() != null;
    }

    @Nullable
    public Location location() {
        return this.location;
    }

    @Nullable
    public ObjectReference thisObject() {
        ObjectReference objectReference = this.getCoroutineScope();
        if (objectReference == null) {
            objectReference = this.continuation;
        }
        return objectReference;
    }

    @Override
    @Nullable
    public ObjectReference dispatchReceiver() {
        return this.continuation;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectReference extractCoroutineScope() {
        Object object;
        void $this$getOrCreateUserData$iv;
        if (this.continuation == null) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = this.getVirtualMachine().getDebugProcess();
        Object object2 = debugProcessImpl instanceof DebugProcessImpl ? debugProcessImpl : null;
        if (object2 == null) {
            return null;
        }
        DebugProcessImpl debugProcess = object2;
        SuspendContextImpl suspendContextImpl = SuspendManagerUtil.getContextForEvaluation((SuspendManager)debugProcess.getSuspendManager());
        if (suspendContextImpl == null) {
            return null;
        }
        SuspendContextImpl suspendContext = suspendContextImpl;
        EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, (StackFrameProxyImpl)this);
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.getVirtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"getVirtualMachine(...)");
        UserDataHolderEx userDataHolderEx = (UserDataHolderEx)virtualMachineProxyImpl;
        Key<CoroutineScopeExtractor> key$iv = CoroutineScopeExtractor.Companion.getKEY();
        boolean $i$f$getOrCreateUserData = false;
        Object object3 = $this$getOrCreateUserData$iv.getUserData(key$iv);
        if (object3 != null) {
            Object it$iv = object3;
            boolean bl = false;
            object = it$iv;
        } else {
            Key<CoroutineScopeExtractor> key = key$iv;
            void var11_10 = $this$getOrCreateUserData$iv;
            boolean bl = false;
            CoroutineScopeExtractor coroutineScopeExtractor = CoroutineScopeExtractor.Companion.create((EvaluationContext)evaluationContext);
            Object object4 = var11_10.putUserDataIfAbsent(key, (Object)coroutineScopeExtractor);
            object = object4;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"putUserDataIfAbsent(...)");
        }
        CoroutineScopeExtractor extractor2 = (CoroutineScopeExtractor)object;
        return extractor2.extractCoroutineScope(this.continuation, (EvaluationContext)evaluationContext);
    }

    private static final ObjectReference coroutineScope_delegate$lambda$1(CoroutineStackFrameProxyImpl this$0) {
        return this$0.extractCoroutineScope();
    }
}

