/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.PluginUpdateStatus;
import org.jetbrains.kotlin.idea.StandalonePluginUpdateChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000 <2\u00020\u0001:\u0001<B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020#J\u001c\u0010$\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e0&H\u0004J\u001c\u0010'\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e0&H\u0004J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005H\u0002J\b\u0010+\u001a\u00020)H\u0002J\b\u0010,\u001a\u00020\u0011H\u0002J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0005H\u0002J\u001a\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u00101\u001a\u00020#H\u0002J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020!H\u0002J>\u00104\u001a\u00020#2\u0006\u00103\u001a\u00020!2\u000e\b\u0002\u00105\u001a\b\u0012\u0004\u0012\u00020#062\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u00020#062\u000e\b\u0002\u00108\u001a\b\u0012\u0004\u0012\u00020#06J\u0012\u00109\u001a\u00020#2\b\u0010:\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010;\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/idea/StandalonePluginUpdateChecker;", "Lcom/intellij/openapi/Disposable;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "updateTimestampProperty", "", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "notificationIcon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/extensions/PluginId;Ljava/lang/String;Lcom/intellij/notification/NotificationGroup;Ljavax/swing/Icon;)V", "getPluginId", "()Lcom/intellij/openapi/extensions/PluginId;", "alarm", "Lcom/intellij/util/Alarm;", "lastUpdateStatus", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus;", "getLastUpdateStatus", "()Lorg/jetbrains/kotlin/idea/PluginUpdateStatus;", "setLastUpdateStatus", "(Lorg/jetbrains/kotlin/idea/PluginUpdateStatus;)V", "updateDelay", "", "checkQueued", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentVersion", "getCurrentVersion", "()Ljava/lang/String;", "skipUpdateCheck", "", "verifyUpdate", "status", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus$Update;", "pluginUsed", "", "queueUpdateCheck", "callback", "Lkotlin/Function1;", "updateCheck", "initPluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "newVersion", "findPluginDescriptor", "checkUpdatesInMainRepository", "checkUpdatesInCustomRepository", "host", "updateIfNotLatest", "newPlugin", "recordSuccessfulUpdateCheck", "notifyPluginUpdateAvailable", "update", "installPluginUpdate", "successCallback", "Lkotlin/Function0;", "cancelCallback", "errorCallback", "notifyNotInstalled", "message", "dispose", "Companion", "kotlin.plugin-updater"})
public class StandalonePluginUpdateChecker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginId pluginId;
    @NotNull
    private final String updateTimestampProperty;
    @Nullable
    private final NotificationGroup notificationGroup;
    @Nullable
    private final Icon notificationIcon;
    @NotNull
    private final Alarm alarm;
    @Nullable
    private volatile PluginUpdateStatus lastUpdateStatus;
    private volatile long updateDelay;
    @NotNull
    private final AtomicBoolean checkQueued;
    private static final long INITIAL_UPDATE_DELAY = 2000L;
    private static final long CACHED_REQUEST_DELAY = TimeUnit.DAYS.toMillis(1L);
    @NotNull
    private static final Logger LOG;

    public StandalonePluginUpdateChecker(@NotNull PluginId pluginId, @NotNull String updateTimestampProperty, @Nullable NotificationGroup notificationGroup, @Nullable Icon notificationIcon) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)updateTimestampProperty, (String)"updateTimestampProperty");
        this.pluginId = pluginId;
        this.updateTimestampProperty = updateTimestampProperty;
        this.notificationGroup = notificationGroup;
        this.notificationIcon = notificationIcon;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.updateDelay = 2000L;
        this.checkQueued = new AtomicBoolean(false);
    }

    @NotNull
    public final PluginId getPluginId() {
        return this.pluginId;
    }

    @Nullable
    protected final PluginUpdateStatus getLastUpdateStatus() {
        return this.lastUpdateStatus;
    }

    protected final void setLastUpdateStatus(@Nullable PluginUpdateStatus pluginUpdateStatus) {
        this.lastUpdateStatus = pluginUpdateStatus;
    }

    @NotNull
    public String getCurrentVersion() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)this.pluginId);
        Intrinsics.checkNotNull((Object)ideaPluginDescriptor);
        String string = ideaPluginDescriptor.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        return string;
    }

    public boolean skipUpdateCheck() {
        return false;
    }

    @NotNull
    public PluginUpdateStatus verifyUpdate(@NotNull PluginUpdateStatus.Update status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return status;
    }

    public final void pluginUsed() {
        if (!UpdateSettings.getInstance().isPluginsCheckNeeded()) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        long lastUpdateTime = PropertiesComponent.getInstance().getLong(this.updateTimestampProperty, 0L);
        if (lastUpdateTime == 0L || System.currentTimeMillis() - lastUpdateTime > CACHED_REQUEST_DELAY) {
            this.queueUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)arg_0 -> StandalonePluginUpdateChecker.pluginUsed$lambda$0(this, arg_0)));
        }
    }

    protected final void queueUpdateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.checkQueued.compareAndSet(false, true)) {
            this.alarm.addRequest(() -> StandalonePluginUpdateChecker.queueUpdateCheck$lambda$1(this, callback2), this.updateDelay);
            this.updateDelay *= (long)2;
        }
    }

    protected final void updateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Ref.ObjectRef updateStatus = new Ref.ObjectRef();
        if (this.skipUpdateCheck()) {
            updateStatus.element = PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        } else {
            try {
                updateStatus.element = this.checkUpdatesInMainRepository();
                for (Object e : RepositoryHelper.getCustomPluginRepositoryHosts()) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    String host = (String)e;
                    PluginUpdateStatus customUpdateStatus = this.checkUpdatesInCustomRepository(host);
                    updateStatus.element = ((PluginUpdateStatus)updateStatus.element).mergeWith(customUpdateStatus);
                }
            }
            catch (Exception e) {
                String string = IdeBundle.message((String)"plugin.updater.error.check.failed", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                updateStatus.element = PluginUpdateStatus.Companion.fromException(string, e);
            }
        }
        this.lastUpdateStatus = (PluginUpdateStatus)updateStatus.element;
        if (updateStatus.element instanceof PluginUpdateStatus.Update) {
            updateStatus.element = this.verifyUpdate((PluginUpdateStatus.Update)updateStatus.element);
        }
        if (!(updateStatus.element instanceof PluginUpdateStatus.CheckFailed)) {
            this.recordSuccessfulUpdateCheck();
        }
        ApplicationManager.getApplication().invokeLater(() -> StandalonePluginUpdateChecker.updateCheck$lambda$2(callback2, updateStatus), ModalityState.any());
    }

    private final IdeaPluginDescriptor initPluginDescriptor(String newVersion) {
        PluginNode pluginNode;
        IdeaPluginDescriptor originalPlugin = this.findPluginDescriptor();
        PluginNode $this$initPluginDescriptor_u24lambda_u243 = pluginNode = new PluginNode(this.pluginId);
        boolean bl = false;
        $this$initPluginDescriptor_u24lambda_u243.setVersion(newVersion);
        $this$initPluginDescriptor_u24lambda_u243.setName(originalPlugin.getName());
        $this$initPluginDescriptor_u24lambda_u243.setDescription(originalPlugin.getDescription());
        return (IdeaPluginDescriptor)pluginNode;
    }

    private final IdeaPluginDescriptor findPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)this.pluginId);
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException(("Plugin ID " + this.pluginId + " not found when checking updates").toString());
        }
        return ideaPluginDescriptor;
    }

    private final PluginUpdateStatus checkUpdatesInMainRepository() {
        String string;
        Element element;
        Element element2;
        Element responseDoc;
        String string2 = ApplicationInfo.getInstance().getApiVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getApiVersion(...)");
        String buildNumber = string2;
        String os = URLEncoder.encode(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, "UTF-8");
        String string3 = PermanentInstallationID.get();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
        String uid = string3;
        String pluginId = this.pluginId.getIdString();
        String url = "https://plugins.jetbrains.com/plugins/list?pluginId=" + pluginId + "&build=" + buildNumber + "&pluginVersion=" + this.getCurrentVersion() + "&os=" + os + "&uuid=" + uid;
        String machineId = MachineIdManager.INSTANCE.getAnonymizedMachineId("JetBrainsUpdates");
        if (machineId != null) {
            url = url + "&mid=" + machineId;
        }
        if (!Intrinsics.areEqual((Object)(responseDoc = (Element)HttpRequests.request((String)url).connect(StandalonePluginUpdateChecker::checkUpdatesInMainRepository$lambda$4)).getName(), (Object)"plugin-repository")) {
            String string4 = IdeBundle.message((String)"plugin.updater.error.unexpected.repository.response", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            return new PluginUpdateStatus.CheckFailed(string4, JDOMUtil.writeElement((Element)responseDoc, (String)"\n"));
        }
        if (responseDoc.getChildren().isEmpty()) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        Element element3 = responseDoc.getChild("category");
        if (element3 == null || (element2 = element3.getChild("idea-plugin")) == null || (element = element2.getChild("version")) == null || (string = element.getText()) == null) {
            String string5 = IdeBundle.message((String)"plugin.updater.error.cant.find.plugin.version", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            return new PluginUpdateStatus.CheckFailed(string5, JDOMUtil.writeElement((Element)responseDoc, (String)"\n"));
        }
        String newVersion = string;
        IdeaPluginDescriptor pluginDescriptor = this.initPluginDescriptor(newVersion);
        return this.updateIfNotLatest(pluginDescriptor, null);
    }

    /*
     * Unable to fully structure code
     */
    private final PluginUpdateStatus checkUpdatesInCustomRepository(String host) {
        block6: {
            try {
                var4_2 = RepositoryHelper.loadPlugins((String)host, null, null);
            }
            catch (Exception e) {
                var7_4 = new Object[]{host};
                v0 = IdeBundle.message((String)"plugin.updater.error.custom.repository", (Object[])var7_4);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(...)");
                return PluginUpdateStatus.Companion.fromException(v0, e);
            }
            var3_6 = var4_2;
            Intrinsics.checkNotNull((Object)var3_6);
            plugins = var3_6;
            var6_8 = plugins;
            for (T var8_9 : var6_8) {
                pluginDescriptor = (PluginNode)var8_9;
                $i$a$-find-StandalonePluginUpdateChecker$checkUpdatesInCustomRepository$newPlugin$1 = false;
                if (!Intrinsics.areEqual((Object)pluginDescriptor.getPluginId(), (Object)this.pluginId)) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)pluginDescriptor);
                if (PluginManagerCore.isCompatible((IdeaPluginDescriptor)((IdeaPluginDescriptor)pluginDescriptor))) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = var8_9;
                break block6;
            }
            v2 = null;
        }
        v3 = v2;
        if (v3 == null) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        newPlugin = v3;
        return this.updateIfNotLatest((IdeaPluginDescriptor)newPlugin, host);
    }

    private final PluginUpdateStatus updateIfNotLatest(IdeaPluginDescriptor newPlugin, String host) {
        if (VersionComparatorUtil.compare((String)newPlugin.getVersion(), (String)this.getCurrentVersion()) <= 0) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        return new PluginUpdateStatus.Update(newPlugin, host);
    }

    private final void recordSuccessfulUpdateCheck() {
        PropertiesComponent.getInstance().setValue(this.updateTimestampProperty, String.valueOf(System.currentTimeMillis()));
        this.updateDelay = 2000L;
    }

    private final void notifyPluginUpdateAvailable(PluginUpdateStatus.Update update2) {
        if (this.notificationGroup == null) {
            return;
        }
        String pluginName = this.findPluginDescriptor().getName();
        Intrinsics.checkNotNull((Object)pluginName);
        Object[] objectArray = new Object[]{update2.getPluginDescriptor().getVersion(), pluginName};
        String string = IdeBundle.message((String)"plugin.updater.notification.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.notificationGroup.createNotification(pluginName, string, NotificationType.INFORMATION).setSuggestionType(true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"plugin.updater.install", (Object[])new Object[0]), () -> StandalonePluginUpdateChecker.notifyPluginUpdateAvailable$lambda$7(this, update2))).setIcon(this.notificationIcon).notify(null);
    }

    public final void installPluginUpdate(@NotNull PluginUpdateStatus.Update update2, @NotNull Function0<Unit> successCallback, @NotNull Function0<Unit> cancelCallback, @NotNull Function0<Unit> errorCallback) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Intrinsics.checkNotNullParameter(successCallback, (String)"successCallback");
        Intrinsics.checkNotNullParameter(cancelCallback, (String)"cancelCallback");
        Intrinsics.checkNotNullParameter(errorCallback, (String)"errorCallback");
        IdeaPluginDescriptor descriptor2 = update2.getPluginDescriptor();
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor2, (String)update2.getHostToInstallFrom(), null);
        Intrinsics.checkNotNullExpressionValue((Object)pluginDownloader, (String)"createDownloader(...)");
        PluginDownloader pluginDownloader2 = pluginDownloader;
        String string = IdeBundle.message((String)"plugin.updater.downloading", (Object[])new Object[0]);
        PluginManagerUISettings pluginManagerUISettings = PluginManagerUISettings.getInstance();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(pluginDownloader2, errorCallback, this, successCallback, cancelCallback, string, pluginManagerUISettings){
            final /* synthetic */ PluginDownloader $pluginDownloader;
            final /* synthetic */ Function0<Unit> $errorCallback;
            final /* synthetic */ StandalonePluginUpdateChecker this$0;
            final /* synthetic */ Function0<Unit> $successCallback;
            final /* synthetic */ Function0<Unit> $cancelCallback;
            {
                this.$pluginDownloader = $pluginDownloader;
                this.$errorCallback = $errorCallback;
                this.this$0 = $receiver;
                this.$successCallback = $successCallback;
                this.$cancelCallback = $cancelCallback;
                super(null, $super_call_param$1, true, (PerformInBackgroundOption)$super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Ref.BooleanRef installed = new Ref.BooleanRef();
                Ref.ObjectRef message2 = new Ref.ObjectRef();
                try {
                    bl = this.$pluginDownloader.prepareToInstall(indicator);
                }
                catch (IOException e) {
                    StandalonePluginUpdateChecker.access$getLOG$cp().info((Throwable)e);
                    message2.element = e.getMessage();
                    bl = false;
                }
                boolean prepareResult = bl;
                if (prepareResult) {
                    installed.element = true;
                    this.$pluginDownloader.install();
                    ApplicationManager.getApplication().invokeLater(installPluginUpdate.4::run$lambda$0);
                }
                ApplicationManager.getApplication().invokeLater(() -> installPluginUpdate.4.run$lambda$1(installed, this.$errorCallback, this.this$0, message2, this.$successCallback));
            }

            public void onCancel() {
                this.$cancelCallback.invoke();
            }

            private static final void run$lambda$0() {
                PluginManagerMain.notifyPluginsUpdated(null);
            }

            private static final void run$lambda$1(Ref.BooleanRef $installed, Function0 $errorCallback, StandalonePluginUpdateChecker this$0, Ref.ObjectRef $message, Function0 $successCallback) {
                if (!$installed.element) {
                    $errorCallback.invoke();
                    StandalonePluginUpdateChecker.access$notifyNotInstalled(this$0, (String)$message.element);
                } else {
                    $successCallback.invoke();
                }
            }
        });
    }

    public static /* synthetic */ void installPluginUpdate$default(StandalonePluginUpdateChecker standalonePluginUpdateChecker, PluginUpdateStatus.Update update2, Function0 function0, Function0 function02, Function0 function03, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: installPluginUpdate");
        }
        if ((n & 2) != 0) {
            function0 = StandalonePluginUpdateChecker::installPluginUpdate$lambda$8;
        }
        if ((n & 4) != 0) {
            function02 = StandalonePluginUpdateChecker::installPluginUpdate$lambda$9;
        }
        if ((n & 8) != 0) {
            function03 = StandalonePluginUpdateChecker::installPluginUpdate$lambda$10;
        }
        standalonePluginUpdateChecker.installPluginUpdate(update2, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
    }

    private final void notifyNotInstalled(String message2) {
        String string;
        if (this.notificationGroup == null) {
            return;
        }
        if (message2 == null) {
            string = IdeBundle.message((String)"plugin.updater.not.installed", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{message2};
            string = IdeBundle.message((String)"plugin.updater.not.installed.misc", (Object[])objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String content = string2;
        String string3 = this.findPluginDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        this.notificationGroup.createNotification(string3, content, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"plugin.updater.not.installed.see.log.action", (Object[])new Object[0]), StandalonePluginUpdateChecker::notifyNotInstalled$lambda$11)).notify(null);
    }

    public void dispose() {
    }

    private static final boolean pluginUsed$lambda$0(StandalonePluginUpdateChecker this$0, PluginUpdateStatus updateStatus) {
        block1: {
            PluginUpdateStatus pluginUpdateStatus;
            block0: {
                Intrinsics.checkNotNullParameter((Object)updateStatus, (String)"updateStatus");
                pluginUpdateStatus = updateStatus;
                if (!(pluginUpdateStatus instanceof PluginUpdateStatus.Update)) break block0;
                this$0.notifyPluginUpdateAvailable((PluginUpdateStatus.Update)updateStatus);
                break block1;
            }
            if (!(pluginUpdateStatus instanceof PluginUpdateStatus.CheckFailed)) break block1;
            LOG.info("Plugin update check failed: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getMessage() + ", details: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getDetail());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void queueUpdateCheck$lambda$1(StandalonePluginUpdateChecker this$0, Function1 $callback) {
        try {
            this$0.updateCheck((Function1<? super PluginUpdateStatus, Boolean>)$callback);
        }
        finally {
            this$0.checkQueued.set(false);
        }
    }

    private static final void updateCheck$lambda$2(Function1 $callback, Ref.ObjectRef $updateStatus) {
        $callback.invoke($updateStatus.element);
    }

    private static final Element checkUpdatesInMainRepository$lambda$4(HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JDOMUtil.load((InputStream)it.getInputStream());
    }

    private static final Unit notifyPluginUpdateAvailable$lambda$7$lambda$6(StandalonePluginUpdateChecker this$0, PluginUpdateStatus.Update $update) {
        this$0.notifyPluginUpdateAvailable($update);
        return Unit.INSTANCE;
    }

    private static final void notifyPluginUpdateAvailable$lambda$7(StandalonePluginUpdateChecker this$0, PluginUpdateStatus.Update $update) {
        StandalonePluginUpdateChecker.installPluginUpdate$default(this$0, $update, null, null, () -> StandalonePluginUpdateChecker.notifyPluginUpdateAvailable$lambda$7$lambda$6(this$0, $update), 6, null);
    }

    private static final Unit installPluginUpdate$lambda$8() {
        return Unit.INSTANCE;
    }

    private static final Unit installPluginUpdate$lambda$9() {
        return Unit.INSTANCE;
    }

    private static final Unit installPluginUpdate$lambda$10() {
        return Unit.INSTANCE;
    }

    private static final void notifyNotInstalled$lambda$11() {
        ShowLogAction.showLog();
    }

    protected static final long getCACHED_REQUEST_DELAY() {
        return Companion.getCACHED_REQUEST_DELAY();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$notifyNotInstalled(StandalonePluginUpdateChecker $this, String message2) {
        $this.notifyNotInstalled(message2);
    }

    static {
        Logger logger = Logger.getInstance(StandalonePluginUpdateChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/StandalonePluginUpdateChecker$Companion;", "", "<init>", "()V", "INITIAL_UPDATE_DELAY", "", "CACHED_REQUEST_DELAY", "getCACHED_REQUEST_DELAY$annotations", "getCACHED_REQUEST_DELAY", "()J", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.plugin-updater"})
    public static final class Companion {
        private Companion() {
        }

        protected final long getCACHED_REQUEST_DELAY() {
            return CACHED_REQUEST_DELAY;
        }

        @JvmStatic
        protected static /* synthetic */ void getCACHED_REQUEST_DELAY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

