/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteArraySet;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteCollections;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import java.io.Serializable;
import java.util.Set;

public final class ByteSets {
    public static final EmptySet EMPTY_SET = new EmptySet();
    static final ByteSet UNMODIFIABLE_EMPTY_SET = ByteSets.unmodifiable(new ByteArraySet(ByteArrays.EMPTY_ARRAY));

    public static ByteSet unmodifiable(ByteSet s) {
        return new UnmodifiableSet(s);
    }

    public static class EmptySet
    extends ByteCollections.EmptyCollection
    implements ByteSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public boolean remove(byte ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        @Override
        @Deprecated
        public boolean rem(byte k) {
            return super.rem(k);
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    public static class UnmodifiableSet
    extends ByteCollections.UnmodifiableCollection
    implements ByteSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(ByteSet s) {
            super(s);
        }

        @Override
        public boolean remove(byte k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.collection.equals(o);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        @Deprecated
        public boolean rem(byte k) {
            return super.rem(k);
        }
    }
}

